#ifndef __INCLUDED_DIA_FACTORY_PLUGIN__
#define __INCLUDED_DIA_FACTORY_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_COMMON_FACTORY__
#include "dia_common_factory.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include <common/framework/application/dia_Lock.h>
#endif

class dia_FactoryPlugin
{
public:
   //! class constructor
   dia_FactoryPlugin ( tCString name, dia_eFactoryPluginType type );
   dia_FactoryPlugin ( tCString name );
   //! class destructor
   virtual ~dia_FactoryPlugin ( void );

   //! retrieve the levels name
   virtual tCString getName ( void ) const;
   //! return the remote control type of the plugin
   dia_UID getUID ( void ) const;

   //! add a submodule (remind that type has to match, otherwise it will be rejected)
// tDiaResult addFactoryPlugin ( dia_FactoryPlugin& plugin );

   //! setup (create objects,...)
   virtual tDiaResult setup ( dia_enInitLevel level ) = 0;
   //! tear down (destroy objects,...)
   virtual tDiaResult tearDown ( dia_enInitLevel level ) = 0;

   virtual dia_enInitLevel getInitializationLevel ( void ) const { return mActiveLevel; }

protected:
   //! deprecated default constructor
   dia_FactoryPlugin ( void );

   virtual void setInitializationLevel ( dia_enInitLevel level ) { mActiveLevel = level; }

protected:
   //! name of this factory plugin
   tCString mName;
   //! ID of this factory plugin
   dia_UID mUID;
   //! current initialization level of the diagnosis application
   dia_enInitLevel mActiveLevel;
   // synchronization lock object.
   dia_Lock mSyncObj;
   //! vector of submodules controlled by this plugin (composite
// std::vector<dia_FactoryPlugin*> mSubmodules;
};

#endif
