/**
 * \file    dia_Session.h
 *
 * \brief   This file contains the definition of the dia_Session class, that
 *          provides services related to a particular diagnostic session.
 *
 * \author  gib2hi
 * \date    2012/05/09
 *
 * \copyright Robert Bosch Car Multimedia 2012
 */

#ifndef __INCLUDED_DIA_SESSION__
#define __INCLUDED_DIA_SESSION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

class dia_EngineServer;

/**
 * \class   dia_Session
 *
 * \brief   This class implements the concept of a diagnostic session
 *
 *          This class provides a generic service handler that can be used to process
 *          identification requests that need to write one or more properties into
 *          the ConfigManager module.
 *
 * \ingroup diaCoreEngine
 */

class dia_Session
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_Session);

public:
   //! class constructor
   dia_Session ( tU8 sessionID, dia_EngineServer& engine );
   //! class destructor
   virtual ~dia_Session ( void );

   tU8 getID ( void ) const { return mID; }
   tBool isActive ( void ) const { return mIsActive; }

   //! get the event mask of this session
   OSAL_tEventMask getEvent ( void ) const { return mEventMask; }
   //! set an event for this session
   friend tDiaResult dia_SessionController::setSessionEvent( OSAL_tEventMask mask, OSAL_tenEventMaskFlag enFlags );

   //! assign the dispatcher object to be used for this session
   tDiaResult setEngine ( dia_EngineServer& engine );
   //! retrieve the dispatcher object used by this session
   dia_EngineServer* getEngine ( void ) const { return mpEngine; }

   //! assign the dispatcher object to be used for this session
//   tDiaResult setDispatcher ( dia_ServiceDispatcher* pDispatcher );
   //! retrieve the dispatcher object used by this session
   dia_ServiceDispatcher* getDispatcher ( void );

//   //! method used to populate the engine with service handlers
//   tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, void* p1=0, void* p2=0 );

   //! method that can be overloaded by subclasses to perform specific task when the session is entered
   virtual tDiaResult onEnterSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is left
   virtual tDiaResult onLeaveSession ( void );
   //! method that can be overloaded by subclasses to perform specific task when the session is deactivated/reset
   virtual tDiaResult onResetSession ( void );

   //! returns additional (project specific) parameters for the response
   virtual tDiaResult getResponseParameters ( std::vector<tU8>& /*responseData*/ ) { return DIA_SUCCESS; }

//protected:
   //! deprecated class constructor
   dia_Session ( void );
//   //! class constructor
//   dia_Session ( tU8 sessionID );

protected:
   //! session identifier
   tU8 mID;
   //! flag to indicate if this session is currently activated
   tBool mIsActive;
   //! session events
   OSAL_tEventMask mEventMask;
   //! reference to the associated engine
   dia_EngineServer* mpEngine;
   //! service dispatcher used by this session
   dia_ServiceDispatcher* mpDispatcher;
};

#endif /* __INCLUDED_DIA_SESSION__ */
