/**
 * \file    dia_ServiceDispatcher.h
 *
 * \brief   This file contains the definition of the  class
 *          that is responsible for the controlling the number of existing engines
 *          in the diagnosis application
 *
 * \author  gib2hi
 * \date    2012/04/11
 */

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#define __INCLUDED_DIA_SERVICE_DISPATCHER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

// forward declarations
class dia_LookupKey;
class dia_ServiceHandler;
class dia_MessageBuffer;

/**
 * \class   dia_ServiceDispatcher
 *
 * \brief   This class is responsible for controlling the number of engines existing
 *          in the diagnosis application
 *
 * \ingroup diaCoreEngine
 */

class dia_ServiceDispatcher
{
protected:

   //! internal struct used for key comparison
   struct tclKeyComparator
   {
      //! key comparison function
      bool operator () ( const dia_LookupKey* pKey1, const dia_LookupKey* pKey2) const;
   };

   //!
   struct dia_DispatchInfo
   {
      //! default class constructor
      dia_DispatchInfo ( void )
         : mpHandler(0)
      {
      }

      //! class constructor
      dia_DispatchInfo ( dia_ServiceHandler* pHandler )
         : mpHandler(pHandler)
      {
      }

      //! class constructor
      dia_DispatchInfo ( dia_ServiceHandler* pHandler, const std::vector<tArgsType>& vecArgs )
         : mpHandler(pHandler)
      {
         for ( tU16 i=0; i<vecArgs.size(); i++ ) {
            mArgs.push_back(vecArgs[i]);
         }
      }

      //! reset all info
      void vReset ( void ) { mArgs.clear(); mpHandler=0; }

      //! pointer to the handler that is linked to a certain key
      dia_ServiceHandler* mpHandler;
      //! vector of parameters that will be reported back to the handler
      std::vector<tArgsType> mArgs;
   };

public:
   //! default constructor
   dia_ServiceDispatcher ( void );
   //! class destructor
   virtual ~dia_ServiceDispatcher ( void );

#if 0
   //! add a service handler. Up to two parameters can be provided that will be reported back in case of incoming messages
   tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler );
   //! add a service handler. Up to two parameters can be provided that will be reported back in case of incoming messages
   tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<tArgsType>& vecArgs );
   //! add a service handler for the given sessions. Up to two parameters can be provided that will be reported back in case of incoming messages
   tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<tU8>& vecSessions, const std::vector<tArgsType>& vecArgs );
#endif
   //! add a service handler for the given sessions. Up to two parameters can be provided that will be reported back in case of incoming messages
   tDiaResult bAddServiceHandler ( dia_LookupKey* pKey, dia_ServiceHandler* pHandler, const std::vector<tArgsType>& vecArgs );

   //! remove service handler
   bool bRemoveServiceHandler ( dia_LookupKey* pKey, const dia_ServiceHandler* pHandler );

   void vProcessRequest ( void );

   //! return proper service handler
   dia_ServiceHandler* getServiceHandler ( dia_LookupKey* pKey=0 );

   tDiaResult setServiceHandler ( dia_ServiceHandler* pHandler, tArgsType arg1=0, tArgsType arg2=0 );
   tDiaResult resetServiceHandler ( void );

   tBool bIsServiceActive ( void ) const { return ( mActiveHandlerInfo.mpHandler != OSAL_NULL ) ? TRUE : FALSE; }

   //! dispatch a new received service to its corresponding service handler
   tDiaResult lookup ( const dia_MessageBuffer& msgBuffer );

   //! go through service handler repository and print all information about registered services.
   tDiaResult printAllServiceHandlers ( void ) const;

   //! get unique id
   virtual tU32 getID ( void ) const { return mID; }

protected:
   //! service handler repository
   std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator> mServiceHandlerRepository;

   //! active entry
   dia_DispatchInfo mActiveHandlerInfo;

   //! unique identifier
   static tU32 mID;
};

#endif

