/*
 * dia_Dispatcher.cpp
 *
 *  Created on: 11.04.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_UDS__
#include "common/framework/protocols/uds/dia_ServiceHandlerUDS.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER_WRAPPER__
#include <common/framework/engine/dia_ServiceHandlerWrapper.h>
#endif

#ifndef __INCLUDED_DIA_LOOKUPKEYUDS__
#include "common/framework/protocols/uds/dia_LookupKeyUDS.h"
#endif

#ifndef __DIA_UNIT_TESTING__
#ifndef __INCLUDED_DIA_LOOKUPKEYGMLAN__
#include "common/framework/protocols/gmlan/dia_LookupKeyGMLan.h"
#endif
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include <common/framework/engine/dia_ServiceDispatcher.h>
#endif

#ifndef __INCLUDED_DIA_NRC_GENERATOR__
#include <common/services/uds/generic/dia_NRCGenerator.h>
#endif

using namespace std;
using namespace dia;

tU32 dia_ServiceDispatcher::mID = 0;

//------------------------------------------------------------------------------

bool
dia_ServiceDispatcher::tclKeyComparator::operator () ( const dia_LookupKey* pKey1, const dia_LookupKey* pKey2 ) const
{
    return ((*pKey1) < (*pKey2));
}

//------------------------------------------------------------------------------

dia_ServiceDispatcher::dia_ServiceDispatcher ( void )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::dia_ServiceDispatcher()");
   mActiveHandlerInfo.vReset();
}

//------------------------------------------------------------------------------

dia_ServiceDispatcher::~dia_ServiceDispatcher ( void )
{
}

//------------------------------------------------------------------------------

#if 0

tDiaResult
dia_ServiceDispatcher::bAddServiceHandler ( dia_ServiceHandler* pHandler )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::bAddServiceHandler(pHandler)");
#endif

   tDiaResult retCode = DIA_FAILED;

   if ( pHandler )
   {
      std::vector<dia_LookupKey*> keys;

      if ( pHandler->makeLookupKeys(keys) == DIA_SUCCESS )
      {
#ifdef __DIA_UNIT_TESTING__
         DIA_TR_INF("ADDING KEYS TO LOOKUP TABLE FOR DISPATCHING INCOMING REQUESTS TO THE RIGHT SERVICE HANDLER ...");
#endif

         for ( tU16 i=0; i<keys.size(); i++ )
         {
            std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(keys[i]);
            if ( iter == mServiceHandlerRepository.end() )
            {
               // service handler does not exist so we can add it to the repository
               mServiceHandlerRepository[keys[i]] = OSAL_NEW dia_DispatchInfo(pHandler);
            }
            else
            {
               // this method does not overwrite existing entries
            }
         }

         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_INF("dia_ServiceDispatcher::bAddServiceHandler : FAILED TO RETRIEVE KEYS FROM SERVICE HANDLER !!!");
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<void*>& vecArgs )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::bAddServiceHandler(pHandler,vecArgs)");
#endif

   tDiaResult retCode = DIA_FAILED;

   if ( pHandler )
   {
      std::vector<dia_LookupKey*> keys;

      if ( pHandler->makeLookupKeys(keys) == DIA_SUCCESS )
      {
         for ( tU16 i=0; i<keys.size(); i++ )
         {
            //DIA_TR_INF("key[%02d]: SID=0x%02x DID=0x%04x", i, keys[i]->getSID(), keys[i]->getSubFuncID()) ;

            std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(keys[i]);
            if ( iter == mServiceHandlerRepository.end() )
            {
               // service handler does not exist so we can add it to the repository
               mServiceHandlerRepository[keys[i]] = OSAL_NEW dia_DispatchInfo(pHandler,vecArgs);
            }
            else
            {
               // this method does not overwrite existing entries
            }
         }

         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_INF("dia_ServiceDispatcher::bAddServiceHandler : FAILED TO RETRIEVE KEYS FROM SERVICE HANDLER !!!");
      }
   }

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<tU8>& /*vecSessions*/, const std::vector<void*>& vecArgs )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::bAddServiceHandler(dia_ServiceHandler* pHandler, tVoid* p1, tVoid* p2)");

   tDiaResult retCode = DIA_FAILED;

   if ( pHandler )
   {
      std::vector<dia_LookupKey*> keys;

      if ( pHandler->makeLookupKeys(keys) == DIA_SUCCESS )
      {
#ifdef __DIA_UNIT_TESTING__
         DIA_TR_INF("ADDING KEYS TO LOOKUP TABLE FOR DISPATCHING INCOMING REQUESTS TO THE RIGHT SERVICE HANDLER ...");
#endif

         for ( tU16 i=0; i<keys.size(); i++ )
         {
            //DIA_TR_INF("key[%02d]: SID=0x%02x DID=0x%04x", i, keys[i]->getSID(), keys[i]->getSubFuncID()) ;

            std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(keys[i]);
            if ( iter != mServiceHandlerRepository.end() ) {
               // service handler does already exist so we need to replace it
               DIA_TR_INF("REMOVING EXISTING KEY FROM LOOKUP TABLE ...");
               OSAL_DELETE mServiceHandlerRepository[keys[i]];
               mServiceHandlerRepository[keys[i]] = 0;
            }

            mServiceHandlerRepository[keys[i]] = OSAL_NEW dia_DispatchInfo(pHandler,vecArgs);
         }

         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_INF("dia_ServiceDispatcher::bAddServiceHandler : FAILED TO RETRIEVE KEYS FROM SERVICE HANDLER !!!");
      }
   }

   return retCode;
}

#endif

//------------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::bAddServiceHandler ( dia_LookupKey* pKey, dia_ServiceHandler* pHandler, const std::vector<tArgsType>& vecArgs )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::bAddServiceHandler(pKey,pHandler,vecArgs)");
#endif

   tDiaResult retCode = DIA_FAILED;

   if ( pKey && pHandler )
   {
#ifdef __DIA_UNIT_TESTING__
      DIA_TR_INF("key: SID=0x%02x DID=0x%04x", pKey->getSID(), pKey->getSubFuncID()) ;
#endif

      std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(pKey);

      if ( iter != mServiceHandlerRepository.end() ) {
         // service handler does already exist so we need to replace it
         DIA_TR_INF("REMOVING EXISTING KEY (SID=0x%02x DID=0x%04x) FROM LOOKUP TABLE ...", pKey->getSID(), pKey->getSubFuncID());
         OSAL_DELETE mServiceHandlerRepository[pKey];
         mServiceHandlerRepository[pKey] = 0;
      }

      mServiceHandlerRepository[pKey] = OSAL_NEW dia_DispatchInfo(pHandler,vecArgs);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

bool
dia_ServiceDispatcher::bRemoveServiceHandler ( dia_LookupKey* pKey, const dia_ServiceHandler* pHandler )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::bRemoveServiceHandler(...)");

    bool retCode = false;

    std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(pKey);

    if ( iter != mServiceHandlerRepository.end() ) {
      dia_DispatchInfo* pInfo = mServiceHandlerRepository[pKey];
        // service handler does exist so we remove it if it matches pHandler
      if ( pInfo->mpHandler == pHandler ) {
         mServiceHandlerRepository.erase(pKey);
         OSAL_DELETE pInfo;
         retCode = true;
      }
    }
    return retCode;
}

//------------------------------------------------------------------------------

void
dia_ServiceDispatcher::vProcessRequest ( void )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::vProcessRequest(...)");

   if ( mActiveHandlerInfo.mpHandler )
   {
//    DIA_TR_INF(" ### FORWARDING KEY TO SERVICE HANDLER ###");
      mActiveHandlerInfo.mpHandler->vProcessRequest(mActiveHandlerInfo.mArgs);
   }
}

//--------------------------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::lookup ( const dia_MessageBuffer& msgBuffer )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::lookup(...)");

   tDiaResult retCode = DIA_FAILED;
   dia_DispatchInfo* pInfo = 0;

   if ( msgBuffer.getProtocol() == DIA_EN_PROTOCOL_UDS )
   {
      DIA_TR_INF( "dia_ServiceDispatcher::lookup DIA_EN_PROTOCOL_UDS");
      dia_LookupKeyUDS key(msgBuffer);

      std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator it = mServiceHandlerRepository.find(&key);
      if ( it != mServiceHandlerRepository.end() )
      {
         DIA_TR_INF( "dia_ServiceDispatcher::lookup LookupKeyUDS found.");
         pInfo = it->second;
      }
      else
      {
         DIA_TR_INF( "dia_ServiceDispatcher::lookup LookupKeyUDS NOT FOUND. mServiceHandlerRepository.size()=%zu", mServiceHandlerRepository.size());

#ifdef __DIA_UNIT_TESTING__
         printAllServiceHandlers();
#endif
      }
   }
#ifndef __DIA_UNIT_TESTING__
   else if ( msgBuffer.getProtocol() == DIA_EN_PROTOCOL_GMLAN )
   {
      const dia_MessageBufferGMLan* pMsgBufferGMLan = (const dia_MessageBufferGMLan*) &msgBuffer;
      dia_LookupKeyGMLan key(*pMsgBufferGMLan);

      std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator it = mServiceHandlerRepository.find(&key);
      if ( it != mServiceHandlerRepository.end() )
      {
         pInfo = it->second;
      }
   }
#endif

   if ( pInfo )
   {
      mActiveHandlerInfo.mpHandler = OSAL_NEW dia_ServiceHandlerWrapper(pInfo->mpHandler);
      for ( tU16 i=0; i<pInfo->mArgs.size(); i++ ) {
         mActiveHandlerInfo.mArgs.push_back(pInfo->mArgs[i]);
      }
      DIA_TR_INF( "<--- Leaving dia_tclServiceDispatcher::lookup (found in map)");
      retCode = DIA_SUCCESS;
   }
   else
   {
      // cleanup
      OSAL_DELETE mActiveHandlerInfo.mpHandler;
      mActiveHandlerInfo.vReset();

      // not found in lookup table
      mActiveHandlerInfo.mpHandler = OSAL_NEW dia_ServiceHandlerWrapper(getInstanceOfNRCGenerator(DIA_E_SERVICE_HANDLER_NOT_AVAILABLE));

      DIA_TR_INF( "<--- Leaving dia_ServiceDispatcher::lookup (not found in map)");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::setServiceHandler ( dia_ServiceHandler* pHandler, tArgsType arg1, tArgsType arg2 )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::setServiceHandler(...)");

   tDiaResult retCode = DIA_FAILED;

   if ( pHandler )
   {
      // cleanup
      OSAL_DELETE mActiveHandlerInfo.mpHandler;
      mActiveHandlerInfo.vReset();

      // assign handler info
      mActiveHandlerInfo.mpHandler = pHandler;

      tU16 numArgs = 0;
      tArgsType vecArgs[DIA_C_U8_MAX_ARGS] = { 0 };
      if ( !isArgEmpty(arg1) ) { vecArgs[numArgs++] = arg1; }
      if ( !isArgEmpty(arg2) ) { vecArgs[numArgs++] = arg2; }

      for ( tU16 i=0; i<numArgs; i++ ) {
         mActiveHandlerInfo.mArgs.push_back(vecArgs[i]);
      }

      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//------------------------------------------------------------------------------

dia_ServiceHandler*
dia_ServiceDispatcher::getServiceHandler ( dia_LookupKey* pKey )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::getServiceHandler(...)");

   dia_ServiceHandler* pHandler = 0;

   if ( pKey )
   {
      std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::iterator iter = mServiceHandlerRepository.find(pKey);

      if ( iter != mServiceHandlerRepository.end() )
      {
         // service handler does not exist so we can add it to the repository
         pHandler = mServiceHandlerRepository[pKey]->mpHandler;
      }
   }
   else
   {
      DIA_TR_INF("dia_ServiceDispatcher::getServiceHandler returned mActiveHandlerInfo.mpHandler");
      pHandler = mActiveHandlerInfo.mpHandler;
   }

   DIA_TR_INF("dia_ServiceDispatcher::getServiceHandler returned 0x%p", pHandler);

   return pHandler;
}


//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::resetServiceHandler ( void )
{
   dia_tclFnctTrace oTrace("dia_ServiceDispatcher::resetServiceHandler(...)");

   // cleanup
   OSAL_DELETE mActiveHandlerInfo.mpHandler;
   mActiveHandlerInfo.vReset();

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ServiceDispatcher::printAllServiceHandlers ( void ) const
{
   tDiaResult retVal = DIA_SUCCESS;
   tU32 i = 0;
   std::map<dia_LookupKey*,dia_DispatchInfo*,tclKeyComparator>::const_iterator it = mServiceHandlerRepository.begin();
   size_t numServHandlers = mServiceHandlerRepository.size();

   DIA_TR_INF(" ============================================================== ");
   DIA_TR_INF(" ======== START: INFO ABOUT AVAILABLE SERVICE HANDLERS ======== ");
   DIA_TR_INF(" ======== NUMBER OF SERVICE HANDLERS: %zu ====================== ", numServHandlers);
   DIA_TR_INF(" ============================================================== ");

   for ( ; it != mServiceHandlerRepository.end(); ++it, ++i)
   {
      dia_LookupKey* pLk = it->first;
      dia_DispatchInfo* pDi = it->second;

      if ((NULL==pLk) || (NULL==pDi))
      {
         DIA_TR_ERR("[%03u] NULL PTR. pLk=0x%p pDi=0x%p", i, pLk, pDi );
         retVal = DIA_FAILED;
         break;
      }

      dia_ServiceHandler* pSh = pDi->mpHandler;

      if (NULL==pSh)
      {
         DIA_TR_ERR("[%03d] NULL PTR. pSh=0x%p", i, pSh );
         retVal = DIA_FAILED;
         break;
      }

      DIA_TR_INF("[%03d] SID=0x%02X DID=0x%02X Len=0x%02X Par=0x%02X "
                 "Name=%s",
                 i, pLk->getSID(), pLk->getSubFuncID(), pLk->getSizeOfSubFuncID(), pLk->getParaType(),
                 pSh->getName());

   }

   if (DIA_SUCCESS==retVal)
   {
      DIA_TR_INF(" ============================================================== ");
      DIA_TR_INF(" ========= END: INFO ABOUT AVAILABLE SERVICE HANDLERS ========= ");
      DIA_TR_INF(" ============================================================== ");
   }
   else
   {
      DIA_TR_INF(" =============================================================== ");
      DIA_TR_INF(" =======> !!! NULL PTR ERROR !!! BREAK!!! <===================== ");
      DIA_TR_INF(" =============================================================== ");
   }

   return retVal;
}
