/*
 * dia_IMessageHandler.h
 *
 *  Created on: 12.04.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_MESSAGEHANDLER__
#define __INCLUDED_DIA_MESSAGEHANDLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_MessageBuffer;

class dia_MessageHandler
{
public:
   //! class constructor
   dia_MessageHandler ( void ) : mpNextHandler(0) {}
   //! class constructor with next hanndler passed
   dia_MessageHandler ( dia_MessageHandler* nextHandler ) : mpNextHandler(nextHandler) {}
   //! class destructor
   virtual ~dia_MessageHandler ( void ) {}

   //! assign the next handler in the chain of responsibility
   void setHandler ( dia_MessageHandler* nextHandler ) { mpNextHandler = nextHandler; }
//   //! assign the next handler in the chain of responsibility
//   void addHandlerFront ( dia_MessageHandler* nextHandler ) { mpNextHandler = nextHandler; }
//   //! assign the next handler in the chain of responsibility
//   void addHandlerBack ( dia_MessageHandler* nextHandler ) { mpNextHandler = nextHandler; }
   //! return pointer to the next handler
   const dia_MessageHandler*  getHandler ( void ) { return mpNextHandler; }

   //! method to be implemented by concrete handlers for processing incoming messages. Return value of DIA_SUCCESS indicates that the message was handled within the chain of handlers
   virtual tDiaResult handleMessage ( dia_MessageBuffer& msg ) { return ( mpNextHandler ) ? mpNextHandler->handleMessage(msg) : DIA_E_NOT_AVAILABLE; }

   // virtual void vHandleMessage ( const dia_Message& msg, tVoid* ACT ) = 0;

protected:
   //! pointer to the next handler within the chain of responsibility
   dia_MessageHandler* mpNextHandler;
};

#endif /* __INCLUDED_DIA_MESSAGEHANDLER__ */
