 /*
 * dia_MessageBuffer.h
 *
 *  Created on: 12.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER__
#define __INCLUDED_DIA_MESSAGE_BUFFER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_MessageBuffer
   : public dia_Object
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_MessageBuffer);

public:
   enum enBufferState
   {
       holds_request = 0,
       holds_request_internal,
       holds_response
   };

   enum enBufferFormat
   {
       format_unknown = 0,
       format_raw,
       format_length_and_data,
       format_count
   };

   // function pointer to functions used to send responses via the communication channel to the external tester
   typedef void (*tFuncSendResponse) ( const tU8 byteBuffer[], tU16 length, tCookieType cookie );

   //! class constructor
   dia_MessageBuffer (
         const tU8 byteBuffer[],
         tU16 length,
         tFuncSendResponse pFuncResponseSend=0,
         tCookieType cookie = 0
         );
		 
   //! class constructor
   dia_MessageBuffer (
         const tU8 byteBuffer[],
         tU16 length,
         tFuncSendResponse pFuncResponseSend,
         dia_enProtocol protocol = DIA_EN_PROTOCOL_UDS,
         enBufferState state = holds_request,
         enBufferFormat format = format_length_and_data,
         tCookieType cookie = 0
   );

   dia_MessageBuffer (
         const std::vector<tU8>& byteBuffer,
         tFuncSendResponse  funcResponseSend,
         dia_enProtocol protocol = DIA_EN_PROTOCOL_UDS,
         enBufferState state = holds_request,
         enBufferFormat format = format_length_and_data,
         tCookieType cookie = 0
   );

   //! class destructor
   virtual ~dia_MessageBuffer ( void );

   //! set information about the message buffers internal format
   void setFormat ( enBufferFormat format ) { mFormat = format; }
   //! set information about the message buffers internal format
   enBufferFormat getFormat ( void ) const { return mFormat; }

   //! set information about the message buffers internal format
   void setState ( enBufferState state ) { mState = state; }
   //! set information about the message buffers internal format
   enBufferState getState ( void ) const { return mState; }

   //! set information about the message buffers internal format
   void setProtocol ( dia_enProtocol protocol ) { mProtocol = protocol; }
   //! set information about the message buffers internal format
   dia_enProtocol getProtocol ( void ) const { return mProtocol; }

   // prepare negative respose
   virtual void vSetNegResp ( tU8 u8NegRespCode ) = 0;
   // prepare positive respose
   virtual void vSetPosResp ( void ) = 0;

   // return service ID of msg
   virtual tU16 u16GetServiceId ( void ) const = 0;
   virtual tU16 u16GetSubServiceId ( void ) const = 0;
   // return service ID of msg
   virtual tU8  u8GetServiceId ( void ) const = 0;
   virtual tU8  u8GetSubServiceId ( void ) const = 0;

   // set new length of message buffer for response, convert format format_length_and_data to format_raw
   virtual void vSetDataLength ( tU16 length );

   // return msg data length
   virtual tU16 u16GetDataLength ( void ) const;
   // Prototypes for set msg data length for response

   //! return raw pointer to the message buffer
   virtual tU8* u8GetBuffer ( void ); //const;

   //! check if the message has data at the given byte buffer position
   virtual tBool hasDataU8 ( tU16 u16Position ) const;
   //! insert a byte value at the given position in the byte buffer
   virtual tDiaResult setDataU8 ( tU16 u16Position, tU8 u8Data );
   //! insert a word value at the given position in the byte buffer
   virtual tDiaResult setDataU16 ( tU16 u16Position, tU16 u16Data );
   //! insert a double word value at the given position in the byte buffer
   virtual tDiaResult setDataU32 ( tU16 u16Position, tU32 u32Data );
   //! insert a double word value at the given position in the byte buffer

   //! insert a word value at the given position in the byte buffer in big-endian (motorola) format
   virtual tDiaResult setDataU16BigEndian ( tU16 u16Position, tU16 u16Data );
   //! insert a double word value at the given position in the byte buffer in big-endian (motorola) format
   virtual tDiaResult setDataU32BigEndian ( tU16 u16Position, tU32 u32Data );


   virtual tDiaResult setDataArray ( size_t position, size_t size, std::vector<tU8>::iterator data);
   virtual tDiaResult setDataArray ( size_t size, std::vector<tU8>::iterator data);
   //! return the specified byte in the message buffer
   virtual tU8 getDataU8 ( tU16 u16Position ) const;

   //! return the specified U16 in the message buffer
   virtual tU16 getDataU16BigEndian ( tU16 u16Position ) const;
   //! return the specified U32 in the message buffer
   virtual tU32 getDataU32BigEndian ( tU16 u16Position ) const;


   //temp.: backward compatibility
   //! insert a byte value at the given position in the byte buffer
   virtual tDiaResult vSetDataU8 ( tU16 u16Position, tU8 u8Data ) { return setDataU8(u16Position,u8Data); }
   //! insert a word value at the given position in the byte buffer
   virtual tDiaResult vSetDataU16 ( tU16 u16Position, tU16 u16Data ) { return setDataU16(u16Position,u16Data); }
   //! insert a double word value at the given position in the byte buffer
   virtual tDiaResult vSetDataU32(tU16 u16Position, tU32 u32Data) { return setDataU32(u16Position,u32Data); }


   //! return the specified byte in the message buffer
   virtual tU8 u8GetData ( tU16 u16Position ) const { return getDataU8(u16Position); }



   virtual void  setCookie ( tCookieType cookie ) { mCookie = cookie; }
   virtual tCookieType getCookie ( void ) const { return mCookie; }

   virtual tFuncSendResponse getFuncSendResponse ( void ) const { return mResponseSendFunc; }

   //! true if request was not sent by any external tester
   bool isRequestInternal ( void ) const { return ((mState == holds_request_internal) ? true : false); }

   virtual void vSendResponse ( void );

   //
   // deprecated
   //

   //! this method is deprecated. please use method isRequestInternal() instead
   tBool bIsInternalRequest ( void ) const { return ((mState == holds_request_internal) ? TRUE : FALSE); }

protected:
   //! deprecated default constructor without implementation
   dia_MessageBuffer ( void );

protected:
   //! byte buffer carrying the message
   tU8* mpBuffer;
   //! size of the message buffer in bytes
   tU16 mBufferSize;

   enBufferState  mState;
   enBufferFormat mFormat;
   dia_enProtocol mProtocol;

   tCookieType mCookie;

private:
   //! this function is used to send back the response to the sender of the request
   tFuncSendResponse  mResponseSendFunc;
   //! marker used for iterating through the message buffer
   tU16 mCurrentPosition;
};

#endif /* __INCLUDED_DIA_MESSAGE_BUFFER__ */
