/*
 * dia_EngineServer.h
 *
 *  Created on: 29.08.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#define __INCLUDED_DIA_ENGINE_SERVER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include <common/framework/engine/dia_Engine.h>
#endif

#ifndef __DIA_UNIT_TESTING__

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_DISPATCHER__
#include "common/framework/engine/dia_ServiceDispatcher.h"
#endif

#endif

class dia_EngineServerConfiguration;
class dia_EngineBody;
class dia_SessionController;
class dia_Session;
class dia_ServiceHandler;
//class dia_MessageProcessor;
class dia_ServiceDispatcher;
class dia_MessageBuffer;

class dia_EngineServer
   : public dia_Engine
{
   friend class dia_EngineBody;

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_EngineServer);

public:
   //! class constructor
   dia_EngineServer ( tCString name, dia_EngineServerConfiguration& config );
   //! class destructor
   virtual ~dia_EngineServer ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );

   //! return true because this is the base class for engines processing diagnostic services
   virtual bool isServer ( void ) const { return true; }

   //! return a reference to the service provider configuration
   virtual const dia_EngineServerConfiguration& getServerConfiguration ( void ) const;

   //
   // Message Buffer Handling
   //

   //! store a pointer to the diagnostic request that is going to pe processed
   virtual void setMessageBuffer ( dia_MessageBuffer* pBuffer );
   //! release the pointer to the diagnostic request after processing is done
   virtual void releaseMessageBuffer ( void );
//
//   // msg buffer accessors
//   dia_MessageBuffer&  oDiagMsgBuffer() const;
   //
   virtual dia_MessageBuffer* getMessageBuffer ( void ) const;

   //
   // Session Handling
   //

   //! check if the given session is supported
   virtual tBool isSessionSupported ( tU8 sessionID ) const;
   //! activate the specified session
   virtual tDiaResult setSession ( tU8 sessionID );
   //! return a pointer to the active session
   virtual dia_Session* getActiveSession ( void );
   //! return the ID of the active session
   virtual tU8 getActiveSessionID ( void );
   //! query for a pointer to the specified session. If no pointer is specified the default session will be returned
   virtual tDiaResult querySession ( dia_Session** pSession, tU8 sessionID=0xFF );

   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler );
   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 numArgs, tArgsType vecArgs[] ); //lint !e818 Info: pointer parameter could be declared as pointing to const
   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 numSessions, const tU8 vecSessions[] );
   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 numSessions, const tU8 vecSessions[], tU16 numArgs, tArgsType vecArgs[] ); //lint !e818 Info: pointer parameter could be declared as pointing to const

//#ifndef __DIA_UNIT_TESTING__
   //! return the service dispatcher for the active session
   virtual dia_ServiceDispatcher* getDispatcher ( void );
//#endif

   //! return the session controller for this engine
   virtual dia_SessionController* getSessionController ( void ) const { return mpSessionMgr; }

protected:
   //! deprecated class constructor
   dia_EngineServer ( void );

protected:
   dia_EngineServerConfiguration& mServerConfig;
   //! pointer to the diagnostic message buffer or NULL
   dia_MessageBuffer* mpDiagMsgBuffer;
   //! controller for session management
   dia_SessionController* mpSessionMgr;
};

#endif /* DIA_ENGINESERVER_H_ */
