/*
 * dia_EngineServer.cpp
 *
 *  Created on: 29.08.2014
 *      Author: gib2hi
 */


#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include "common/framework/engine/dia_EngineServer.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_BODY__
#include "common/framework/engine/dia_EngineBody.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER_CONFIGURATION__
#include "common/framework/engine/dia_EngineServerConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_SESSION__
#include "common/framework/engine/dia_Session.h"
#endif

#ifndef __INCLUDED_DIA_SERVICE_HANDLER__
#include "common/framework/engine/dia_ServiceHandler.h"
#endif

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#include "common/framework/application/dia_SessionController.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

using namespace std;
using namespace dia;

//-----------------------------------------------------------------------------

dia_EngineServer::dia_EngineServer ( tCString name, dia_EngineServerConfiguration& config )
   : dia_Engine(name,config),
     mServerConfig(config),
     mpDiagMsgBuffer(0),
     mpSessionMgr(0)
{
   ScopeTrace trc("dia_EngineServer::dia_EngineServer");
}

//-----------------------------------------------------------------------------

dia_EngineServer::~dia_EngineServer ( void )
{
   _BP_TRY_BEGIN
   {
      mpDiagMsgBuffer = 0;

      if ( mpSessionMgr )
      {
         OSAL_DELETE mpSessionMgr;
         mpSessionMgr = 0;
      }
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EngineServer::~dia_EngineServer !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineServer::setup ( void )
{
   dia_tclFnctTrace trc("dia_EngineServer::setup");

   tDiaResult retCode = DIA_FAILED;

   // we setup the engine object only once
   if ( mIsSetupDone )
   {
      DIA_TR_INF("### ENGINE WAS ALREADY SET UP. RETURNING... ###");
      return DIA_SUCCESS;
   }

   // configure the engine's body (the state machine)
   if ( !mpBody || (mpBody->setup() != DIA_SUCCESS) )
   {
      DIA_TR_INF("### ENGINE HAS NO BODY (ADDR=0x%p mpBody=0x%p) OR SETTING UP THE BODY HAS FAILED. RETURNING... ###", this, mpBody);
      return DIA_FAILED;
   }

   DIA_TR_INF("### READING ENGINE CONFIGURATION (ENGINE ADDR=0x%p)... ###",this);

   // body was properly set up so we set up the session management now

   // read the identifiers of the supported sessions from the configuration object
   vector<tU8> sessions = mServerConfig.getSessions();
   DIA_TR_INF("##### Number of supported Sessions: %zu", sessions.size());

   // we need at least one session (the default session)
   if ( sessions.size() > 0 )
   {
      DIA_TR_INF("##### Creating Session Manager #####");
      mpSessionMgr = DIA_NEW dia_SessionController(*this);
      if ( !mpSessionMgr )
      {
         DIA_TR_INF("### CREATION OF SESSION CONTROLLER HAS FAILED. RETURNING... ###");
         return DIA_FAILED;
      }

      // now delegate to the session controller
      retCode = mpSessionMgr->setup();

      if ( retCode == DIA_SUCCESS )
      {
         // setup is complete. protect the engine from setting it up again
         mIsSetupDone = TRUE;
      }
   }

   return retCode;
}

//-----------------------------------------------------------------------------

//tDiaResult
//dia_EngineServer::shutdown ( void ) const
//{
//   dia_tclFnctTrace trc("dia_EngineServer::shutdown");
//
//   return DIA_SUCCESS;
//}

const dia_EngineServerConfiguration&
dia_EngineServer::getServerConfiguration ( void ) const
{
   return static_cast<const dia_EngineServerConfiguration&>(mServerConfig);
}

//-----------------------------------------------------------------------------

tBool
dia_EngineServer::isSessionSupported ( tU8 sessionID ) const
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineServer::isSessionSupported(sessionID=0x%02X) mpSessionMgr=0x%08X", sessionID, mpSessionMgr);
#endif
   return ( mpSessionMgr ) ? mpSessionMgr->isSessionSupported(sessionID) : FALSE;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineServer::setSession ( tU8 sessionID )
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineServer::setSession(sessionID=0x%02X) mpSessionMgr=0x%08X", sessionID, mpSessionMgr);
#endif
   return ( mpSessionMgr ) ? mpSessionMgr->setSession(sessionID) : DIA_FAILED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineServer::querySession ( dia_Session** pSessionPtr, tU8 sessionID )
{
   return ( mpSessionMgr ) ? mpSessionMgr->querySession(pSessionPtr,sessionID) : DIA_FAILED;
}

//-----------------------------------------------------------------------------

dia_Session*
dia_EngineServer::getActiveSession ( void )
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineServer::getActiveSession mpSessionMgr=0x%08X", mpSessionMgr);
#endif
   return ( mpSessionMgr ) ? mpSessionMgr->getActiveSession() : 0;
}

//-----------------------------------------------------------------------------

tU8
dia_EngineServer::getActiveSessionID ( void )
{
   return ( getActiveSession() ) ? getActiveSession()->getID() : 0x00;
}

//------------------------------------------------------------------------------

tDiaResult
dia_EngineServer::bAddServiceHandler ( dia_ServiceHandler* pHandler )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_EngineServer::bAddServiceHandler(pHandler)");
#endif

   if ( (!pHandler) || (!mpSessionMgr) )

   {
      DIA_TR_ERR("##### FAILED TO ADD SERVICE HANDLER (ADDR=0x%p) !!", pHandler);
      return DIA_FAILED;
   }

#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("##### ADDING SERVICE HANDLER %s TO ENGINE %s !!", pHandler->getName(), mName);
#endif
   pHandler->setEngine(*this);

   tDiaResult retVal = mpSessionMgr->bAddServiceHandler(pHandler);
   DIA_TR_INF("dia_EngineServer::bAddServiceHandler(pHandler=0x%p) returned 0x%08X", pHandler, retVal);
   return retVal;
}

//------------------------------------------------------------------------------

tDiaResult
dia_EngineServer::bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 argc, tArgsType argv[] )
{
   if ( (!pHandler) || (!mpSessionMgr) )
   {
      DIA_TR_ERR("Failed to add service handler (addr=0x%p) !!", pHandler);
      return DIA_FAILED;
   }

   DIA_TR_INF("Adding service handler %s to engine %s !!", pHandler->getName(), mName);
   pHandler->setEngine(*this);

   std::vector<tArgsType> vecArgs;
   for ( tU16 i=0; i<argc; i++ ) {
      vecArgs.push_back(argv[i]);
   }

   return mpSessionMgr->bAddServiceHandler(pHandler,vecArgs);
} //lint !e818 Info: pointer parameter could be declared as pointing to const

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineServer::bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 numSessions, const tU8 sessions[] )
{
   if ( (!pHandler) || (!mpSessionMgr) )
   {
      DIA_TR_ERR("Failed to add service handler (addr=0x%p) !!", pHandler);
      return DIA_FAILED;
   }

   DIA_TR_INF("Adding service handler %s to engine %s !!", pHandler->getName(), mName);
   pHandler->setEngine(*this);

   // we are creating a null object here
   std::vector<tArgsType> vecArgs;

   // populate the session vector to be passed the session manager
   std::vector<tU8> vecSessions;
   for ( tU16 j=0; j<numSessions; j++ ) {
      DIA_TR_INF("Binding Handler %s to session 0x%02x", pHandler->getName(), sessions[j]);
      vecSessions.push_back(sessions[j]);
   }

#ifndef __DIA_UNIT_TESTING__
   return mpSessionMgr->bAddServiceHandler(pHandler,vecSessions,vecArgs);
#else
   return DIA_SUCCESS;
#endif
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineServer::bAddServiceHandler ( dia_ServiceHandler* pHandler, tU16 numSessions, const tU8 sessions[], tU16 argc, tArgsType argv[] )
{
#ifdef __DIA_UNIT_TESTING__
   dia_tclFnctTrace oTrace("dia_EngineServer::bAddServiceHandler(pHandler,numSessions,sessions,argc,argv)");
#endif

   if ( (!pHandler) || (!mpSessionMgr) )
   {
      DIA_TR_INF("##### FAILED TO ADD SERVICE HANDLER (ADDR=0x%p) !!", pHandler);
      return DIA_FAILED;
   }

#ifdef __DIA_UNIT_TESTING__
   DIA_TR_SM("##### ADDING SERVICE HANDLER %s TO ENGINE %s !!", pHandler->getName(), mName);
#endif
   pHandler->setEngine(*this);

   std::vector<tArgsType> vecArgs;
   for ( tU16 i=0; i<argc; i++ ) {
      vecArgs.push_back(argv[i]);
   }

   std::vector<tU8> vecSessions;
   for ( tU16 j=0; j<numSessions; j++ ) {
      vecSessions.push_back(sessions[j]);
   }

   tDiaResult retVal = mpSessionMgr->bAddServiceHandler(pHandler,vecSessions,vecArgs);
   if (DIA_SUCCESS!=retVal)
   {
      DIA_TR_INF("dia_EngineServer::bAddServiceHandler(pHandler,numSessions,sessions,argc,argv) returned 0x%08X", retVal);
   }

   return retVal;
} //lint !e818 Info: pointer parameter could be declared as pointing to const

//-----------------------------------------------------------------------------

dia_ServiceDispatcher*
dia_EngineServer::getDispatcher ( void )
{
   dia_tclFnctTrace oTrace("dia_EngineServer::getDispatcher()");

   dia_ServiceDispatcher* pDispatcher = 0;

   // retrieve a pointer to the active session that maintains a pointer to the required dispatcher
   dia_Session* pSession = getActiveSession();

   if (NULL==pSession)  DIA_TR_INF("pSession is NULL");
   else                 DIA_TR_INF("##### ACTIVE SESSION (ID=0x%02X) !!", pSession->getID());

   if ( pSession )
   {
      pDispatcher = pSession->getDispatcher();
      DIA_TR_INF("##### ACTIVE DISPATCHER (ID=0x%p) !!", pDispatcher);
   }

   return pDispatcher;
}

//-----------------------------------------------------------------------------

//void
//dia_Engine::vOnMessage ( const dia_Message& msg, void* ACT )
//{
//   if ( mpBody ) mpBody->acceptEvent(msg);
//}

//-----------------------------------------------------------------------------

//void
//dia_Engine::setMessageBuffer ( dia_MessageBuffer* pBuffer )
//{
//   mpDiagMsgBuffer = pBuffer;
//}
//
////-----------------------------------------------------------------------------
//
//void
//dia_Engine::releaseMessageBuffer ( void )
//{
//   mpDiagMsgBuffer = 0;
//}
//
////-----------------------------------------------------------------------------
//
//dia_MessageBuffer*
//dia_Engine::getMessageBuffer ( void ) const
//{
//#ifndef __DIA_UNIT_TESTING__
//   dia_MessageBufferUDS* pMsgBuffer = 0;
//   dia_tclDiagSessionUds* pSession = getInstanceOfDiagSessionUDS();
//   if ( pSession ) {
//      pMsgBuffer = &(pSession->oDiagMsgBuffer());
//   }
//
//   /*lint -save -e740 "Unusual pointer cast (incompatible indirect types)" */
//   /* This LINT warning is false, because both types dia_MessageBuffer and dia_MessageBufferUDS are related types. */
//   return (dia_MessageBuffer*) pMsgBuffer;
//   /*lint -restore */
//#else
//   return 0;
//#endif
//}

//-----------------------------------------------------------------------------

//void
//dia_Engine::setMessageProcessor ( enMsgProcID id )
//{
//   mpMessageProcessor = 0;
//   getInstanceOfApplication()->queryMessageProcessor(id,&mpMessageProcessor);
//}

//const dia_EngineConfiguration&
//dia_Engine::getConfiguration ( void ) const
//{
//   return mConfig;
//}

//-----------------------------------------------------------------------------

void
dia_EngineServer::setMessageBuffer ( dia_MessageBuffer* pBuffer )
{
   mpDiagMsgBuffer = pBuffer;
}

//-----------------------------------------------------------------------------

void
dia_EngineServer::releaseMessageBuffer ( void )
{
   mpDiagMsgBuffer = 0;
}

//-----------------------------------------------------------------------------

dia_MessageBuffer*
dia_EngineServer::getMessageBuffer ( void ) const
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineServer::getMessageBuffer this=0x%08X", this);
#endif

   dia_MessageBufferUDS* pMsgBuffer = 0;
   dia_tclDiagSessionUds* pSession = getInstanceOfDiagSessionUDS();
   if ( pSession ) {
      pMsgBuffer = &(pSession->oDiagMsgBuffer());
   }

   /*lint -save -e740 "Unusual pointer cast (incompatible indirect types)" */
   /* This LINT warning is false, because both types dia_MessageBuffer and dia_MessageBufferUDS are related types. */
   return (dia_MessageBuffer*) pMsgBuffer;
   /*lint -restore */
}
