/*
 * dia_EngineRunInConfiguration.h
 *
 *  Created on: 07.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__
#define __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIGURATION__
#include <common/framework/engine/dia_EngineClientConfiguration.h>
#endif

//-----------------------------------------------------------------------------

enum dia_enCommandTypeUDS
{
   DIA_EN_UDS_CMD_TYPE_UNKNOWN = 0,
   DIA_EN_UDS_CMD_TYPE_COMPOSITE,
   DIA_EN_UDS_CMD_TYPE_READ_DATA_BY_ID,
   DIA_EN_UDS_CMD_TYPE_WRITE_DATA_BY_ID,
   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_1,
   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2,
   DIA_EN_UDS_CMD_TYPE_ROUTINE_CTRL_TYPE_2_RESULT,
   DIA_EN_UDS_CMD_TYPE_IO_CTRL,
   DIA_EN_UDS_CMD_TYPE_SESSION_CTRL,
   DIA_EN_UDS_CMD_TYPE_SECURITY_ACCESS,
   DIA_EN_UDS_CMD_TYPE_ECU_RESET,
   DIA_EN_UDS_CMD_TYPE_COUNT
};

//-----------------------------------------------------------------------------

struct dia_CommandInfoUDS
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_CommandInfoUDS);

public:
   dia_CommandInfoUDS ( tCString name, tU8 sid, tU16 did, tU16 didLen, const tU8* data/*[20]*/, tU16 dataLen, tCString logFileName, dia_enCommandTypeUDS cmdType, tU32 waitTime=0, bool isPeriodic=false, tU32 period=0, bool runInBackround=false );
   virtual ~dia_CommandInfoUDS ( void );

   //! name of the request
   tCString mName;
   //! service ID to be used for executing the request
   tU8  mSID;
   //! data ID to be used for executing the request
   tU16 mDID;
   //! length of data identifier, as we might have 1 or 2 byte identifiers or no identifier at all
   tU16 mDIDLen;
   //! data to be sent along with the request
   tU8* mpData;
   //! length of data to be sent
   tU16 mDataLen;
   //! name of log file (zero terminated ASCII string
   tCString mLogFileName;
   //! classifier for the type of service. might involve special handling within the processor
   dia_enCommandTypeUDS mType;
   //! time to wait before the engine shall continue with processing the next command
   tU32 mTimeToWaitAfterExecution;
   //! flag to indicate if the command has to be processed periodically
   bool mIsPeriodic;
   //! period in seconds
   tU32 mPeriod;
   //! flag to indicate if the process shall be triggered periodically in the background
   bool mRunInBackground;
   //!
   bool mIsSubCommand;
   //!
   dia_CommandInfoUDS* mpSubCommand;
};

//-----------------------------------------------------------------------------

class dia_EngineRunInConfiguration
   : public dia_EngineClientConfiguration
{
public:
   //! class constructor
   dia_EngineRunInConfiguration ( tCString name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );
   //! class destructor
   virtual ~dia_EngineRunInConfiguration ( void );

   //! compile all configuration items in a way that the configuration can be used by the engine
   virtual tDiaResult loadConfiguration ( void );

   //!
   virtual void setServer ( dia_UID uid ) { mUID = uid; }
   //!
   virtual dia_UID getServer ( void ) const { return mUID; }
   //!
   virtual tDiaResult addCommand ( dia_CommandInfoUDS& cmd );
   //!
   virtual tDiaResult addCommands ( std::vector<dia_CommandInfoUDS*> cmds );
   //!
   virtual const std::vector<dia_CommandInfoUDS*>& getCommands ( void ) const { return mCommands; }
   //!
   virtual tDiaResult addPostProcessingCommand ( dia_CommandInfoUDS& cmd );
   //!
   virtual tDiaResult addPostProcessingCommands ( std::vector<dia_CommandInfoUDS*> cmds );
   //!
   virtual const std::vector<dia_CommandInfoUDS*>& getPostProcessingCommands ( void ) const { return mPostProcessingCommands; }

protected:
   //! deprecated class constructor (no implementation)
   dia_EngineRunInConfiguration ( void );
   //! validate a run in command
   virtual tDiaResult validateCommand ( const dia_CommandInfoUDS& cmd ) const;

protected:
   //! unique ID of the service provider engine that shall execute the commands
   dia_UID mUID;
   //! vector of run in commands (1st command is stored at index 0, etc.)
   std::vector<dia_CommandInfoUDS*> mCommands;
   //! vector of run in commands (1st command is stored at index 0, etc.)
   std::vector<dia_CommandInfoUDS*> mPostProcessingCommands;
};

#endif /* __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__ */
