/*
 * dia_EngineRunInConfiguration.cpp
 *
 *  Created on: 07.11.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN_CONFIGURATION__
#include "common/framework/engine/dia_EngineRunInConfiguration.h"
#endif

//-----------------------------------------------------------------------------

dia_CommandInfoUDS::dia_CommandInfoUDS (
      tCString name,
      tU8 sid,
      tU16 did,
      tU16 didLen,
      const tU8* pData,
      tU16 dataLen,
      tCString logFileName,
      dia_enCommandTypeUDS cmdType,
      tU32 waitTime,
      bool isPeriodic,
      tU32 period,
      bool runInBackround
      )
   : mName(name),
     mSID(sid),
     mDID(did),
     mDIDLen(didLen),
     mpData(0),
     mDataLen(dataLen),
     mLogFileName(logFileName),
     mType(cmdType),
     mTimeToWaitAfterExecution(waitTime),
     mIsPeriodic(isPeriodic),
     mPeriod(period),
     mRunInBackground(runInBackround),
     mIsSubCommand(false),
     mpSubCommand(0)
{
   if ( pData )
   {
      mpData = OSAL_NEW tU8 [mDataLen];
      if (mpData) ::memcpy(mpData,pData,mDataLen);
   }
}

//-----------------------------------------------------------------------------

dia_CommandInfoUDS::~dia_CommandInfoUDS ( void )
{
   OSAL_DELETE [] mpData;
   mpData = 0;
   mLogFileName = 0;
   mpSubCommand = 0;
   mName  = 0;
}

//-----------------------------------------------------------------------------

dia_EngineRunInConfiguration::dia_EngineRunInConfiguration ( void )
   : dia_EngineClientConfiguration("UNKNOWN_RUN_IN_ENGINE_CONFIGURATION",DIA_EN_PROTOCOL_UDS),
     mUID(0)
{}

//-----------------------------------------------------------------------------

dia_EngineRunInConfiguration::dia_EngineRunInConfiguration ( tCString name, dia_enProtocol protocol )
   : dia_EngineClientConfiguration(name, protocol),
     mUID(0)
{}

//-----------------------------------------------------------------------------

dia_EngineRunInConfiguration::~dia_EngineRunInConfiguration ( void )
{}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::loadConfiguration ( void )
{
   if ( mUID == 0 ) return DIA_FAILED;
   if ( !mCommands.size() ) return DIA_FAILED;
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::addCommand ( dia_CommandInfoUDS& cmd )
{
   if ( validateCommand(cmd) != DIA_SUCCESS ) return DIA_FAILED;
   mCommands.push_back(&cmd);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::addPostProcessingCommand ( dia_CommandInfoUDS& cmd )
{
   if ( validateCommand(cmd) != DIA_SUCCESS ) return DIA_FAILED;
   mPostProcessingCommands.push_back(&cmd);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::addCommands ( std::vector<dia_CommandInfoUDS*> cmds )
{
   if ( cmds.empty() ) return DIA_FAILED;

   tU16 numOfValidCommands = 0;
   std::vector<dia_CommandInfoUDS*>::iterator cmdIter = cmds.begin();
   for ( ; cmdIter != cmds.end(); cmdIter++ ) {
      dia_CommandInfoUDS* pCmd = (*cmdIter);
      if ( pCmd && validateCommand(*pCmd) != DIA_SUCCESS ) break;
      numOfValidCommands++;
   }

   if ( numOfValidCommands != cmds.size() ) return DIA_FAILED;

   // all commands are valid so we can add them to our repository
   for ( std::vector<dia_CommandInfoUDS*>::iterator iter=cmds.begin(); iter != cmds.end(); iter++ ) mCommands.push_back(*iter);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::addPostProcessingCommands ( std::vector<dia_CommandInfoUDS*> cmds )
{
   if ( cmds.empty() ) return DIA_FAILED;

   tU16 numOfValidCommands = 0;
   std::vector<dia_CommandInfoUDS*>::iterator cmdIter = cmds.begin();
   for ( ; cmdIter != cmds.end(); cmdIter++ ) {
      dia_CommandInfoUDS* pCmd = (*cmdIter);
      if ( pCmd && validateCommand(*pCmd) != DIA_SUCCESS ) break;
      numOfValidCommands++;
   }

   if ( numOfValidCommands != cmds.size() ) return DIA_FAILED;

   // all commands are valid so we can add them to our repository
   for ( std::vector<dia_CommandInfoUDS*>::iterator iter=cmds.begin(); iter != cmds.end(); iter++ ) mPostProcessingCommands.push_back(*iter);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineRunInConfiguration::validateCommand ( const dia_CommandInfoUDS& cmd ) const
{
   if ( cmd.mSID == 0 ) return DIA_FAILED;
   if ( cmd.mDIDLen >= 3 ) return DIA_FAILED;
   if ( cmd.mIsPeriodic && cmd.mPeriod == 0 ) return DIA_FAILED;
   if ( !(cmd.mType > DIA_EN_UDS_CMD_TYPE_UNKNOWN && cmd.mType < DIA_EN_UDS_CMD_TYPE_COUNT) ) return DIA_FAILED;
   return DIA_SUCCESS;
}
