/**
 * \file    dia_EngineRunIn.h
 *
 * \brief   This file contains the definition of the dia_EngineRunIn class
 *          that is responsible for executing a number of services in a given engine
 *
 * \author  gib2hi
 * \date    2014/11/07
 */

#ifndef __INCLUDED_DIA_ENGINE_RUN_IN__
#define __INCLUDED_DIA_ENGINE_RUN_IN__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT__
#include <common/framework/engine/dia_EngineClient.h>
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

#include <common/framework/fsm/generated/dia_EngineRunInFSM.h>

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_APPSTATE_LISTENER__
#include "common/interfaces/dia_IAppStateListener.h"
#endif

class dia_EngineRunInConfiguration;
struct dia_CommandInfoUDS;

typedef int dia_RunInEvent;

class dia_EngineRunIn
   : public dia_EngineClient,
     public dia_ActiveObject,
     protected dia_EngineRunInFSM::FsmBehaviour,
     public dia_ITimerListener,
     public dia_IAppStateListener
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_EngineRunIn);

public:
   //! class constructor
   dia_EngineRunIn ( tCString name, dia_EngineRunInConfiguration& config );
   //! class destructor
   virtual ~dia_EngineRunIn ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );
   virtual tDiaResult tearDown ( void );

   //! return a reference to the service provider configuration
   virtual const dia_EngineRunInConfiguration& getRunInConfiguration ( void ) const;

   //! method used to populate the engine with service handlers
   virtual tDiaResult startControl ( std::vector<tArgsType>& args );
   //! method used to populate the engine with service handlers
   virtual tDiaResult stopControl ( void );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

   //! overloaded method from class dia_IAppStateListener
   virtual void onApplicationStateChange ( tU32 oldState, tU32 newState );

protected:
   //! deprecated class constructor
   dia_EngineRunIn ( void );

   //! thread entry method inherited from dia_ActiveObject
   virtual void vThreadEntrypointObject ( void );

   //! overloaded method used to handle incoming UDS messages
   virtual tDiaResult sendRunInRequest ( tU8* pData, tU16 length );
   //! callback method used to send back the response
   static void onRunInResponse ( const tU8 data[], tU16 length, tCookieType cookie );

   // FSM actions
   virtual void vFsmInitialize ( void* pArg );
   virtual void vFsmLoadRequests ( void* pArg );
   virtual void vFsmDiagnosisActive ( void* pArg );
   virtual void vFsmStartMonitoring ( void* pArg );
   virtual void vFsmDiagnosisInactive ( void* pArg );
   virtual void vFsmStopMonitoring ( void* pArg );
   virtual void vFsmGetRequest ( void* pArg );
   virtual void vFsmLogError ( void* pArg );
   virtual void vFsmHandleError ( void* pArg );
   virtual void vFsmStartTimer ( void* pArg );
   virtual void vFsmStopTimer ( void* pArg );
   virtual void vFsmSendRequest ( void* pArg );
   virtual void vFsmLogResult ( void* pArg );
   virtual void vFsmReloadCommands ( void* pArg );
   virtual void vFsmInitializeProcessing ( void* pArg );
   virtual void vFsmFinalizeProcessing ( void* pArg );
   virtual void vFsmEvaluateResult ( void* pArg );
   virtual void vFsmStartPollingTimer ( void* pArg );
   virtual void vFsmInitializePolling ( void* pArg );
   virtual void vFsmStopPollingTimer ( void* pArg );
   virtual void vFsmFinalizePolling ( void* pArg );
   virtual void vFsmSendRequestResult ( void* pArg );
   virtual void vFsmInitializeRunIn ( void* pArg );
   virtual void vFsmFinalizeRunIn ( void* pArg );
   virtual void vFsmSequenceComplete ( void* pArg );
   virtual void vFsmFinalize ( void* pArg );
   virtual void vFsmInitializePostProcessing ( void* pArg );
   virtual void vFsmLoadPostProcessingCommands ( void* pArg );

   // FSM guards
   virtual bool bFsmIsRunInActivated ( void* pArg );
   virtual bool bFsmIsValidRequest ( void* pArg );
   virtual bool bFsmCanProceed ( void* pArg );
   virtual bool bFsmWasSentSuccessfully ( void* pArg );
   virtual bool bWasCompleted ( void* pArg );
   virtual bool bFsmNeedToPollForResponse ( void* pArg );
   virtual bool bFsmIsPostProcessingComplete ( void* pArg );

   //! post a trigger event to the state machine
   virtual void postEvent ( dia_EngineRunInFSM::FsmEvent event );

protected:
   //! reference to the run in configuration
   dia_EngineRunInConfiguration& mRunInConfig;
   //! pointer to the FSM object
   dia_EngineRunInFSM::Fsm* mpFSM;
   //! message queue used for communication with the server engine
   dia_Queue<dia_RunInEvent>* mpMsgQueue;
   //! flag used to indicate that the run-in is running
   bool mIsRunning;
   //! repository of services to be executed during a run in run
   const std::vector<dia_CommandInfoUDS*>& mCommandRep;
   //! iterator for traversing the command repository
   std::vector<dia_CommandInfoUDS*>::const_iterator mCmdIter; //lint -sem(dia_EngineRunIn::tearDown,cleanup)
   //! pointer to the info object for the currently running service
   const dia_CommandInfoUDS* mpActiveCommand;

   virtual tDiaResult createDirectory ( const tCString dirName );
   virtual void readCycleCounter ( void );
   virtual tDiaResult writeCycleCounter ( void );
   virtual tDiaResult writeCompletionMarker ( void );


protected:
   bool mIsRequestValid;
   bool mWasRequestSentSuccessfully;
   bool mWasCompleted;
   tU8* mpResponseData;
   tU16 mResponseLength;

   dia_Timer oEngineTimer;
   tU32 mEngineTimerID;
   dia_Timer oPollingTimer;
   tU32 mPollingTimerID;

   bool mWaitingForResponse;

   tU16 mOperationCycleCounter;
   tChar mRuninCycleDirName[500];

   bool mIsPostProcessingActive;
   bool mIsPostProcessingCompleted;
};

#endif /* __INCLUDED_DIA_ENGINE_RUN_IN__ */
