/*
 * dia_EngineInternalTester.h
 *
 *  Created on: 18.08.2015
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_INTERNAL_TESTER__
#define __INCLUDED_DIA_ENGINE_INTERNAL_TESTER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT__
#include <common/framework/engine/dia_EngineClient.h>
#endif

#ifndef __INCLUDE_DIA_ACTIVE_OBJECT__
#include <common/framework/application/dia_ActiveObject.h>
#endif

#ifndef __INCLUDED_DIA_QUEUE__
#include "common/framework/application/dia_Queue.h"
#endif

#include <common/framework/fsm/generated/dia_EngineInternalTesterFSM.h>

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_INTERNALTESTER__
#include <common/interfaces/dia_IInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_INTERNALTESTERCLIENT__
#include <common/framework/engine/dia_InternalTesterClient.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_CONFIG_INTERNAL_TESTER__
#include "project/framework/config/dia_EngineClientConfigInternalTester.h"
#endif

class dia_EngineClientConfiguration;

typedef int dia_InternalTesterEvent;
typedef dia_EngineClientConfiguration dia_EngineInternalTesterConfiguration;

class dia_EngineInternalTester
   : public dia_EngineClient,
     public dia_ActiveObject,
     protected dia_EngineInternalTesterFSM::FsmBehaviour,
     public dia_ITimerListener,
     public dia_IInternalTester
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_EngineInternalTester);

   enum dia_enInternalTesterMessageType
   {
      DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_UNKNOWN = 0,
      DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_EXTERNAL_REQUEST,
      DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_FSM_EVENT,
      DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_TERMINATE,
      DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_COUNT
   };

   struct dia_InternalTesterMessage
   {
      dia_InternalTesterMessage ( dia_enInternalTesterMessageType type, void* msgData = 0 ) : mType(type), mpMsgData(msgData) {}
      ~dia_InternalTesterMessage ( void ) {}
      dia_enInternalTesterMessageType mType;
      void* mpMsgData;
   };

   struct dia_InternalTesterRequest
   {
      DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_InternalTesterRequest);

   public:
      //! constructor
      dia_InternalTesterRequest ( std::vector<tU8>& reqData, dia_InternalTesterClient& client, tCookieType cookie )
         : mRequestData(reqData), mpClient(&client), mCookie(cookie)
      {}
      //! destructor
      virtual ~dia_InternalTesterRequest ( void )
      {}

      //! request data
      std::vector<tU8> mRequestData;
      //! service ID to be used for executing the request
      dia_InternalTesterClient* mpClient;
      //! data ID to be used for executing the request
      tCookieType mCookie;
   };

   struct dia_InternalTesterFsmEvent
   {
      DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_InternalTesterFsmEvent);

   public:
      //! constructor
      dia_InternalTesterFsmEvent ( dia_EngineInternalTesterFSM::FsmEvent event, void* pArg )
         : mFsmEvent(event), mpArg(pArg)
      {}
      //! destructor
      virtual ~dia_InternalTesterFsmEvent ( void )
      {}

      //! state machine event
      dia_EngineInternalTesterFSM::FsmEvent mFsmEvent;
      //! data passed along with the event
      void* mpArg;
   };

public:
   //! class constructor
   dia_EngineInternalTester ( tCString name, dia_EngineInternalTesterConfiguration& config );
   //! class destructor
   virtual ~dia_EngineInternalTester ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );
   virtual tDiaResult tearDown ( void );

   //! return a reference to the service provider configuration
   virtual const dia_EngineInternalTesterConfiguration& getInternalTesterConfiguration ( void ) const;

//   //! method used to populate the engine with service handlers
//   virtual tDiaResult startControl ( std::vector<void*>& args );
//   //! method used to populate the engine with service handlers
//   virtual tDiaResult stopControl ( void );

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed ( dia_TimerID id );

   //! overloaded method from class dia_IInternalTester
   virtual tDiaResult processInternalTesterRequest ( std::vector<tU8>& requestData, dia_InternalTesterClient& client, tCookieType cookie );

   static dia_EngineInternalTester* getInstance ( void ) { return mpInstance; }

protected:
   //! deprecated class constructor
   dia_EngineInternalTester ( void );

   //! thread entry method inherited from dia_ActiveObject
   virtual void vThreadEntrypointObject ( void );

   //! overloaded method used to handle incoming UDS messages
   virtual tDiaResult sendInternalTesterRequest ( tU8* pData, tU16 length );
   //! callback method used to send back the response
   static void onInternalTesterResponse ( const tU8 data[], tU16 length, tCookieType cookie );

   // FSM actions
   virtual void vFsmCreateResponse ( void* pArg );
   virtual void vFsmCreateSessionRequest ( void* pArg );
   virtual void vFsmEvaluateResult ( void* pArg );
   virtual void vFsmFinalizeProcessing ( void* pArg );
   virtual void vFsmHandleError ( void* pArg );
   virtual void vFsmInitializeProcessing ( void* pArg );
   virtual void vFsmLogError ( void* pArg );
   virtual void vFsmLogResult ( void* pArg );
   virtual void vFsmRejectRequest ( void* pArg );
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmRestoreRequest ( void* pArg );
   virtual void vFsmRestoreSession ( void* pArg );
   virtual void vFsmSendError ( void* pArg );
   virtual void vFsmSendRequest ( void* pArg );
   virtual void vFsmSendResponse ( void* pArg );
   virtual void vFsmSetErrorInvalidRequest ( void* pArg );
   virtual void vFsmSetErrorProcessingFailed ( void* pArg );
   virtual void vFsmSetErrorTimeout ( void* pArg );
   virtual void vFsmStartTimer ( void* pArg );
   virtual void vFsmStopTimer ( void* pArg );
   virtual void vFsmStoreRequest ( void* pArg );
   virtual void vFsmStoreSession ( void* pArg );

   virtual void vFsmClearResponsePending ( void* pArg );

   // FSM guards
   virtual bool bFsmIsAccepted ( void* pArg );
   virtual bool bFsmIsValidRequest ( void* pArg );
   virtual bool bFsmNeedSessionChange ( void* pArg );
   virtual bool bFsmNoSessionChangeRequired ( void* pArg );
   virtual bool bFsmWasSentSuccessfully ( void* pArg );
   virtual bool bFsmIsResponsePending ( void* pArg );

   //! post a trigger event to the state machine
   virtual void postEvent ( dia_EngineInternalTesterFSM::FsmEvent event, void* pArg );

   void validateRequest ( tU8 sID, tU16 dID );

protected:
   //!
   static dia_EngineInternalTester* mpInstance;
   //! reference to the run in configuration
   dia_EngineInternalTesterConfiguration& mInternalTesterConfig;
   //! pointer to the FSM object
   dia_EngineInternalTesterFSM::Fsm* mpFSM;
   //! message queue used for communication with the server engine
   dia_Queue<dia_InternalTesterMessage>* mpMsgQueue;
   //! active request
   dia_InternalTesterRequest* mpActiveRequest;
   //! Stored request
   std::vector<tU8> mStoreReceivedRequest;
   //! flag used to indicate that the run-in is running
//   bool mIsRunning;
//   //! repository of services to be executed during a run in run
//   const std::vector<dia_CommandInfoUDS*>& mCommandRep;
//   //! iterator for traversing the command repository
//   std::vector<dia_CommandInfoUDS*>::const_iterator mCmdIter; //lint -sem(dia_EngineRunIn::tearDown,cleanup)
//   //! pointer to the info object for the currently running service
//   const dia_CommandInfoUDS* mpActiveCommand;
//
protected:
   bool mIsRequestValid;
   bool mWasRequestSentSuccessfully;
   bool mIsAccepted;
   bool mNoSessionChangeRequired;
   bool mNeedSessionChange;
   bool mIsResponsePending;
//   bool mWasCompleted;
//   tU8* mpResponseData;
//   tU8* mpStoreResponseData;
   std::vector<tU8> mResponseData;
   std::vector<tU8> mStoreResponseData;
   tU16 mResponseLength;

   dia_Timer oEngineTimer;
   tU32 mEngineTimerID;

   tU8 mRequiredSession;

   bool mWaitingForResponse;

   tDiaResult mErrorInfo;

   tU8 mCurrentActiveSession;
   bool mInternalRequest;
   bool mInternalResponse;
};

#endif /* __INCLUDED_DIA_ENGINE_INTERNAL_TESTER__ */
