/*
 * dia_EngineInternalTester.cpp
 *
 *  Created on: 18.08.2015
 *      Author: gib2hi
 * --------------------------------------------------------
 * Date           | Author             | Modification
 * 4.2.15          | bma9kor          | Added IF block to clear error log (NCG3D-5570)
 * --------------------------------------------------------

 */

#ifndef __INCLUDED_DIA_ENGINE_INTERNAL_TESTER__
#include <common/framework/engine/dia_EngineInternalTester.h>
#endif

#ifndef __INCLUDED_DIA_MESSAGE_BUFFER_UDS__
#include <common/framework/protocols/uds/dia_MessageBufferUDS.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_APPCONTROLLER__
#include <common/framework/application/dia_AppController.h>
#endif

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_FACTORY__
#include <common/framework/application/dia_Factory.h>
#endif

#ifndef __INCLUDED_DIA_UTILITIES__
#include <common/framework/utils/dia_utilities.h>
#endif

using namespace std;

#define INT_TESTER_QUEUE_SIZE       100
#define INT_TESTER_STR_BUFF_SIZE    200
#define INT_TESTER_TIMEOUT          30000

static tCString strIntTesterThreadName = "DIA_TST";
static tCString strIntTesterQueueName  = "DIA_TSTQ";

#define DIA_C_U32_INTERNAL_TESTER_INVALID_TIMER_ID                 ((tU32) 0xFFFFFFFF)

dia_EngineInternalTester*
dia_EngineInternalTester::mpInstance = 0;

//-----------------------------------------------------------------------------

dia_EngineInternalTester::dia_EngineInternalTester ( tCString name, dia_EngineClientConfiguration& config )
   : dia_EngineClient(name,config),
     dia_ActiveObject(strIntTesterThreadName,DIA_PROP_ENGINE_INTTESTER_THREAD_PRIO,DIA_PROP_ENGINE_INTTESTER_THREAD_STACK_SIZE),
     mInternalTesterConfig(config),
     mpFSM(0),
     mpMsgQueue(0),
     mpActiveRequest(0),
     mIsRequestValid(false),
     mWasRequestSentSuccessfully(false),
     mIsAccepted(false),
     mNoSessionChangeRequired(false),
     mNeedSessionChange(false),
     mIsResponsePending(false),
     //mpResponseData(0),
     mResponseLength(0),
     mEngineTimerID(DIA_C_U32_INTERNAL_TESTER_INVALID_TIMER_ID),
     mRequiredSession(0),
     mWaitingForResponse(false),
     mErrorInfo(DIA_E_ERROR),
     mCurrentActiveSession(0),
     mInternalRequest(false),
     mInternalResponse(false)
{
   dia_tclFnctTrace trc("dia_EngineInternalTester::dia_EngineInternalTester");

   oEngineTimer.s32Create();
   mEngineTimerID = oEngineTimer.getID();
   mResponseData.clear();
   mStoreResponseData.clear();
   mStoreReceivedRequest.clear();

   dia_EngineInternalTester::mpInstance = this;
}

//-----------------------------------------------------------------------------

//lint -e1579 Warning: Pointer member might have been freed by a separate function but no '-sem(dia_EngineInternalTester::tearDown,cleanup)' was seen
dia_EngineInternalTester::~dia_EngineInternalTester ( void )
{
   // destructors should not throw exceptions (--> lint), but functions called in the
   // could possibly throw excepections. So we catch them here and raise an assert
   _BP_TRY_BEGIN
   {
      (void) dia_EngineInternalTester::tearDown();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EngineInternalTester::~dia_EngineInternalTester !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}
//lint +e1579 Warning: Pointer member might have been freed by a separate function but no '-sem(dia_EngineInternalTester::tearDown,cleanup)' was seen

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineInternalTester::setup ( void )
{
   dia_tclFnctTrace trc("dia_EngineInternalTester::setup");

   // we setup the engine object only once
   if ( mIsSetupDone )
   {
      DIA_TR_INF("### ENGINE WAS ALREADY SET UP. RETURNING... ###");
      return DIA_SUCCESS;
   }

   // create the state machine object
   if ( dia_EngineInternalTesterFSM::Fsm::createFSM (&mpFSM,this) != true )
   {
      DIA_TR_INF("### FAILED TO CREATE INTERNAL TESTER STATE MACHINE ###");
      return DIA_FAILED;
   }

   //
   // create message queue
   //
   mpMsgQueue = OSAL_NEW dia_Queue<dia_InternalTesterMessage>(strIntTesterQueueName,INT_TESTER_QUEUE_SIZE);
   if ( !mpMsgQueue || (mpMsgQueue->open() != DIA_SUCCESS) ) return DIA_FAILED;

   DIA_TR_INF("### READING ENGINE CONFIGURATION (ENGINE ADDR=0x%p)... ###",this);

   if ( startThread() != DIA_SUCCESS )
   {
      DIA_TR_INF("### FAILED TO START INTERNAL TESTER THREAD ###");
      return DIA_FAILED;
   }

   mIsSetupDone = TRUE;

   return mIsSetupDone ? DIA_SUCCESS : DIA_FAILED;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineInternalTester::tearDown ( void )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::tearDown()");

   if ( mpMsgQueue )
   {
      dia_InternalTesterMessage* pMsg = OSAL_NEW dia_InternalTesterMessage(DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_TERMINATE); //lint !e429: custodial pointer is freed by after engine has processed the message
      if ( pMsg )
      {
         mpMsgQueue->addElement(pMsg);

         tS32 s32WaitCount = 0;
         while ( s32WaitCount < 10 )
         {
            DIA_TR_INF("Sleep for 100ms");

#ifndef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
            OSAL_s32ThreadWait(100);
#else
            usleep(100*1000); // DiagOmitSleepWarning: Required for thread synchronization
#endif
            ++s32WaitCount;
         }

         pMsg = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pMsg'. --> lifetime is controlled by engine
      }

      mpMsgQueue->close();
   } //lint !e438 Warning: last value assigned to variable 'pMsg' not used

   OSAL_DELETE mpFSM;
   mpFSM = 0;

   if ( mpActiveRequest )
   {
      OSAL_DELETE mpActiveRequest;
      mpActiveRequest = 0;
   }

   oEngineTimer.s32Delete();
   oEngineTimer.removeTimerListener(this);
   mEngineTimerID = DIA_C_U32_INTERNAL_TESTER_INVALID_TIMER_ID;

   OSAL_DELETE mpMsgQueue;
   mpMsgQueue = 0;

   dia_EngineInternalTester::mpInstance = 0;

   return DIA_SUCCESS;
} //lint !e1578: Pointer member dia_EngineRunIn::mCmdIter neither freed nor zeroed by cleanup function. No heap allocated for iterator

//-----------------------------------------------------------------------------

const dia_EngineInternalTesterConfiguration&
dia_EngineInternalTester::getInternalTesterConfiguration ( void ) const
{
//   return dynamic_cast<const dia_EngineRunInConfiguration&>(mConfig);
   return mInternalTesterConfig;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineInternalTester::sendInternalTesterRequest ( tU8* pData, tU16 length )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::sendInternalTesterRequest");

   DIA_TR_INF("--- Sending Internal Tester Request To Service Engine");

   // create an object containing the UDS msg buffer
   dia_MessageBufferUDS* pMsgUDS = OSAL_NEW dia_MessageBufferUDS (
         pData, length,
         onInternalTesterResponse,
         dia_MessageBuffer::holds_request_internal,
         dia_MessageBuffer::format_raw
   ); //lint !e429: custodial pointer is freed by after engine has processed the message

   DIA_TR_SM("UDS msg RX via InternalTester: Length: %d Data: %s", length, dia::utils::bin2str(pData,length,' ').c_str());

   // create and send event ReqRx containing a ptr to the reqest msg buffer
   getInstanceOfApplication()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventReqRx(pMsgUDS)); //lint !e429: custodial pointer is freed by after engine has processed the message

   // make lint happy
   pMsgUDS = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'poMsgBuffer'. --> lifetime is controlled by diagnostic session

   return DIA_SUCCESS; //lint !e438 Warning: last value assigned to variable 'poMsgBuffer' not used
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::onInternalTesterResponse ( const tU8 data[], tU16 length, tCookieType /*cookie*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::onInternalTesterResponse");

   // send response msg to RunIn engine
   DIA_TR_INF("UDS msg TX via InternalTester ...");

   if ( mpInstance )
   {
     mpInstance->mResponseLength      = length;

     mpInstance->mStoreResponseData.clear();
     mpInstance->mStoreResponseData.insert(mpInstance->mStoreResponseData.end(),data, data+length);
      for(tU16 i = 0; i < length; i++)
      {
        //mStoreResponseData.push_back(data[i]);
        DIA_TR_INF("Response data mpInstance->mStoreResponseData[%04d]: 0x%04x ...", i, mpInstance->mStoreResponseData[i]);
      }

     if(!(mpInstance->mInternalResponse))
     {
        //copy message data to the buffer
        mpInstance->mResponseData.clear();
        mpInstance->mResponseData.insert(mpInstance->mResponseData.end(),mpInstance->mStoreResponseData.begin(), mpInstance->mStoreResponseData.end());
        DIA_TR_INF("onInternalTesterResponse mResponseData ...");
     }
     else
     {
        DIA_TR_INF("########RESPONSE RECEIVED FOR INTERNAL SESSION REQUEST##");
        mpInstance->mIsResponsePending = false;
     }

      mpInstance->postEvent(dia_EngineInternalTesterFSM::evResponseReceived,0);
   }

   dia_Application::getInstance()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventConfTxOk()); //lint !e429: custodial pointer is freed by after engine has processed the message
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vThreadEntrypointObject ( void )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vThreadEntrypointObject");

   dia_InternalTesterMessage* pMessage = 0;

   bool isDone = false;

   do
   {
      pMessage = 0;
      if ( (!mpMsgQueue) || (!mpFSM) || (mpMsgQueue->getElement(&pMessage) != DIA_SUCCESS) )
      {
         DIA_TR_ERR("##### INVALID QUEUE POINTER, NO FSM OR MESSAGE HANDLING ERROR. ABORTING #####");
         break;
      }

      DIA_TR_INF("pMessage = %s", pMessage ? "not null" : "null");

      if ( pMessage )
      {
         DIA_TR_INF("Message Type = %d", pMessage->mType);

         switch ( pMessage->mType )
         {
         case DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_FSM_EVENT:
            {
               dia_InternalTesterFsmEvent* pEvent = (dia_InternalTesterFsmEvent*) pMessage->mpMsgData;
               DIA_TR_INF("Accept Event Id=%d; Forward Message to FSM ...", pEvent->mFsmEvent);
               DIA_TR_INF("### State Before: %s", mpFSM->getStateName());
               mpFSM->acceptEvent(pEvent->mFsmEvent,pEvent->mpArg);
               DIA_TR_INF("### State After : %s", mpFSM->getStateName());

               OSAL_DELETE pEvent;
               pEvent = 0;
            }
            break;

         case DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_TERMINATE:
            isDone = true;
            break;

         case DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_EXTERNAL_REQUEST:
            {
               if (mInternalRequest != true)
               {
                  if(DIA_SUCCESS == (getInstanceOfdiaEngineInternalTesterConfiguration()->validateProtocol()))
                  {
                     //DIA_TR_INF("### After Quering DID from configuaration: %x", mStoreConfiguredServiceData.mDID);
                     mIsRequestValid = true;

                     DIA_TR_INF("EXTERNAL_REQUEST: Accept Event Id=%d; Forward Message to FSM ...", dia_EngineInternalTesterFSM::evProcessRequest);
                     DIA_TR_INF("EXTERNAL_REQUEST: ### State Before: %s", mpFSM->getStateName());

                     dia_InternalTesterRequest* receivedRequest   = (dia_InternalTesterRequest*) pMessage->mpMsgData;

                     if(receivedRequest && (receivedRequest->mRequestData.size()))
                     {
                        tU8 sid  = receivedRequest->mRequestData[0];
                        tU16 did = 0x00;/*(tU16)((receivedRequest->mRequestData[1] << 8) | receivedRequest->mRequestData[2]);*/
                        DIA_TR_INF("EXTERNAL_REQUEST: ### Query for SID: %x", sid);
                        switch(sid)
                        {
                        case DIA_C_U8_UDS_SID_ECU_RESET:
                           did = (tU16)((receivedRequest->mRequestData[1] << 0));
                           break;
                        case DIA_C_U8_UDS_SID_READ_DTC_INFO:
                           did = (tU16)((receivedRequest->mRequestData[1] << 0));
                           break;
                        case DIA_C_U8_UDS_SID_CLEAR_DIAG_INFO:
                           //Special case: mask is 3 bytes -> use only first two bytes
                           did = (tU16)((receivedRequest->mRequestData[1] << 8) | receivedRequest->mRequestData[2]);
                           break;
                        case DIA_C_U8_UDS_SID_ROUTINE_CONTROL:
                           did = (tU16)((receivedRequest->mRequestData[2] << 8) | receivedRequest->mRequestData[3]);
                           break;
                        default:
                           did = (tU16)((receivedRequest->mRequestData[1] << 8) | receivedRequest->mRequestData[2]);
                           break;
                        }
                        DIA_TR_INF("EXTERNAL_REQUEST: ### Query for DID: %x", did);
                        DIA_TR_INF("EXTERNAL_REQUEST: ### Query for SID: %x", sid);

                        validateRequest (sid, did);
                     }
                     else
                     {
                        mIsAccepted = false;
                     }
                  }
                  else
                  {
                     mIsRequestValid = false;
                  }
               }

               mpFSM->acceptEvent(dia_EngineInternalTesterFSM::evProcessRequest,pMessage->mpMsgData);
               DIA_TR_INF("EXTERNAL_REQUEST: ### State After : %s", mpFSM->getStateName());

               OSAL_DELETE pMessage;
               pMessage = 0;
            }
            break;

         default:
            DIA_TR_INF("##### INVALID MESSAGE TYPE -- IGNORED #####");
            break;
         }

         DIA_TR_INF("Message Processed !!");
         OSAL_DELETE pMessage;
         pMessage = 0;
      }
   }
   while ( !isDone ) ;

   DIA_TR_ERR("############################################################");
   DIA_TR_ERR("#");
   DIA_TR_ERR("# ENGINE RUN IN THREAD IS GETTING TERMINATED");
   DIA_TR_ERR("#");
   DIA_TR_ERR("############################################################");

#ifndef VARIANT_S_FTR_ENABLE_THREAD_AS_PTHREAD_THREAD
   // Ask OSAL what the last ERROR to occur was
   tU32 u32ErrorReason = OSAL_u32ErrorCode();
   if ( u32ErrorReason != OSAL_E_NOERROR ) DIA_TR_ERR("msg queue error: %d", u32ErrorReason);
#endif
}

//-----------------------------------------------------------------------------
void
dia_EngineInternalTester::validateRequest ( tU8 sid, tU16 did )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::validateRequest");
   //tDiaResult retCode = DIA_FAILED;

   InternalClientServiceInfo     bStoreConfiguredServiceInfo;

   if(DIA_SUCCESS == (getInstanceOfdiaEngineInternalTesterConfiguration()->getIntClientEngineConfigServiceInfo(sid, bStoreConfiguredServiceInfo)))
   {
      dia_EngineServer* pEngine = 0;
      tU8 activeSession = 0;

      if ( ((getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine)) == DIA_SUCCESS) && pEngine)
      {
        DIA_TR_INF(" --- GOT ENGINE SERVER TO RETRIEVE SESSION  !!!!");
        activeSession = pEngine->getActiveSession()->getID();
      }
      for(tU8 i = 0; i < DIA_C_U16_MAX_SESSION_CLIENT_ENGINE; i++)
      {
         if(bStoreConfiguredServiceInfo.mSupportedSessions[i] == activeSession)
         {
            DIA_TR_INF(" --- REQUESTED SID SUPPORTED IN ACTIVE SESSION : %d  !!!!", activeSession);
            //mNoSessionChangeRequired = true;
            break;
         }
      }
       if ((sid == 0x14) && (did == 0xffff))
       {
            mIsAccepted = true;
            mNeedSessionChange = false;
            mNoSessionChangeRequired = true;
       }
      else
      {
         InternalClientServiceDataItem bStoreConfiguredServiceData;
         if(DIA_SUCCESS == (getInstanceOfdiaEngineInternalTesterConfiguration()->getIntClientEngineConfigServiceData(did, bStoreConfiguredServiceData)))
         {
           mIsAccepted = true;
          //retCode = DIA_SUCCESS;
          //mNoSessionChangeRequired = false;

          for(tU8 i = 0; i < DIA_C_U16_MAX_SESSION_CLIENT_ENGINE; i++)
          {
            if(bStoreConfiguredServiceData.mSupportedSessions[i] == activeSession)
            {
               DIA_TR_INF(" --- REQUESTED DID SUPPORTED IN ACTIVE SESSION : %d  !!!!", activeSession);
               mNoSessionChangeRequired = true;
               //mInternalRequest = true;
               //mNeedSessionChange = false;
               break;
            }
          }
          mNeedSessionChange = (mNoSessionChangeRequired == true ? false : true);

          if (mNeedSessionChange == true)
          {
            mRequiredSession = bStoreConfiguredServiceData.mSupportedSessions[0];
            DIA_TR_INF(" --- mRequiredSession : %d  !!!!", mRequiredSession);
          }
        }

        else
        {
          DIA_TR_INF("### Queried DID is not configured and Not Accepted");
          mIsAccepted = false;
        }
      }
   }
   else
    {
      DIA_TR_INF("### Queried SID is not configured and Not Accepted");
      mIsAccepted = false;
   }

   //return retCode; //lint !e438 Warning: last value assigned to variable 'pRequest' not used
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineInternalTester::processInternalTesterRequest ( std::vector<tU8>& requestData, dia_InternalTesterClient& client, tCookieType cookie )
{
   tDiaResult retCode = DIA_FAILED;

   dia_InternalTesterRequest* pRequest = OSAL_NEW dia_InternalTesterRequest(requestData,client,cookie); //lint !e429: custodial pointer is freed by after engine has processed the message
   if ( pRequest )
   {
      dia_InternalTesterMessage* pMessage = OSAL_NEW dia_InternalTesterMessage(DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_EXTERNAL_REQUEST,pRequest); //lint !e429: custodial pointer is freed by after engine has processed the message
      if ( pMessage && mpMsgQueue )
      {
         retCode = mpMsgQueue->addElement(pMessage);
      }

      pMessage = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pMessage'. --> lifetime is controlled by engine
   } //lint !e438 Warning: last value assigned to variable 'pMessage' not used

   pRequest = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pRequest'. --> lifetime is controlled by engine

   return retCode; //lint !e438 Warning: last value assigned to variable 'pRequest' not used
} //lint !e438 Warning: last value assigned to variable 'pRequest' not used

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::postEvent ( dia_EngineInternalTesterFSM::FsmEvent event, void* pArg )
{
   dia_InternalTesterFsmEvent* pEvent = OSAL_NEW dia_InternalTesterFsmEvent(event,pArg); //lint !e429: custodial pointer is freed by after engine has processed the message
   if ( pEvent )
   {
      dia_InternalTesterMessage* pMsg = OSAL_NEW dia_InternalTesterMessage(DIA_EN_INTERNAL_TESTER_MESSAGE_TYPE_FSM_EVENT,pEvent);  //lint !e429: custodial pointer is freed by after engine has processed the message
      if ( pMsg && mpMsgQueue ) mpMsgQueue->addElement(pMsg);
      pMsg = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pMsg'. --> lifetime is controlled by engine
   } //lint !e438 Warning: last value assigned to variables 'pMsg' not used
   pEvent = 0; //lint !e423 Warning: Creation of memory leak in assignment to 'pEvent'. --> lifetime is controlled by internal tester engine
} //lint !e438 Warning: last value assigned to variables 'pEvent' not used

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmReset ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmReset");
//   mIsRequestValid = false;
   mIsRequestValid = false;//true; // currently we dont check
   mWasRequestSentSuccessfully = false;
   mIsAccepted = false;
   mNoSessionChangeRequired = false;
   mNeedSessionChange = false;
   mIsResponsePending = false;
   mResponseLength = 0;
   mEngineTimerID = DIA_C_U32_INTERNAL_TESTER_INVALID_TIMER_ID;
   mWaitingForResponse = false;
   mErrorInfo = DIA_E_ERROR;
   mpActiveRequest = 0;
   //mIsResponsePending = false;
   mStoreReceivedRequest.clear();
   mResponseData.clear();
   mStoreResponseData.clear();
   mCurrentActiveSession = 0;
   mInternalRequest = false;
   mInternalResponse = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSetErrorInvalidRequest ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSetErrorInvalidRequest");
   mErrorInfo = DIA_E_INVALID_REQUEST;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSetErrorTimeout ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSetErrorTimeout");
   mErrorInfo = DIA_E_TIMEOUT;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSetErrorProcessingFailed ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSetErrorProcessingFailed");
   mErrorInfo = DIA_E_PROCESSING_FAILED;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmLogError ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmLogError");
   if ( mErrorInfo != DIA_SUCCESS )
   {
      switch ( mErrorInfo )
      {
      case DIA_E_INVALID_REQUEST:
         DIA_TR_ERR("##### INTERNAL TESTER HAS RECEIVED AN INVALID EXTERNAL REQUEST. REQUEST IS IGNORED #####");
         break;
      case DIA_E_TIMEOUT:
         DIA_TR_ERR("##### INTERNAL TESTER HAS RECEIVED A TIMEOUT. REQUEST NOT PROCESSED BY UDS ENGINE IN TIME #####");
         break;
      case DIA_E_PROCESSING_FAILED:
         DIA_TR_ERR("##### INTERNAL TESTER WAS NOT ABLE TO PROCESS THE RECEIVED REQUEST #####");
         break;
      default:
         DIA_TR_ERR("##### INTERNAL TESTER HAS RAISED AN UNSPECIFIED INTERNAL ERROR #####");
         break;
      }
   }
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmHandleError ( void* pArg )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmHandleError");
   DIA_TR_INF("AT THIS POINT OF TIME WE ASSUME THAT EVERY ERROR CAN BE HANDLED");

   mIsResponsePending = false;
   postEvent(dia_EngineInternalTesterFSM::evErrorHandled,pArg);
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmStartTimer ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmStartTimer");
   oEngineTimer.addTimerListener(this);
   oEngineTimer.s32SetTime(0,0);
   oEngineTimer.s32SetTime(INT_TESTER_TIMEOUT, 0);
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmStopTimer ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmStopTimer");
   oEngineTimer.s32SetTime(0,0);
   oEngineTimer.removeTimerListener(this);
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSendRequest ( void* /*pArg */ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSendRequest");

   mWasRequestSentSuccessfully = false;
   mWaitingForResponse = false;

   if ( !mpActiveRequest )
   {
      postEvent(dia_EngineInternalTesterFSM::evProcessingFailed,NULL);
      return;
   }

   DIA_TR_INF("Sending Internal Tester Request to UDS Engine ...");
   if ( mpActiveRequest->mRequestData.size() )
   {
      if ( sendInternalTesterRequest((tU8*) &(mpActiveRequest->mRequestData)[0],(tU16) mpActiveRequest->mRequestData.size()) == DIA_SUCCESS )
      {
         for(tU8 i = 0; i < mpActiveRequest->mRequestData.size(); i++)
         {
            DIA_TR_INF("request being sent -- mpActiveRequest->mRequestData[%02d]= 0x%02x ...", i, mpActiveRequest->mRequestData[i]);
         }
         DIA_TR_INF("Successfully Sent Internal Tester Request to UDS Engine ...");
         mWasRequestSentSuccessfully = true;
         mWaitingForResponse = true;
         mIsResponsePending = true;
      }
      else
      {
         DIA_TR_INF("### SENDING REQUEST TO UDS ENGINE FAILED ###");
      }
   }
   else
   {
      DIA_TR_INF("### SENDING REQUEST TO UDS ENGINE FAILED (NO DATA FOUND) ###");
   }

   postEvent(dia_EngineInternalTesterFSM::evRequestSent,(void*)mpActiveRequest);
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmLogResult ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmLogResult");
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmIsValidRequest ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmIsValidRequest");
   return mIsRequestValid ? true : false;
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmWasSentSuccessfully ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmWasSentSuccessfully");
   return mWasRequestSentSuccessfully;
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmIsAccepted ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmIsAccepted");
   return mIsAccepted;
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmNeedSessionChange ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmNeedSessionChange");
   return mNeedSessionChange;
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmNoSessionChangeRequired ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmNoSessionChangeRequested");
   return mNoSessionChangeRequired;
}

//-----------------------------------------------------------------------------

bool
dia_EngineInternalTester::bFsmIsResponsePending ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::bFsmIsResponsePending");
   return mIsResponsePending;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmInitializeProcessing ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmInitializeProcessing");
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmFinalizeProcessing ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmFinalizeProcessing");
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmEvaluateResult ( void* pArg )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmEvaluateResult");

   if ( mpActiveRequest && !(mStoreResponseData.empty())/*mpResponseData*/ )
   {
      if ( ( mResponseLength == 3 ) && ( /*mpResponseData[0]*/ mStoreResponseData[0] == 0x7F ) )
      {
         DIA_TR_INF("Received negative response from UDS engine");
      }

      postEvent(dia_EngineInternalTesterFSM::evProcessed,pArg);
   }

   mWaitingForResponse = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmRejectRequest ( void* pArg )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmRejectRequest");

   if ( !pArg ) return;

   dia_InternalTesterRequest* pRequest = (dia_InternalTesterRequest*) pArg;
   if ( pRequest->mRequestData.size() && pRequest->mpClient )
   {
      // fabricate a negative response
      std::vector<tU8> negResponse;
      negResponse.push_back(0x7F);
      negResponse.push_back(pRequest->mRequestData[0]);
      negResponse.push_back(getInstanceOfFactory()->makeNRC(DIA_E_BUSY_REPEAT));

      pRequest->mpClient->onInternalTesterResponse(negResponse,pRequest->mCookie);
   }
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSendError ( void* pArg )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSendError");

   if ( !pArg ) return;

   dia_InternalTesterRequest* pRequest = (dia_InternalTesterRequest*) pArg;
   if ( pRequest->mRequestData.size() && pRequest->mpClient )
   {
      // fabricate a negative response
      std::vector<tU8> negResponse;
      negResponse.push_back(0x7F);
      negResponse.push_back(pRequest->mRequestData[0]);
      negResponse.push_back(getInstanceOfFactory()->makeNRC(DIA_E_GENERAL_PROGRAMMING_FAILURE));

      pRequest->mpClient->onInternalTesterResponse(negResponse,pRequest->mCookie);
   }

//   OSAL_DELETE mpResponseData;
//   mpResponseData  = 0;
   mResponseData.clear();
   mStoreResponseData.clear();
   mResponseLength = 0;
   mIsResponsePending = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmSendResponse ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmSendResponse");

//   if ( !pArg ) return;

   dia_InternalTesterRequest* pRequest = mpActiveRequest; //(dia_InternalTesterRequest*) pArg;
   if(pRequest)
   {
     if ( !(mResponseData.empty()) && pRequest->mRequestData.size() && pRequest->mpClient )
     {
       DIA_TR_INF("##### SENDING RESPONSE TO INTERNAL TESTER CLIENT #####");

        // fabricate a negative response
        std::vector<tU8> posResponse;
        //posResponse.clear();
        posResponse.insert(posResponse.end(), mResponseData.begin(), mResponseData.end());

        for(size_t i = 0; i < mResponseData.size(); ++i)
        {
            DIA_TR_INF("Send Response Response data  mResponseData[%02zu]= 0x%02x ...",  i, mResponseData[i]);
        }

        pRequest->mpClient->onInternalTesterResponse(posResponse,pRequest->mCookie);
      }
   }
   else
   {
      DIA_TR_INF("### RESPONSE TO INTERNAL TESTER CLIENT FAILED ###");
   }

   mResponseData.clear();
   mStoreResponseData.clear();
   mResponseLength = 0;
   mIsResponsePending = false;
   //mNeedSessionChange = false;
   //mNoSessionChangeRequired = false;
   mInternalRequest = false;
   mInternalResponse = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmCreateResponse ( void* /*pArg */ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmCreateResponse");

   mResponseData.clear();
   mResponseData.insert(mResponseData.end(),mStoreResponseData.begin(), mStoreResponseData.end());

      for(tU16 i = 0; i < mResponseLength; i++)
      {
         DIA_TR_INF("Response data mResponseData[%04d]= 0x%04x ...", i, mResponseData[i]);
      }
}
//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmClearResponsePending ( void* /*pArg */ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmClearResponsePending");
   mIsResponsePending = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmCreateSessionRequest ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmCreateSessionRequest");

   if(mpActiveRequest)
   {
      std::vector<tU8> session;
      session.push_back(0x10);
      //session.push_back(0x60);
      session.push_back(mRequiredSession);

      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[0]= %x", mpActiveRequest->mRequestData[0]);
      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[1]= %x", mpActiveRequest->mRequestData[1]);
      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[2]= %x", mpActiveRequest->mRequestData[2]);

      mpActiveRequest->mRequestData.resize(2);
      mpActiveRequest->mRequestData[0] = session[0];
      mpActiveRequest->mRequestData[1] = session[1];

      DIA_TR_INF(" -----------after refilling mpActiveRequest->mRequestData[0]= %x", mpActiveRequest->mRequestData[0]);
      DIA_TR_INF(" -------------------------- mpActiveRequest->mRequestData[1]= %x", mpActiveRequest->mRequestData[1]);

      mRequiredSession = 0;
   }
   else
   {
      DIA_TR_INF(" -------Null pointer mpActiveRequest ");
   }
   mInternalRequest = true;
   mInternalResponse = true;
   mIsResponsePending = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmRestoreRequest ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmRestoreRequest");

   if(mpActiveRequest)
   {
      mpActiveRequest->mRequestData.resize(mStoreReceivedRequest.size());

      for(tU8 i = 0; i < mStoreReceivedRequest.size(); i++)
      {
         mpActiveRequest->mRequestData[i] = mStoreReceivedRequest[i];
         DIA_TR_INF(" -----------mpActiveRequest->mRequestData[%02d]= 0x%02x", i, mpActiveRequest->mRequestData[i]);
         //DIA_TR_INF("DATA[%02d]: 0x%02x", i, mpResponseData[i]);
      }
   }
   else
   {
      DIA_TR_INF(" -------Null pointer mpActiveRequest");
   }
   //mNeedSessionChange = true;
   //mNoSessionChangeRequired = false;
   mInternalRequest = true;
   mInternalResponse = false;
   mIsResponsePending = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmRestoreSession ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmRestoreSession");

   if(mpActiveRequest)
   {
      std::vector<tU8> session;
      session.push_back(0x10);
      session.push_back(mCurrentActiveSession);

      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[0]= %x", mpActiveRequest->mRequestData[0]);
      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[1]= %x", mpActiveRequest->mRequestData[1]);

      mpActiveRequest->mRequestData.resize(2);
      mpActiveRequest->mRequestData[0] = session[0];
      mpActiveRequest->mRequestData[1] = session[1];

      DIA_TR_INF(" -----------after refilling mpActiveRequest->mRequestData[0]= %x", mpActiveRequest->mRequestData[0]);
      DIA_TR_INF(" --------------- mpActiveRequest->mRequestData[1]= %x", mpActiveRequest->mRequestData[1]);

   }
   else
   {
      DIA_TR_INF(" -------Null pointer mpActiveRequest ");
   }
   //mNeedSessionChange = true;
   //mNoSessionChangeRequired = false;
   mInternalRequest = true;
   mInternalResponse = true;
   mIsResponsePending = false;
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmStoreRequest ( void* pArg )
{
    dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmStoreRequest");

    if ( !pArg )
    {
       postEvent(dia_EngineInternalTesterFSM::evProcessingFailed,pArg);
       return;
    }

   mpActiveRequest   = (dia_InternalTesterRequest*) pArg;

   mStoreReceivedRequest.clear();
   for(tU8 i = 0; i < mpActiveRequest->mRequestData.size(); i++)
   {
       mStoreReceivedRequest.push_back(mpActiveRequest->mRequestData[i]);
      DIA_TR_INF(" -----------mStoreReceivedRequest[i]= %x",mStoreReceivedRequest[i]);
   }
}

//-----------------------------------------------------------------------------

void
dia_EngineInternalTester::vFsmStoreSession ( void* /*pArg*/ )
{
   dia_tclFnctTrace oTrace("dia_EngineInternalTester::vFsmStoreSession");

    dia_EngineServer* pEngine = 0;

    if ( ((getInstanceOfEngineManager()->queryEngineServer(DIA_UID_ENGINE_CUSTOMER_UDS,&pEngine)) == DIA_SUCCESS) &&
         (NULL!=pEngine) )
    {
      DIA_TR_INF(" --- GOT ENGINE SERVER TO STORE SESSION  !!!!");
      mCurrentActiveSession = pEngine->getActiveSession()->getID();

      DIA_TR_INF(" --- Current session is %x", mCurrentActiveSession);
    }
}

//-------------------------------------------------------------------------

void
dia_EngineInternalTester::vOnTimerElapsed ( dia_TimerID id )
{
   tU32 timerID = (tU32) id;

   DIA_TR_INF("### dia_EngineInternalTester::vOnTimerElapsed --- ID = %d ###", timerID);

   if ( timerID == mEngineTimerID )
   {
      postEvent(dia_EngineInternalTesterFSM::evTimeout,0);
   }
}

