/*
 * dia_EngineConfiguration.h
 *
 *  Created on: 07.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#define __INCLUDED_DIA_ENGINE_CONFIGURATION__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

class dia_Engine;

class dia_EngineConfiguration
{
public:
   //! class destructor
   virtual ~dia_EngineConfiguration ( void );

   virtual tDiaResult loadConfiguration ( void ) = 0;

   virtual tCString getName ( void ) const { return mName; }
   virtual dia_enProtocol getProtocol ( void ) const { return mProtocol; }
   //!
   void setEngine ( dia_Engine* pEngine )
   {
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineConfiguration::setEngine pEngine=0x%08X", pEngine);
#endif
      mpEngine = pEngine;
   }

protected:
   //! deprecated class constructor (no implementation)
   dia_EngineConfiguration ( void );
   //! deprecated class constructor
   dia_EngineConfiguration ( tCString name, dia_enProtocol protocol=DIA_EN_PROTOCOL_UDS );

protected:
   //! name used to identify this configuration
   tCString mName;

   //! engine that has the ownership for this configuration
   dia_Engine* mpEngine;
   //! underlying protocol for this configuration
   dia_enProtocol mProtocol;
};

#endif /* __INCLUDED_DIA_ENGINE_CONFIGURATION__ */
