/**
 * \file    dia_EngineClient.h
 *
 * \brief   This file contains the definition of the dia_EngineClient class
 *          that is responsible for the controlling the number of existing engines
 *          in the diagnosis application
 *
 * \author  gib2hi
 * \date    2012/04/11
 */

#ifndef __INCLUDED_DIA_ENGINE_CLIENT__
#define __INCLUDED_DIA_ENGINE_CLIENT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_DEFINES__
#include <common/framework/engine/dia_EngineDefs.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include <common/framework/engine/dia_Engine.h>
#endif

class dia_EngineClientConfiguration;
class dia_EngineBody;

class dia_EngineClient
   : public dia_Engine
{
   friend class dia_EngineBody;

   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_EngineClient);

public:
   //! class constructor
   dia_EngineClient ( const std::string& name, dia_EngineClientConfiguration& config );
   //! class constructor
   dia_EngineClient ( tCString name, dia_EngineClientConfiguration& config );
   //! class destructor
   virtual ~dia_EngineClient ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );

   //! return true because this is the base class for engines processing diagnostic services
   virtual bool isClient ( void ) const { return true; }

   //! return a reference to the service provider configuration
   virtual const dia_EngineClientConfiguration& getClientConfiguration ( void ) const;

   //! start the engine including all of its threads
   virtual tDiaResult startControl ( std::vector<tArgsType>& args);
   //! start the engine, but threads will only be started if automaticStartMode is set to true
   virtual tDiaResult startControl ( std::vector<tArgsType>& args, bool automaticStartMode );
   //! stop the engine including all of its threads
   virtual tDiaResult stopControl ( void );

   //! virtual method to be overloaded by subclasses for starting the threads remotely
   virtual tDiaResult execute ( void );

protected:
   //! deprecated class constructor
   dia_EngineClient ( void );

protected:
   bool mAutomaticStartMode;
};

#endif /* __INCLUDED_DIA_ENGINE_CLIENT__ */
