/*
 * dia_EngineBody.cpp
 *
 *  Created on: 12.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_APPLICATION__
#include "common/framework/application/dia_Application.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_BODY__
#include "common/framework/engine/dia_EngineBody.h"
#endif

//-----------------------------------------------------------------------------

dia_EngineBody::dia_EngineBody ( void )
   : mpEngine(0)
{}

//-----------------------------------------------------------------------------

dia_EngineBody::dia_EngineBody ( /*const*/ dia_Engine& engine )
   : mpEngine(&engine)
{
#ifdef __DIA_UNIT_TESTING__
   DIA_TR_INF("dia_EngineBody::dia_EngineBody pEngine=0x%08X", &engine);
#endif
}

//-----------------------------------------------------------------------------

dia_EngineBody::~dia_EngineBody ( void )
{
   _BP_TRY_BEGIN
   {
      oTimer.s32Delete();
      oTimer.removeTimerListener(this);
      mpEngine = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_EngineBody::~dia_EngineBody !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_EngineBody::setup ( void )
{
   dia_tclFnctTrace trc("dia_EngineBody::setup");

   // setup the timer used for this engine
   if ( oTimer.s32Create() != OSAL_OK )
   {
      DIA_TR_ERR("dia_EngineBody::setup returned DIA_FAILED");
      return DIA_FAILED;
   }

   // timer creation was successful so we can register this engine as listener
   oTimer.addTimerListener(this);

   DIA_TR_INF("dia_EngineBody::setup returned DIA_SUCCESS");
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

void
dia_EngineBody::vOnTimerElapsed ( dia_TimerID /*id*/ )
{
//   getInstanceOfApplication()->postMessage( dia_Event(DIA_MSG_ID_TIMEOUT,&mEngine) );
   getInstanceOfApplication()->postMessage(OSAL_NEW dia_tclDiagSession::tclEventTimeout());
}

//-----------------------------------------------------------------------------

//dia_Session*
//dia_EngineBody::getActiveSession ( void )
//{
//   dia_Session* pSession = 0;
//   mEngine.
//}
//}

