/*
 * dia_Engine.cpp
 *
 *  Created on: 11.04.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_ENGINE__
#include "common/framework/engine/dia_Engine.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_BODY__
#include "common/framework/engine/dia_EngineBody.h"
#endif

#ifndef __INCLUDED_DIA_ENGINE_CONFIGURATION__
#include "common/framework/engine/dia_EngineConfiguration.h"
#endif

#ifndef __INCLUDED_DIA_DIAGSESSION_UDS__
#include "common/depricated/dia_tclDiagSessionUds.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

using namespace std;

//-----------------------------------------------------------------------------

dia_Engine::dia_Engine ( tCString name, dia_EngineBody& body, dia_EngineConfiguration& config )
   : mName(name),
     mConfig(config),
     mpBody(&body),
     mIsSetupDone(FALSE)
{
   dia_tclFnctTrace trc("dia_Engine::dia_Engine(name, body, config)");

   mUID = dia_getHashCodeFromString(mName);
   body.setEngine(this);
   config.setEngine(this);

   DIA_TR_INF("dia_Engine::dia_Engine mName=%s mUID=0x%08X", mName, mUID);
}

//-----------------------------------------------------------------------------

dia_Engine::dia_Engine ( const std::string& name, dia_EngineBody& body, dia_EngineConfiguration& config )
   : mName(name.c_str()),
     mConfig(config),
     mpBody(&body),
     mIsSetupDone(FALSE)
{
   dia_tclFnctTrace trc("dia_Engine::dia_Engine(name, body, config)");

   mUID = dia_getHashCodeFromString(mName);
   body.setEngine(this);
   config.setEngine(this);

   DIA_TR_INF("dia_Engine::dia_Engine mName=%s mUID=0x%08X", mName, mUID);
}

//-----------------------------------------------------------------------------

dia_Engine::dia_Engine ( tCString name, dia_EngineConfiguration& config )
   : mName(name),
     mConfig(config),
     mpBody(0),
     mIsSetupDone(FALSE)
{
   dia_tclFnctTrace trc("dia_Engine::dia_Engine(name, config)");

   mUID = dia_getHashCodeFromString(mName);
   config.setEngine(this);

   DIA_TR_INF("dia_Engine::dia_Engine mName=%s mUID=0x%08X", mName, mUID);
}

//-----------------------------------------------------------------------------

dia_Engine::dia_Engine ( const std::string& name, dia_EngineConfiguration& config )
   : mName(name.c_str()),
     mConfig(config),
     mpBody(0),
     mIsSetupDone(FALSE)
{
   dia_tclFnctTrace trc("dia_Engine::dia_Engine(name, config)");

   mUID = dia_getHashCodeFromString(mName);
   config.setEngine(this);

   DIA_TR_INF("dia_Engine::dia_Engine mName=%s mUID=0x%08X", mName, mUID);
}

//-----------------------------------------------------------------------------

dia_Engine::~dia_Engine ( void )
{
//   _BP_TRY_BEGIN
//   {
      mName  = 0;
      mpBody = 0;
//   }
//   _BP_CATCH_ALL
//   {
//      DIA_TR_ERR("EXCEPTION CAUGHT: dia_Engine::~dia_Engine !!!");
//      DIA_ASSERT_ALWAYS();
//   }
//   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Engine::setup ( void )
{
   dia_tclFnctTrace trc("dia_Engine::setup");

   // we setup the engine object only once
   if ( mIsSetupDone )
   {
      DIA_TR_INF("### ENGINE WAS ALREADY SET UP (ENGINE ADDR=0x%p). RETURN DIA_SUCCESS ###", this);
      return DIA_SUCCESS;
   }

   // configure the engine's body (the state machine)
   if ( !mpBody || (mpBody->setup() != DIA_SUCCESS) )
   {
      DIA_TR_ERR("### ENGINE HAS NO BODY (ADDR=0x%p) OR SETTING UP THE BODY HAS FAILED. RETURNING DIA_FAILED ###", this);
      return DIA_FAILED;
   }

   DIA_TR_INF("### READING ENGINE CONFIGURATION (ENGINE ADDR=0x%p)... ###", this);

   // body was properly set up so we set up the session management now

   // setup is complete. protect the engine from setting it up again
   mIsSetupDone = TRUE;

   DIA_TR_INF("dia_Engine::setup returned DIA_SUCCESS (ADDR=0x%p) ###", this);
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_Engine::shutdown ( void ) const
{
   dia_tclFnctTrace trc("dia_Engine::shutdown");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

const dia_EngineConfiguration&
dia_Engine::getConfiguration ( void ) const
{
   return mConfig;
}


