/*!
 * \file       dia_DynamicLoaderPluginSystemAdapterCCA.h
 *
 * \brief      Plugin for the DynamicLoader to handle CCA System Adapter items
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SYSTEMADAPTER_CCA__
#define __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SYSTEMADAPTER_CCA__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN__
#include <common/framework/dynamicloader/dia_DynamicLoaderPlugin.h>
#endif

class dia_SystemAdapterASF;

namespace dia
{

class DynamicLoaderPluginSystemAdapterCCA
   : public DynamicLoaderPlugin
{
public:
   //! constructor that passes the plugin name
   DynamicLoaderPluginSystemAdapterCCA ( std::string name );
   //! destructor
   virtual ~DynamicLoaderPluginSystemAdapterCCA ( void );

protected:
   //! constructor without implementation
   DynamicLoaderPluginSystemAdapterCCA ( void );

   virtual tDiaResult loadItem ( const DynamicLoaderItem& );

};

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SYSTEMADAPTER_CCA__ */
