/*!
 * \file       dia_DynamicLoaderPluginSession.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2016 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN_SESSION__
#include <common/framework/dynamicloader/dia_DynamicLoaderPluginSession.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SESSION__
#include <common/framework/dynamicloader/dia_DynamicLoaderItemSession.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_MANAGER__
#include <common/framework/engine/dia_EngineManager.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_SERVER__
#include <common/framework/engine/dia_EngineServer.h>
#endif

// our global factory
std::map<tU8, factoryMethodSession*> factoryMethodsSession;

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSession::DynamicLoaderPluginSession ( const std::string& pluginName )
   : DynamicLoaderPlugin(pluginName,DynamicLoaderItemSession::getItemName())
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSession::DynamicLoaderPluginSession(const std::string&)");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderPluginSession::~DynamicLoaderPluginSession ( void )
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderPluginSession::loadItem ( const DynamicLoaderItem& item )
{
   dia_tclFnctTrace oTrace("DynamicLoaderPluginSession::loadItem(const DynamicLoaderItem&)");

   if ( std::string(item.getName()) != DynamicLoaderItemSession::getItemName() ) return DIA_E_DYNLOAD_INVALID_ITEM_TYPE;

   const DynamicLoaderItemSession& sessionItem = (const DynamicLoaderItemSession&) item;

   std::map<tU8, factoryMethodSession*>::iterator iter = factoryMethodsSession.find(sessionItem.getSessionID());
   if ( iter == factoryMethodsSession.end() ) return DIA_E_DYNLOAD_ITEM_NOT_FOUND;

   dia_EngineServer* pEngine = 0;
   if ( getInstanceOfEngineManager()->queryEngineServer(sessionItem.getEngineID(),&pEngine) != DIA_SUCCESS )
   {
      DIA_TR_ERR("##### UNABLE TO RETRIEVE POINTER TO DIAGNOSIS ENGINE #####");
      return DIA_FAILED;
   }

   dia_Session* pSession = (*(iter->second))(iter->first,*pEngine);

   return ( pSession ) ? DIA_SUCCESS : DIA_FAILED;
}

}

