/*!
 * \file       dia_DynamicLoaderModuleManifest.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__
#define __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_VERSION_INFO__
#include <common/framework/application/dia_VersionInfo.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_CONDITION__
#include <common/framework/dynamicloader/dia_DynamicLoaderCondition.h>
#endif

#define DIA_C_U32_DYNLOAD_LAZY                  ((tU32) 0x00000001)
#define DIA_C_U32_DYNLOAD_NOW                   ((tU32) 0x00000002)
#define DIA_C_U32_DYNLOAD_GLOBAL                ((tU32) 0x00000004)
#define DIA_C_U32_DYNLOAD_LOCAL                 ((tU32) 0x00000008)
#define DIA_C_U32_DYNLOAD_NO_DELETE             ((tU32) 0x00000010)
#define DIA_C_U32_DYNLOAD_NO_LOAD               ((tU32) 0x00000020)
#define DIA_C_U32_DYNLOAD_DEEPBIND              ((tU32) 0x00000040)

//One of the following two values must be included in flag:
//RTLD_LAZY
//    Perform lazy binding. Only resolve symbols as the code that references them is executed. If the symbol is never referenced, then it is never resolved. (Lazy binding is only performed for function references; references to variables are always immediately bound when the library is loaded.)
//RTLD_NOW
//    If this value is specified, or the environment variable LD_BIND_NOW is set to a nonempty string, all undefined symbols in the library are resolved before dlopen() returns. If this cannot be done, an error is returned.
//Zero or more of the following values may also be ORed in flag:
//RTLD_GLOBAL
//    The symbols defined by this library will be made available for symbol resolution of subsequently loaded libraries.
//RTLD_LOCAL
//    This is the converse of RTLD_GLOBAL, and the default if neither flag is specified. Symbols defined in this library are not made available to resolve references in subsequently loaded libraries.
//RTLD_NODELETE (since glibc 2.2)
//    Do not unload the library during dlclose(). Consequently, the library's static variables are not reinitialized if the library is reloaded with dlopen() at a later time. This flag is not specified in POSIX.1-2001.
//RTLD_NOLOAD (since glibc 2.2)

namespace dia
{

class DynamicLoaderItem;

class DynamicLoaderModuleManifest
{
   DECL_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(DynamicLoaderModuleManifest);

public:
   DynamicLoaderModuleManifest ( void );
   DynamicLoaderModuleManifest ( const std::string& name );
   DynamicLoaderModuleManifest ( const char* name );
   virtual ~DynamicLoaderModuleManifest ( void );

   const std::string& getFileName ( void ) const { return mFileName; }
   void setFileName ( const char* filename ) { mFileName = filename; }
   void setFileName ( const std::string& filename ) { mFileName = filename; }

   tU32 getLoaderFlags ( void ) /*const*/ { return mLoaderFlags; }
   void setLoaderFlags ( tU32 loaderFlags ) { mLoaderFlags = loaderFlags; }

   const VersionInfo& getRequestedVersion ( void ) const { return mRequestedVersion; }
   void setVersionInfo ( const VersionInfo& version ) { mRequestedVersion = version; }

   //! add a new item to the item repository
   tDiaResult addItem ( DynamicLoaderItem& item );
   //! provide information about all items provided by the dynamic module
   const std::map< dia_UID,std::map<DynamicLoaderItem*,DynamicLoaderItem*> >& getItems ( void ) const { return mItemRep; }
   //! provide information about all items provided by the dynamic module associated with the given
   const std::map<DynamicLoaderItem*,DynamicLoaderItem*>* getItems ( dia_UID uid ) const; // { return ( mItemRep.find(uid) != mItemRep.end() ) ? &(mItemRep[uid]) : 0; }

protected:
   //! shared library filename including path
   std::string mFileName;
   //1 flags to configure loader behaviour
   tU32 mLoaderFlags;
   //! requested version info of the diagnosis core
   VersionInfo mRequestedVersion;
   //! repository of items provided by the dynamic module
   std::map< dia_UID,std::map<DynamicLoaderItem*,DynamicLoaderItem*> > mItemRep;
};

}

/*

<diagnosis_manifest name="unittest_diagextensions" type="dynamic_library">
   <manifest_info>
      <manifest_version major=1 minor=0 path=0 />
      <core_version major=1 minor=0 path=0 />
   </manifest_info>

   <dynload_conditions>
      <dynload_condition name="DIA_DYNLOAD_COND_RUNLEVEL_1 />
      <dynload_condition name="DIA_DYNLOAD_COND_RUNLEVEL_2 />
      <dynload_condition name="DIA_DYNLOAD_COND_NORMAL_STATE />
      <dynload_condition name="DIA_DYNLOAD_COND_SESSION_CHANGE" value="0x60" />
      <dynload_condition name="DIA_DYNLOAD_ON_DEMAND" />
   </dynload_conditions>

   <content>
      <sessions type="DIA_DYNLOAD_MODULE_SESSIONS">
         <session name="production2" id="0x62" engine="DIA_NAME_ENGINE_PRODUCTION_UDS">
            <description>Session "production2" is a session that is assumed to be not part of a normal delivery</description>
         </session>
      </sessions>

      <security_levels type="DIA_DYNLOAD_MODULE_SECURITY_LEVELS">
         <security_level name="myseclevel" seed_id="0x62" key_id="0x63">
            <description>Security level "myseclevel" is assumed to be not part of a normal delivery</description>
         </security_level>
      </security_levels>

      <services type="DIA_DYNLOAD_MODULE_SERVICES" />
         <service sid="0x22" did="0x0815" didlen=2 runlevel=1>
            <sessions>
               <session name="production2"</session>
            </sessions>
            <
      </services>

      <modules type="DIA_DYNLOAD_MODULE_SYSTEM_ADAPTER" />
      <modules type="DIA_DYNLOAD_MODULE_ENGINE" />
      <modules type="DIA_DYNLOAD_MODULE_TEST" />
      <modules type="DIA_DYNLOAD_MODULE_SECURITY" />
   </content>
</diagnosis_manifest type="dynamic_library">
*/

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__ */
