/*!
 * \file       dia_DynamicLoaderModuleManifest.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

/*!
 * \file       dia_DynamicLoaderModuleManifest.h
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__
#include <common/framework/dynamicloader/dia_DynamicLoaderModuleManifest.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM__
#include <common/framework/dynamicloader/dia_DynamicLoaderItem.h>
#endif

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModuleManifest::DynamicLoaderModuleManifest ( void )
   : //mFileName(""),
     mLoaderFlags(DIA_C_U32_DYNLOAD_NOW)
{}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModuleManifest::DynamicLoaderModuleManifest ( const char* name )
   : mFileName(name),
     mLoaderFlags(DIA_C_U32_DYNLOAD_NOW)
{}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModuleManifest::DynamicLoaderModuleManifest ( const std::string& name )
   : mFileName(name),
     mLoaderFlags(DIA_C_U32_DYNLOAD_NOW)
{}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModuleManifest::~DynamicLoaderModuleManifest ( void )
{}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderModuleManifest::addItem ( DynamicLoaderItem& item )
{
   dia_tclFnctTrace oTrace("DynamicLoaderModuleManifest::addItem()");

   tDiaResult retCode = DIA_FAILED;

   // find the category of the item
   std::map< dia_UID,std::map<DynamicLoaderItem*,DynamicLoaderItem*> >::iterator catIter = mItemRep.find(item.getUID());
   if ( catIter != mItemRep.end() )
   {
      // category exists so add element if it was not added before
      if ( catIter->second.find(&item) == catIter->second.end() )
      {
         catIter->second.insert(std::pair<DynamicLoaderItem*,DynamicLoaderItem*>(&item,&item));
         retCode = DIA_SUCCESS;
      }
      else
      {
         retCode = DIA_E_ALREADY_EXISTS;
      }
   }
   else
   {
      mItemRep[item.getUID()].insert(std::pair<DynamicLoaderItem*,DynamicLoaderItem*>(&item,&item));
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

//const std::map<DynamicLoaderItem*,DynamicLoaderItem*>*
//DynamicLoaderModuleManifest::getItems ( dia_UID uid ) const
//{
//   return ( mItemRep.find(uid) != mItemRep.end() ) ? &(mItemRep[uid]) : 0;
//}

const std::map<DynamicLoaderItem*,DynamicLoaderItem*>*
DynamicLoaderModuleManifest::getItems ( dia_UID uid ) const
{
   const std::map<DynamicLoaderItem*,DynamicLoaderItem*>* pMap = 0;
   std::map< dia_UID,std::map<DynamicLoaderItem*,DynamicLoaderItem*> >::const_iterator cIter = mItemRep.find(uid);
   if ( cIter != mItemRep.end() )
   {
      pMap = &(cIter->second);
   }
   return pMap;
}

}
