/*!
 * \file       dia_DynamicLoaderModule.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE__
#include <common/framework/dynamicloader/dia_DynamicLoaderModule.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__
#include <common/framework/dynamicloader/dia_DynamicLoaderModuleManifest.h>
#endif

#include <dlfcn.h> //lint !e537 repeatedly included standard header file external to diagnosis

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModule::DynamicLoaderModule ( const std::string& moduleName )
   : dia_ObjectWithUID(moduleName),
     mpManifest(0),
     mpModuleHandle(0),
     mIsOpen(false)
{
   dia_tclFnctTrace oTrace("DynamicLoaderModule::DynamicLoaderModule(const std::string&)");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModule::DynamicLoaderModule ( DynamicLoaderModuleManifest& manifest )
   : dia_ObjectWithUID(manifest.getFileName()),
     mpManifest(&manifest),
     mpModuleHandle(0),
     mIsOpen(false)
{
   dia_tclFnctTrace oTrace("DynamicLoaderModule::DynamicLoaderModule(DynamicLoaderModuleManifest&)");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderModule::~DynamicLoaderModule ( void )
{
   _BP_TRY_BEGIN
   {
      mpManifest = 0;
      if ( mpModuleHandle ) (void) DynamicLoaderModule::close();
      mpModuleHandle = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: DynamicLoaderModule::~DynamicLoaderModule !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END

}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderModule::open ( const char* path )
{
   dia_tclFnctTrace oTrace("DynamicLoaderModule::open()");

   // loader flags we will pass to dlopen()
   int loaderFlags = 0;

   std::string fileName = getName();
   std::string pathName = ( path ) ? path : ".";

   if ( mpManifest )
   {
      const tU32 manifestFlags = mpManifest->getLoaderFlags();
      if ( manifestFlags & DIA_C_U32_DYNLOAD_LAZY)      loaderFlags |= RTLD_LAZY;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_NOW)       loaderFlags |= RTLD_NOW;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_GLOBAL)    loaderFlags |= RTLD_GLOBAL;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_LOCAL)     loaderFlags |= RTLD_LOCAL;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_NO_DELETE) loaderFlags |= RTLD_NODELETE;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_NO_LOAD)   loaderFlags |= RTLD_NOLOAD;
      if ( manifestFlags & DIA_C_U32_DYNLOAD_DEEPBIND)  loaderFlags |= RTLD_DEEPBIND;
      fileName = mpManifest->getFileName();
   }
   else
   {
      loaderFlags = RTLD_NOW;
   }

   std::string fileNameWithPath = pathName + "/" + fileName;
   DIA_TR_INF("##### DIA_DYNLOAD: OPEN('%s') ...", fileNameWithPath.c_str());

   mpModuleHandle = dlopen(fileNameWithPath.c_str(),loaderFlags);
   if ( !mpModuleHandle )
   {
      DIA_TR_ERR("##### DIA_DYNLOAD: OPEN FAILED!");
      DIA_TR_ERR("'%s')", dlerror());
      return DIA_E_DYNLOAD_OPEN_FAILED;
   }

   mIsOpen = true;

   return DIA_SUCCESS;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoaderModule::close ( void )
{
   if ( !mpModuleHandle ) return DIA_E_DYNLOAD_INVALID_HANDLE;
   if ( !mIsOpen ) return DIA_SUCCESS;

   DIA_TR_INF("##### DIA_DYNLOAD: CLOSE('%s') ...", getName());

   if ( 0 == dlclose(mpModuleHandle) )
   {
      mpModuleHandle = 0;
   }
   else
   {
      DIA_TR_ERR("##### DIA_DYNLOAD: CLOSE FAILED, RETCODE = DIA_E_DYNLOAD_CLOSE_FAILED");
      DIA_TR_ERR("'%s')", dlerror());
      return DIA_E_DYNLOAD_CLOSE_FAILED;
   }

   return DIA_SUCCESS;
}

//---------------------------------------------------------------------------------------------------------------------

void*
DynamicLoaderModule::loadSymbol ( const char* symbolName )
{
   dia_tclFnctTrace oTrace("DynamicLoaderModule::loadSymbol()");

   if ( !mpModuleHandle ) return NULL; //DIA_E_DYNLOAD_INVALID_HANDLE;

   DIA_TR_INF("##### DIA_DYNLOAD: LOADING SYMBOL ('%s') ...", symbolName);

   void* pSymbol = dlsym(mpModuleHandle,symbolName);
   if ( !pSymbol )
   {
      DIA_TR_ERR("##### DIA_DYNLOAD: LOADING FAILED !!");
      DIA_TR_ERR("'%s')", dlerror());
      return NULL;
   }

   return pSymbol;
//
//   return DIA_SUCCESS;
}

}
//---------------------------------------------------------------------------------------------------------------------

//
//void *dlsym(void *handle, const char *symbol);
//
//
//The function dlsym() takes a "handle" of a dynamic library returned by dlopen() and the null-terminated symbol name, returning the address
// where that symbol is loaded into memory. If the symbol is not found, in the specified library or any of the libraries that were automatically loaded by dlopen() when that library was loaded, dlsym() returns NULL. (The search performed by dlsym() is breadth first through the dependency tree of these libraries.) Since the value of the symbol could actually be NULL (so that a NULL return from dlsym() need not indicate an error), the correct way to test for an error is to call dlerror() to clear any old error conditions, then call dlsym(), and then call dlerror() again, saving its return value into a variable, and check whether this saved value is not NULL.
//
//There are two special pseudo-handles, RTLD_DEFAULT and RTLD_NEXT. The former will find the first occurrence of the desired symbol using the default library search order. The latter will find the next occurrence of a function in the search order after the current library. This allows one to provide a wrapper around a function in another shared library.
//
//
//      int dlclose(void *handle);





//void* pModuleHandle = dlopen("/opt/bosch/gm/processes/libdiagservices_so.so", RTLD_NOW);
//   if (pModuleHandle)
//   {
//      tDiaResult (*pFactory)(const dia_MessageBuffer&, dia_EngineServer&) = 0;
//      pFactory = (tDiaResult (*)(const dia_MessageBuffer&, dia_EngineServer&))(dlsym(pModuleHandle, "dia_CreateServiceHandlerProduction")); //lint !e611: Suspicious cast - This is intended & not an error
//      if (pFactory)
//      {
//         res = pFactory(request, *pEngine);
//         if (res != DIA_SUCCESS)
//         {
//            ETG_TRACE_ERR_THR(("!!! dia_EngineConfigProduction::validateRequest => Dynamic Service Factory failed with res = %d", res));
//         }
//      }
//      else
//      {
//         ETG_TRACE_ERR_THR(("!!! dia_EngineConfigProduction::validateRequest => ERROR: dlsym of dia_CreateServiceHandlerProduction failed with '%s'",
//            dlerror()));
//      }
//   }
//   else
//   {
//      ETG_TRACE_ERR_THR(("!!! dia_EngineConfigProduction::validateRequest => ERROR: dlopen of /opt/bosch/gm/processes/libdiagservices_so.so failed with '%s'",
//         dlerror()));
//   }

