/*!
 * \file       dia_DynamicLoaderItemSystemAdapterCCA.cpp
 *
 * \brief      Item for the DynamicLoader to create a CCA System Adapter
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_CCA__
#include "common/framework/dynamicloader/dia_DynamicLoaderItemSystemAdapterCCA.h"
#endif

namespace dia
{

std::string
DynamicLoaderItemSystemAdapterCCA::mNameOfDynamicLoaderItemSystemAdapterCCA("__DYNLOADER_ITEM_SYSTEMADAPTER_CCA__");

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemSystemAdapterCCA::DynamicLoaderItemSystemAdapterCCA ( dia_SystemAdapterServicePlugin* pServicePlugin, const std::function<tDiaResult( void )>& pSystemAdapterFeatureCreation )
   : DynamicLoaderItem(mNameOfDynamicLoaderItemSystemAdapterCCA),
     mpSystemAdapterServicePlugin(pServicePlugin),
     mpSystemAdapterFeatureCreation(pSystemAdapterFeatureCreation)
{
//   dia_tclFnctTrace oTrace("DynamicLoaderItemSystemAdapterCCA::DynamicLoaderItemSystemAdapterCCA()");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoaderItemSystemAdapterCCA::~DynamicLoaderItemSystemAdapterCCA ( void )
{}


}


