/*!
 * \file       dia_DynamicLoaderItemSystemAdapterASF.h
 *
 * \brief      Item for the DynamicLoader to create an ASF System Adapter
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreDynload
 *
 * \copyright  (c) 2019 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_ASF__
#define __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_ASF__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM__
#include <common/framework/dynamicloader/dia_DynamicLoaderItem.h>
#endif

#ifndef __INCLUDED_DIA_ASF_COMPONENT__
#include <common/framework/platform/asf/dia_ASFComponent.h>
#endif


namespace dia
{

class DynamicLoaderItemSystemAdapterASF
   : public DynamicLoaderItem
{
public:
   //! constructor
   DynamicLoaderItemSystemAdapterASF ( const std::function<tDiaResult( std::shared_ptr<dia_SystemAdapterASF> )>& pSystemAdapterFeatureCreation );
   //! destructor
   virtual ~DynamicLoaderItemSystemAdapterASF ( void );

   static const std::string& getItemName ( void ) { return mNameOfDynamicLoaderItemSystemAdapterASF; }

   virtual tDiaResult createSystemAdapterFeature ( std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter ) const
   {
      return mpSystemAdapterFeatureCreation(pSystemAdapter);
   }

private:
   //! constructor without implementation
   DynamicLoaderItemSystemAdapterASF ( void );

protected:
   //! generic way of creating an ASF proxy and the associated SystemAdapterServicePlugin / SystemAdapterFeature
   template <class SystemAdapterFeature, class Proxy> static
   SystemAdapterFeature* createSystemAdapterFeature(std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter, const std::string& portName, const std::string& sysadapterName);

protected:
   //! type name
   static std::string mNameOfDynamicLoaderItemSystemAdapterASF;
   //! SystemAdapterFeature creation
   std::function<tDiaResult( std::shared_ptr<dia_SystemAdapterASF> )> mpSystemAdapterFeatureCreation;
};

//-----------------------------------------------------------------------------

template <class SystemAdapterFeature, class Proxy>
SystemAdapterFeature*
DynamicLoaderItemSystemAdapterASF::createSystemAdapterFeature(std::shared_ptr<dia_SystemAdapterASF> pSystemAdapter, const std::string& portName, const std::string& sysadapterName)
{
   SystemAdapterFeature* pSAFeature = nullptr;

   if (pSystemAdapter)
   {
      boost::shared_ptr<Proxy> proxy = Proxy::createProxy(portName, *pSystemAdapter);
      if (proxy)
      {
         dia_SystemAdapterServicePluginASF<Proxy>* pSAService = asf::dia_ASFComponent::createSystemAdapterServicePlugin<Proxy>(sysadapterName.c_str(), proxy, pSystemAdapter);
         if (pSAService)
         {
            pSAFeature = asf::dia_ASFComponent::createSystemAdapterFeature<SystemAdapterFeature, Proxy>(pSAService);
         }
      }
   }

   return pSAFeature;
}

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER_ITEM_SYSTEMADAPTER_ASF__ */

