#ifndef __INCLUDED_DIA_DYNAMIC_LOADER__
#define __INCLUDED_DIA_DYNAMIC_LOADER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

class dia_Session;
class dia_EngineServer;

namespace dia
{
   class DynamicLoader;
   class DynamicLoaderModule;
   class DynamicLoaderModuleManifest;
   class DynamicLoaderPlugin;
}

// typedef to make it easier to set up our factory
typedef dia::DynamicLoaderModuleManifest* (factoryMethodLoaderManifest) ();

//typedef dia_Session* (factoryMethodSession) ( tU8, dia_EngineServer& );
////typedef dia_Session* (*factoryMethodSessionPtr) ( tU8, dia_EngineServer& );

// our global factory
extern std::map<std::string, std::function<factoryMethodLoaderManifest>> factoryMethodsLoaderManifest;

//extern std::map<tU8, factoryMethodSession*> factoryMethodsSession;

extern dia::DynamicLoader* getInstanceOfDynamicLoader ( void );
extern void releaseInstanceOfDynamicLoader ( void );

namespace dia
{

//// typedef to make it easier to set up our factory
//typedef dia::DynamicLoaderModuleManifest* (factoryMethodLoaderManifest) ();

class DynamicLoader
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(DynamicLoader);

public:
   //! scan the given folder for dynamic modules
   tDiaResult scanModules ( const std::string& folderName );
   //! load items from the given dynamic module
   tDiaResult loadModule ( const dia::DynamicLoaderModule& module );

   //! install a signal handler
   virtual tDiaResult addDynamicLoaderPlugin ( DynamicLoaderPlugin* pPlugin );
   //! install a signal handler
   virtual tDiaResult removeDynamicLoaderPlugin ( dia_UID uid );

   const std::list<dia::DynamicLoaderModule*>& getModules ( void ) const { return mModuleRep; }

protected:
   //! class constructor
   DynamicLoader ( void );
   //! class destructor
   virtual ~DynamicLoader ( void );

protected:
   std::list<dia::DynamicLoaderPlugin*> mPluginRep;
//   std::map<dia_UID,dia::DynamicLoaderPlugin*> mPluginRep;
   std::list<dia::DynamicLoaderModule*> mModuleRep;
   std::list<dia::DynamicLoaderModule*> mLoadedModuleRep;
};

}

#endif /* __INCLUDED_DIA_DYNAMIC_LOADER__ */
