/*!
 * \file       dia_DynamicLoader.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia
 *
 */

#include <unistd.h>

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER__
#include <common/framework/dynamicloader/dia_DynamicLoader.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE__
#include <common/framework/dynamicloader/dia_DynamicLoaderModule.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_MODULE_MANIFEST__
#include <common/framework/dynamicloader/dia_DynamicLoaderModuleManifest.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_PLUGIN__
#include <common/framework/dynamicloader/dia_DynamicLoaderPlugin.h>
#endif

#ifndef __INCLUDED_DIA_DYNAMIC_LOADER_ITEM__
#include <common/framework/dynamicloader/dia_DynamicLoaderItem.h>
#endif

#ifndef __INCLUDED_DIA_FILE_DIR__
#include <common/framework/application/dia_FileDir.h>
#endif

static tU16 MAX_BUFFER_SIZE = 1024;

std::map<std::string, std::function<factoryMethodLoaderManifest>> factoryMethodsLoaderManifest;

dia::DynamicLoader*
getInstanceOfDynamicLoader ( void )
{
   return dia::DynamicLoader::getInstance();
}

void
releaseInstanceOfDynamicLoader ( void )
{
   dia::DynamicLoader::deleteInstance();
}

DIA_IMPL_SINGLETON(dia::DynamicLoader)

namespace dia
{

//---------------------------------------------------------------------------------------------------------------------

DynamicLoader::DynamicLoader ( void )
{
   dia_tclFnctTrace trc("dia::DynamicLoader::DynamicLoader");
}

//---------------------------------------------------------------------------------------------------------------------

DynamicLoader::~DynamicLoader ( void )
{
   _BP_TRY_BEGIN
   {
      mPluginRep.clear();
      mModuleRep.clear();
      mLoadedModuleRep.clear();
      std::list<dia::DynamicLoaderModule*>::iterator modIter = mModuleRep.begin();
      for ( ; modIter != mModuleRep.end(); ++modIter )
      {
         delete (*modIter);
      }
      mModuleRep.clear();
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::DynamicLoader::~DynamicLoader !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//---------------------------------------------------------------------------------------------------------------------

struct pluginMatchesID
{
   pluginMatchesID ( dia_UID uid ) : mUID(uid) {}
   bool operator() ( const dia::DynamicLoaderPlugin* pPlugin ) const { return pPlugin->getUID() == this->mUID;}

protected:
   pluginMatchesID ( void );

private:
   dia_UID mUID;
};

tDiaResult
DynamicLoader::addDynamicLoaderPlugin ( DynamicLoaderPlugin* pPlugin )
{
   ScopeTrace oTrace("dia::DynamicLoader::addDynamicLoaderPlugin(DynamicLoaderPlugin*)");

   tDiaResult retCode = DIA_FAILED;

   if ( pPlugin )
   {
      std::list<dia::DynamicLoaderPlugin*>::iterator pluginIter = std::find_if(mPluginRep.begin(),mPluginRep.end(),pluginMatchesID(pPlugin->getUID()));
      if ( pluginIter == mPluginRep.end() )
      {
         DIA_TR_INF("ADDING DYNAMIC LOADER PLUGIN \"%s\"", pPlugin->getName());
         mPluginRep.push_back(pPlugin);
         retCode = DIA_SUCCESS;
      }
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoader::removeDynamicLoaderPlugin ( dia_UID uid )
{
   dia_tclFnctTrace oTrace("dia::DynamicLoader::removeDynamicLoaderPlugin(dia_UID)");

   tDiaResult retCode = DIA_FAILED;

   std::list<dia::DynamicLoaderPlugin*>::iterator pluginIter = std::find_if(mPluginRep.begin(),mPluginRep.end(),pluginMatchesID(uid));

   if ( pluginIter != mPluginRep.end() )
   {
      // erase  object pointer from plugin repository
      mPluginRep.erase(pluginIter /*uid*/);
      retCode = DIA_SUCCESS;
   }

   return retCode;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoader::scanModules ( const std::string& folderName )
{
   dia_tclFnctTrace oTrace("dia::DynamicLoader::scanModules(std::string&)");

   dia_FileDir dir(folderName);
   if ( !dir.doesExist() ) return DIA_E_FILE_DOES_NOT_EXIST;

   std::string cmdString = "ls " + folderName + "/*.so"; // command used to retrieve the list of shared libraries in the given folder
   FILE* cmdPipe = ::popen(cmdString.c_str(), "r");
   if ( !cmdPipe )
   {
      ::perror("popen");
      return DIA_FAILED;
   }

   char buffer [MAX_BUFFER_SIZE];
   char libName[MAX_BUFFER_SIZE];

   DIA_TR_INF("Scanning folder '%s'",folderName.c_str());

   while ( ::fgets(buffer, MAX_BUFFER_SIZE, cmdPipe) )
   {
      // trim off the whitespace
      char* whitespace = ::strpbrk(buffer," \t\n");
      if ( whitespace ) *whitespace = '\0';
      // append "$folderName/" to the front of the library name
      ::sprintf(libName, "%s", buffer);

      std::string fullLibName(libName);
      size_t found = fullLibName.find_last_of("/\\");
      std::string strippedLibName(fullLibName.substr(found+1));  /*substr(0, fullLibName.find_last_of("\\/")));*/
      DIA_TR_INF("  + Found library '%s'",strippedLibName.c_str());

      dia::DynamicLoaderModule* pModule = new dia::DynamicLoaderModule(strippedLibName);
      if ( pModule )
      {
         mModuleRep.push_back(pModule);
         tDiaResult retCode = pModule->open(folderName.c_str());
         if ( retCode != DIA_SUCCESS )
         {
            DIA_TR_ERR("##### FAILED TO LOAD SYMBOLS FROM %s #####",libName);
         }
      }  //lint -e429 custodial pointer 'pModule' is stored in repository mModuleRep and freed by destructor of this class
   }

   (void) ::pclose(cmdPipe);

   return DIA_SUCCESS;
}

//---------------------------------------------------------------------------------------------------------------------

tDiaResult
DynamicLoader::loadModule ( const dia::DynamicLoaderModule& module )
{
   ScopeTrace trc("dia::DynamicLoader::loadModule(const dia::DynamicLoaderModule&)");

   // get the manifest for the given module
   auto manifestIter = factoryMethodsLoaderManifest.find(std::string(module.getName()));
   if ( manifestIter == factoryMethodsLoaderManifest.end() )
   {
      DIA_TR_ERR("##### DYNLOADER: FAILED TO FIND MANIFEST FOR \"%s\"", module.getName());
      return DIA_E_NOT_FOUND;
   }

   DynamicLoaderModuleManifest* pManifest = manifestIter->second();
   if ( !pManifest )
   {
      DIA_TR_ERR("##### DYNLOADER: FAILED TO CREATE MANIFEST FOR \"%s\"", module.getName());
      return DIA_E_INVALID_POINTER;
   }

   // retrieve list of items to be loaded
   std::list<dia::DynamicLoaderPlugin*>::iterator pluginIter = mPluginRep.begin();
   for ( ; pluginIter != mPluginRep.end(); ++pluginIter )
   {
      if ( !(*pluginIter) ) continue;

      DynamicLoaderPlugin* pPlugin = *pluginIter;

      // load all items to be loaded by the given plugin
      const std::map<DynamicLoaderItem*,DynamicLoaderItem*>* pItems = pManifest->getItems(pPlugin->getItemUID());
      if ( !pItems ) continue;

      // process all items
      std::map<DynamicLoaderItem*,DynamicLoaderItem*>::const_iterator itemIter = pItems->begin();
      for ( ; itemIter != pItems->end(); ++itemIter )
      {
         if ( !itemIter->first ) continue;
         tDiaResult loadResult = pPlugin->loadItem(*(itemIter->first));
         if ( loadResult != DIA_SUCCESS )
         {
            DIA_TR_ERR("##### DYNLOADER: FAILED TO LOAD ITEM \"%s\"", itemIter->first->getName());
         }
      }
   }

   return DIA_SUCCESS;
}

}
