#ifndef __INCLUDED_DIA_MAIN__
#include "common/depricated/dia_main.h"
#endif

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGERRECORD__
#include "common/framework/datalogger/dia_DataLoggerRecord.h"
#endif

dia_DataLoggerRecord::dia_DataLoggerRecord():
   timestamp()
{
}

dia_DataLoggerRecord::dia_DataLoggerRecord(dia_DataLoggerRecord const& src)
{
   this->timestamp = src.getTimestamp();
   copyAllItems(src);
}

dia_DataLoggerRecord::~dia_DataLoggerRecord() 
{
   _BP_TRY_BEGIN
   {
      removeAllItems();
   }
   _BP_CATCH_ALL
   {

   }
   _BP_CATCH_END
}

void dia_DataLoggerRecord::copyAllItems(dia_DataLoggerRecord const& src)
{
   //std::for_each(src.items().begin(), src.items().end(), std::bind1st(std::mem_fun(&dia_DataLoggerRecord::addItem), this));
   for(size_t i = 0; i < src.items().size(); ++i)
   {
      this->logItems.push_back(src.items()[i]);
      this->itemData.push_back(src.getItemData(i));
   }

}

void dia_DataLoggerRecord::removeAllItems()
{
   this->logItems.clear(); // shared pointers are objects and this will be destroyed.
   this->itemData.clear();
}

size_t dia_DataLoggerRecord::addItem(boost::shared_ptr<dia_IDataLoggerItem> const item)
{
   size_t size = this->logItems.size();
   this->logItems.push_back(item);
   this->itemData.push_back(std::vector<tU8>());
   return size;
}

void dia_DataLoggerRecord::update() 
{
   (void)clock_gettime(CLOCK_REALTIME, &this->timestamp);
   for(size_t i = 0; i < this->logItems.size(); ++i)
   {
      this->logItems[i]->get(this->itemData[i]);
   }
}

dia_DataLoggerRecord& dia_DataLoggerRecord::operator=(dia_DataLoggerRecord const& src) 
{
   if(this != &src)
   {   
      this->timestamp = src.getTimestamp();
      removeAllItems();
      copyAllItems(src);
   }
   return *this;
}

std::vector<tU8> const& dia_DataLoggerRecord::getItemData(size_t handle) const 
{
   if(handle >= itemData.size())
   {
//      DIA_ASSERT_ALWAYS();
      DIA_TR_ERR("dia_DataLoggerRecord::getItemData => handle: %zu >= logItems.size() = %zu!", handle, logItems.size());
      static std::vector<tU8> err;
      return err;
   }
   return itemData[handle];
}
