#ifndef __INCLUDED_DIA_DATALOGGER__
#define __INCLUDED_DIA_DATALOGGER__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_TIMER_LISTENER__
#include "common/interfaces/dia_ITimerListener.h"
#endif

#ifndef __INCLUDED_DIA_IDATALOGGER__
#include "common/interfaces/dia_IDataLogger.h"
#endif

#ifndef __INCLUDED_DIA_DATALOGGERRECORD__
#include "common/framework/datalogger/dia_DataLoggerRecord.h"
#endif

#ifndef __INCLUDED_DIA_LOCK__
#include "common/framework/application/dia_Lock.h"
#endif

#include <deque>

//extern dia_DataLogger* getInstanceOfDataLogger ( void );
//extern void releaseInstanceOfDataLogger ( void );

class dia_DataLogger : public dia_IDataLogger, public dia_ITimerListener
{
public:
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_DataLogger);
public:
   static const tS32 resolution = 200;
   static const tS32 historyPeriod = -3000;
   static const tS32 futurePeriod = 600;
   static const tS32 maxSize = ((-historyPeriod + futurePeriod) / resolution) + 1;
   static tS32  calcRecIndex(tS32 size, tS32 offset);
private:
   dia_DataLoggerRecord currentData;
   std::deque<dia_DataLoggerRecord*> q;
   // timer
   dia_Timer logTimer;
   //dia_Timer startTimer;
   tU32 logTimerID;
   //tU32 startTimerID;
   mutable dia_Lock syncObj;

public:
   dia_DataLogger();
   virtual ~dia_DataLogger();
   virtual void startLogging();
   virtual void stopLogging();
   virtual void sample();
   virtual size_t addLoggedItem(boost::shared_ptr<dia_IDataLoggerItem> pItem);
   virtual void getCurrentRecord(dia_DataLoggerRecord& dlr) const;
   virtual void getData(dia_DataLoggerRecord& dlr, tS32 offset) const;

   //! overloaded method from class dia_ITimerListener
   virtual void vOnTimerElapsed(dia_TimerID id);

};



#endif
