/*!
 * \file       dia_UploadDownloadStrategy.cpp
 *
 * \brief      Upload and download strategy used for service $38 (RequestFileTransfer)
 *
 * \details    Upload and download strategy used for service $38 (RequestFileTransfer)
 *
 * \component  Diagnostics
 *
 * \ingroup    diaCoreUploadDownload
 *
 * \copyright  (c) 2012-2017 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#include "dia_UploadDownloadStrategy.h"

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_MANAGER__
#include <common/framework/datadownload/dia_DataDownloadManager.h>
#endif

#ifndef __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN__
#include <common/framework/datadownload/dia_DataDownloadManagerPlugin.h>
#endif

namespace dia {

//-----------------------------------------------------------------------------

UploadDownloadStrategy::UploadDownloadStrategy ( const std::string& name )
   : mName(name),
     mpPlugin(0),
     mCompressionMode(DIA_EN_DATA_COMPRESSION_NONE),
     mEncryptionMode(DIA_EN_DATA_ENCRYPTION_NONE)
{
   ScopeTrace trc("dia::UploadDownloadStrategy::UploadDownloadStrategy(const std::string& name)");
}

//-----------------------------------------------------------------------------

UploadDownloadStrategy::UploadDownloadStrategy ( const char* name )
   : mName(name),
     mpPlugin(0),
     mCompressionMode(DIA_EN_DATA_COMPRESSION_NONE),
     mEncryptionMode(DIA_EN_DATA_ENCRYPTION_NONE)
{
   ScopeTrace trc("dia::UploadDownloadStrategy::UploadDownloadStrategy(const char*)");
}

//-----------------------------------------------------------------------------

UploadDownloadStrategy::~UploadDownloadStrategy ( void )
{
   _BP_TRY_BEGIN
   {
      mpPlugin = 0;
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia::UploadDownloadStrategy::~UploadDownloadStrategy !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

const std::string&
UploadDownloadStrategy::getName ( void ) const
{
   return mName;
}

}




