/*
 * dia_DataDownloadStrategyDefault.h
 *
 *  Created on: 01.08.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT__
#define __INCLUDED_DIA_DATA_DOWNLOAD_STRATEGY_DEFAULT__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_UPLOAD_DOWNLOAD_STRATEGY_DATASETS__
#include <common/framework/datadownload/dia_UploadDownloadStrategyDatasets.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_DATA_UP_AND_DOWNLOAD__
#include <common/framework/datadownload/dia_defsDataUpDownload.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SESSION_LISTENER__
#include <common/interfaces/dia_ISessionListener.h>
#endif

#define  DIA_C_U8_DATADOWNLOAD_DEFAULT_FORMAT_IDENTIFIER                   ((tU8) 0x00)
#define  DIA_C_U8_DATADOWNLOAD_DEFAULT_ADDRESS_AND_FORMAT_IDENTIFIER       ((tU8) 0x33)

class dia_DataDownloadStrategyDefault
   : public dia::UploadDownloadStrategyDatasets,
     public dia_ISessionListenerImpl
{
public:
   //! class constructor
   dia_DataDownloadStrategyDefault ( std::string& name , tU8 fmtID = DIA_C_U8_DATADOWNLOAD_DEFAULT_FORMAT_IDENTIFIER, tU8 addrFmt = DIA_C_U8_DATADOWNLOAD_DEFAULT_ADDRESS_AND_FORMAT_IDENTIFIER );
   //! class destructor
   virtual ~dia_DataDownloadStrategyDefault ( void );

   //! we use a two level construction process
   virtual tDiaResult setup ( void );
   virtual tDiaResult tearDown ( void );

   virtual tDiaResult requestDownload ( std::vector<tU8>& requestData );
   virtual tDiaResult requestUpload ( std::vector<tU8>& requestData );
   virtual tDiaResult transferData ( std::vector<tU8>& requestData, std::vector<tU8>& responseData );
   virtual tDiaResult transferExit ( std::vector<tU8>& requestData );

   //! called by the session control object to notify about a session change
   virtual void vOnSessionChanged ( tU8 newSession, tU8 oldSession );

protected:
   //! class constructor - not used it
   dia_DataDownloadStrategyDefault ( void );

   //! register for session changes
   virtual tDiaResult registerSessionChange( void );
   //! unregister for session changes
   virtual tDiaResult unregisterSessionChange( void );
   //! validate the data of an incoming RequestDownload request
   virtual tDiaResult validateDataRequestUpDownload ( std::vector<tU8>& data );
   //! validate the data of an incoming transfer data request
   virtual tDiaResult validateDataTransferData ( std::vector<tU8>& data );
   //! validate the data of an incoming transfer data request
   virtual tDiaResult validateDataTransferExit ( std::vector<tU8>& data );
   //! check if length is inside of the given range
   virtual tDiaResult checkLength ( size_t length, size_t minValue, size_t maxValue );

   virtual tDiaResult acceptEvent ( dia_DataDownloadFSM::FsmEvent event, void* pArg );

protected:
   //! length of memory addresses in bytes
   tU8 mLengthOfMemoryAddress;
   //! length of uncompressed memory size in bytes
   tU8 mLengthOfUncrompressedMemorySize;
};

#endif /* DIA_DATADOWNLOADSTRATEGYDEFAULT_H_ */
