/*
 * dia_DataDownloadManagerPlugin.h
 *
 *  Created on: 25.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN__
#define __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#define DIA_C_U16_DATA_DOWNLOAD_BLOCK_BYTE_NUM         ((tU16)   2)

class dia_Dataset;

class dia_DataDownloadManagerPlugin
{
public:
   virtual ~dia_DataDownloadManagerPlugin ( void ) {}

   virtual tDiaResult prepareDownload ( dia_Dataset& /*dataset*/ ) const;
   virtual tDiaResult prepareFileTransfer ( std::string& filePathAndName ) const;
   virtual tDiaResult prepareUpload ( dia_Dataset& /*dataset*/ ) const;
   virtual tDiaResult postprocessDownload ( dia_Dataset& /*dataset*/ ) const;
   virtual tDiaResult postprocessFileTransfer ( std::string& filePathAndName ) const;
   virtual tDiaResult postprocessUpload ( dia_Dataset& /*dataset*/ ) const;

   virtual tDiaResult getErrCodeReqDnlInvalidAddress ( void ) const { return DIA_E_OUT_OF_RANGE; }
   virtual tDiaResult getErrCodeReqDnlInvalidLength ( void ) const { return DIA_E_OUT_OF_RANGE; }
   virtual tDiaResult getErrCodeReqDnlInvalidFormat ( void ) const { return DIA_E_OUT_OF_RANGE; }
   virtual tDiaResult getErrCodeReqDnlAlreadyRequested ( void ) const { return DIA_E_CONDITIONS_NOT_CORRECT; }
   virtual tDiaResult getErrCodeTransDataInvalidData ( void ) const { return DIA_E_GENERAL_PROGRAMMING_FAILURE; }
   virtual tDiaResult getErrCodeTransExitInvalidData ( void ) const { return DIA_E_GENERAL_PROGRAMMING_FAILURE; }
   virtual tDiaResult getErrCodeTransDataInvalidSequence ( void ) const { return DIA_E_SEQUENCE_ERROR; }

   virtual tU16 getDataBlockByteNum  ( void ) const { return DIA_C_U16_DATA_DOWNLOAD_BLOCK_BYTE_NUM; }
   virtual tU16 getDataBlockMaxBytes ( void ) const;
};

#endif /* __INCLUDED_DATA_DOWNLOAD_MANAGER_PLUGIN__ */
