/*
 * dia_DataDownloadManagerPlugin.cpp
 *
 *  Created on: 25.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_CONFIG_MANAGER__
#include "common/framework/config/dia_ConfigManager.h"
#endif

#ifndef __INCLUDED_DIA_DATASET__
#include "common/framework/datadownload/dia_Dataset.h"
#endif

#include "dia_DataDownloadManagerPlugin.h"

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::prepareDownload ( dia_Dataset& dataset ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::prepareDownload(dataset)");

   // increment programming counter
   dataset.incrProgrammingAttemptCounter();

   return dataset.initializeDataDownload();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::postprocessDownload ( dia_Dataset& dataset ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::postprocessDownload(dataset)");

   return dataset.finalizeDataDownload();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::prepareUpload ( dia_Dataset& dataset ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::prepareUpload(dataset)");

   return dataset.initializeDataUpload();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::postprocessUpload ( dia_Dataset& dataset ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::postprocessUpload(dataset)");

   return dataset.finalizeDataUpload();
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::prepareFileTransfer ( std::string& /*filePathAndName*/ ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::prepareFileTransfer()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_DataDownloadManagerPlugin::postprocessFileTransfer ( std::string& /*filePathAndName*/ ) const
{
   dia_tclFnctTrace trc("dia_DataDownloadManagerPlugin::postprocessFileTransfer()");

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tU16
dia_DataDownloadManagerPlugin::getDataBlockMaxBytes ( void ) const
{
   tU32 blockSize = 0;
   (void) dia_getProperty(DIA_PROP_CM_DATASET_BLOCK_SIZE, blockSize);
   return (tU16) blockSize;
}


