#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __DIA_UNIT_TESTING__
#define REG_S_IMPORT_INTERFACE_GENERIC
#include "reg_if.h"
#endif

#include "common/framework/utils/dia_utilities.h"
#include "dia_PropertyBagRegistry.h"

//----------------------------------------------------------------------------------------

dia_PropertyBagRegistry::dia_PropertyBagRegistry ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_REGISTRY)
{
    dia_tclFnctTrace trc("dia_PropertyBagRegistry::dia_PropertyBagRegistry()");

}

//----------------------------------------------------------------------------------------

dia_PropertyBagRegistry::~dia_PropertyBagRegistry ( void )
{
//    dia_tclFnctTrace trc("dia_PropertyBagRegistry::~dia_PropertyBagRegistry()");
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::open ( void )
{
    return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::close ( void )
{
    return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::getPropertyU32 ( tU32 propID, tU32& propValue )
{
    dia_tclFnctTrace trc("dia_PropertyBagRegistry::getPropertyU32()");

    tDiaResult retCode = DIA_FAILED;

    dia_PropertyInfo propData;
    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }

    tU32 regKey  = (tU32)propData.mPropExtData[0];
    tU32 regPath = (tU32)propData.mPropExtData[1];
    size_t length  = (tU16)propData.mPropSize;

    const tChar* regKeyName  = queryRegKey(regKey);
    const tChar* regPathName = queryRegPath(regPath);

    if ( (!length) || (sizeof(tU32) < length) )
    {
        return DIA_E_INVALID_LENGTH;
    }

    if ( regKeyName && regPathName )
    {
#ifndef __DIA_UNIT_TESTING__
        reg_tclRegKey oReg;

        if ( oReg.bOpen(regPathName) )
        {
            // Reading Data from Registry
            if ( oReg.bQueryU32(regKeyName,&propValue) )
            {
                retCode = DIA_SUCCESS;
            }
            oReg.vClose();
        }
#else
      DIA_PARAMETER_INTENTIONALLY_UNUSED(propValue);
      DIA_TR_ERR("dia_PropertyBagRegistry::getPropertyU32 reg_tclRegKey NOT DEFINED FOR UT");
#endif
    }

    return retCode;
}


//! read an n-byte stream property from registry
tDiaResult
dia_PropertyBagRegistry::getProperty ( tU32 propID, std::vector<tU8>& dataVec )
{
   const tU32 LenBuff = 4000;

    dia_tclFnctTrace trc("dia_PropertyBagRegistry::getProperty(tU32, std::vector<tU8>&)");
    tDiaResult retCode = DIA_FAILED;

    dia_PropertyInfo propData;
    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }

    //tU16 propLength = *originalLength;
    tU32 regKey     = (tU32)propData.mPropExtData[0];
    tU32 regPath    = (tU32)propData.mPropExtData[1];
    size_t length     = propData.mPropSize;

    dataVec.resize( length );

    const tChar* regKeyName  = queryRegKey(regKey);
    const tChar* regPathName = queryRegPath(regPath);

    if (propData.mPropType == DIA_PROP_TYPE_U8)
    {
       //Add one byte for the zero-termination which will be omitted later
       length++;
    }

    size_t readLength=length;

    if (propData.mPropType == DIA_PROP_TYPE_RAW)
    {
       // Registry only stored string, so we convert binary-data to hex-string
       readLength=(tU16)(length * 2 + 1);
       DIA_TR_INF("dia_PropertyBagRegistry::getProperty(RAW) length=%zu readLength=%zu", length, readLength);

    }

    if ( (!readLength) || (LenBuff < readLength) )
    {
       DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. Length  = %zu.", length);
       DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. LenBuff = %u.", LenBuff);
       return DIA_E_INVALID_LENGTH;
    }

   if ( regKeyName && regPathName )
   {
#ifndef __DIA_UNIT_TESTING__
      reg_tclRegKey oReg;

      if ( oReg.bOpen(regPathName) )
      {
         tU8 Buff[4000] = {0};

         // Reading Data from Registry
         if (oReg.bQueryString(regKeyName, (tChar*) Buff, (tU32)readLength))
         {
            //---------------------------------------------
            // ADD NEW STATUSMASKS WITH NEW IF-STATEMENTS
            //---------------------------------------------
            if (propData.mPropType == DIA_PROP_TYPE_RAW)
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty(RAW)");

               // copy data Buff2, final result shall be writen to Buff
               char *Buff2=(char *)alloca(readLength);
               memcpy(Buff2, Buff, readLength);
               Buff2[readLength]=0;
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty(RAW, str=%s", Buff2);
               retCode=dia::utils::hexstr2bin(Buff2, Buff, length);
               if (retCode != DIA_SUCCESS) {
                  return DIA_E_INVALID_LENGTH;
               }
            }

            if (propData.mStatusMask == SM_NO_STATUS_MASK)
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_NO_STATUS_MASK ) used.", propData.mStatusMask);
               retCode = DIA_SUCCESS;
            }


            if (propData.mStatusMask == SM_ZERO_PADDED)
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_ZERO_PADDED ) used.", propData.mStatusMask);
               retCode = DIA_SUCCESS;
            }

            if (propData.mStatusMask == SM_ZERO_TERMINATED)
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_ZERO_TERMINATED ) used.", propData.mStatusMask);

               //decrease length up to zero terminated byte of string (print string without many zeros at the end)
               if (Buff[length-1]==0x00)
               {
                  size_t decreasedLength = length;

                  while ((decreasedLength>1) && (Buff[decreasedLength-2]==0x00))
                  {
                     decreasedLength--;
                  }

                  DIA_TR_INF("dia_PropertyBagRegistry::getProperty - decreasedLength=%zu, orig len=%zu", decreasedLength, length );
                  length = decreasedLength;
                  dataVec.resize( length );
               }
               //lint +e661
               retCode = DIA_SUCCESS;
            }

            if (propData.mStatusMask == SM_LEADING_ZERO)
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_LEADING_ZERO ) used.", propData.mStatusMask);

               size_t strLen = strlen((char*) Buff);

               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - strLen=%zu, orig len=%zu", strLen, length );

               if (strLen < (length - 1))
               {
                  size_t i, count = (length - 1) - strLen;

                  //Copy the string to the end of Buff
                  for (i = 0; i < strLen; i++)
                  {
                     Buff[count + (strLen-i)-1] = Buff[(strLen-i)-1];
                  }
                  //Replace the beginning of Buff with Zeros
                  for (i = 0; i < count; i++)
                  {
                     Buff[i] = '0';
                  }
               }

               retCode = DIA_SUCCESS;
            }

            if(retCode!=DIA_SUCCESS)
            {
               DIA_TR_ERR("========================================================================");
               DIA_TR_ERR("dia_PropertyBagRegistry::getProperty - STATUSMASK UNKNOWN!");
               DIA_TR_ERR("dia_PropertyBagRegistry::getProperty - RETURN DIA_E_INVALID_STATUS_MASK.");
               DIA_TR_ERR("========================================================================");
               retCode = DIA_E_INVALID_STATUS_MASK;
            }
            else
            {
               DIA_TR_INF("dia_PropertyBagRegistry::getProperty Copy %zu bytes to output buffer", length);

               //copy data to vector
               for (size_t i=0; ((i<length) && (i < dataVec.size() )); i++)
               {
                  dataVec[i] = Buff[i];
               }
            }
         }
         else
         {
            DIA_TR_ERR("--- oReg.bQueryString(regKeyName, (tChar*) propValue, length)) has FAILED ---");
         }

         oReg.vClose();
      }
      else
      {
         DIA_TR_ERR("--- oReg.bOpen(regPathName) has FAILED ---");
      }
#else
      DIA_TR_ERR("dia_PropertyBagRegistry::getProperty reg_tclRegKey NOT DEFINED FOR UT");
#endif
   }
   else
   {
      DIA_TR_ERR("--- regKeyName == NULL or regPathName == NULL ---");
   }
   return retCode;
}

//----------------------------------------------------------------------------------------
//tDiaResult
//dia_PropertyBagRegistry::getProperty ( tU32 propID, tU8 propValue[], tU16* propLength )
//{
//   dia_tclFnctTrace trc("dia_PropertyBagRegistry::getProperty(tU32, tU8[], tU16*)");
//   return getProperty(propID,propValue, *propLength );
//}

//----------------------------------------------------------------------------------------

/*
 * removed function getProperty ( tU32 propID, tU8 propValue[], tU16 propLength ) !
 * Changed to tU16* originalLength because we have to return the payload length for the statusmask SM_ZERO_TERMINATED
 */

//! read an n-byte stream property from registry
tDiaResult
dia_PropertyBagRegistry::getProperty ( tU32 propID, tU8 propValue[], size_t* originalLength )
{
    dia_tclFnctTrace trc("dia_PropertyBagRegistry::getProperty(tU32, tU8[], size_t*)");
    tDiaResult retCode = DIA_FAILED;

    dia_PropertyInfo propData;
    if ( queryProperty(propID,propData) != DIA_SUCCESS )
    {
        return DIA_E_INVALID_KEY;
    }

    tU16 propLength = static_cast<tU16>(*originalLength);
    tU32 regKey     = (tU32)propData.mPropExtData[0];
    tU32 regPath    = (tU32)propData.mPropExtData[1];
    size_t length     = (tU16)propData.mPropSize;

    const tChar* regKeyName  = queryRegKey(regKey);
    const tChar* regPathName = queryRegPath(regPath);

    if ( (!length) || (propLength < length) )
    {
       DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. Length  =  %zu.", length);
       DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. propLength=%u.", propLength);
       return DIA_E_INVALID_LENGTH;
    }

   if ( regKeyName && regPathName )
   {
#ifndef __DIA_UNIT_TESTING__
      reg_tclRegKey oReg;

      if ( oReg.bOpen(regPathName) )
      {
         // Reading Data from Registry
         if (oReg.bQueryString(regKeyName, (tChar*) propValue, (tU32)length)) {

            //---------------------------------------------
            // ADD NEW STATUSMASKS WITH NEW IF-STATEMENTS
            //---------------------------------------------
            if (propData.mStatusMask == SM_NO_STATUS_MASK) {
//               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_NO_STATUS_MASK ) used.", propData.mStatusMask);
               if ( propLength < length ) {
                  DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. Length  =  %zu.", length);
                  DIA_TR_ERR("dia_PropertyBagRegistry::getProperty(bytestream) - DIA_E_INVALID_LENGTH. propLength=%u.", propLength);
                  retCode = DIA_E_INVALID_LENGTH;
               } else {
                  retCode = DIA_SUCCESS;
               }
            }
            if (propData.mStatusMask == SM_ZERO_PADDED) {
//               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_ZERO_PADDED ) used.", propData.mStatusMask);
               retCode = DIA_SUCCESS;
            }
            if (propData.mStatusMask == SM_ZERO_TERMINATED) {
//               DIA_TR_INF("dia_PropertyBagRegistry::getProperty - statusMask, 0x%04x ( SM_ZERO_TERMINATED ) used.", propData.mStatusMask);

               // remove read 0-Bytes until only one is left -> the zero terminate Byte
               if (propValue[length-1]==0x00) {
                  for( ; propValue[length-2]==0x00 && length>1; length--) {   // "&& length>1" is needed to left at least one 0-Byte in a only 0-Byte String
//                     DIA_TR_INF("dia_PropertyBagRegistry::getProperty - Byte propValue[%d] = 0x%02x.", length, propValue[length]);
                  }
//                  DIA_TR_INF("dia_PropertyBagRegistry::getProperty - new originalLength=%d.", length );
                  *originalLength = length;
               }
               retCode = DIA_SUCCESS;
            }

            if(retCode!=DIA_SUCCESS){
               DIA_TR_ERR("========================================================================");
               DIA_TR_ERR("dia_PropertyBagRegistry::getProperty - STATUSMASK UNKNOWN!");
               DIA_TR_ERR("dia_PropertyBagRegistry::getProperty - RETURN DIA_E_INVALID_STATUS_MASK.");
               DIA_TR_ERR("========================================================================");
               retCode = DIA_E_INVALID_STATUS_MASK;
            }

         }
         else
         {
            DIA_TR_ERR("--- oReg.bQueryString(regKeyName, (tChar*) propValue, length)) has FAILED ---");
         }

         oReg.vClose();
      }
      else
      {
         DIA_TR_ERR("--- oReg.bOpen(regPathName) has FAILED ---");
      }
#else
      DIA_PARAMETER_INTENTIONALLY_UNUSED(propValue);
      DIA_TR_ERR("dia_PropertyBagRegistry::getProperty reg_tclRegKey NOT DEFINED FOR UT");
#endif
   }
   else
   {
      DIA_TR_ERR("--- regKeyName == NULL or regPathName == NULL ---");
   }
   return retCode;
}

//---------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::setProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
    dia_tclFnctTrace trc("dia_PropertyBagRegistry:setProperty");
   tDiaResult retCode = DIA_FAILED;
   tBool statusMask_known = FALSE;

   dia_PropertyInfo propData;
   if (queryProperty(propID, propData) != DIA_SUCCESS) {
      DIA_TR_ERR("--- DIA_E_INVALID_KEY ---");
      return DIA_E_INVALID_KEY;
   }

   tU32 regKey = (tU32)propData.mPropExtData[0];
   tU32 regPath = (tU32)propData.mPropExtData[1];
   size_t length = propData.mPropSize;
   const tChar* regKeyName = queryRegKey(regKey);
   const tChar* regPathName = queryRegPath(regPath);

   tU8 *propValueCopy=(tU8 *)alloca(propLength * 2 +1);
   if (!propValueCopy) {
      return DIA_E_MEMALLOC_FAILED;
   }
   memcpy(propValueCopy, propValue, propLength);

   if (propData.mPropType == DIA_PROP_TYPE_RAW)
   {
      // Registry only stores string, so we convert binary-data to hex-string
      propLength=(tU16)(propLength * 2);
      std::vector<tU8> vecBuf;
      vecBuf.assign(propValueCopy, propValueCopy + propLength);
      std::string hexString=dia::utils::vector2string(vecBuf);
      if (hexString.length() != propLength) {
         return DIA_E_INVALID_LENGTH;
      }
      memcpy(propValueCopy, hexString.c_str(), propLength);
      propValueCopy[propLength]=0;
      propLength++; // zero-terminated
   }

   else if (propData.mStatusMask == SM_NO_STATUS_MASK) {
      if ((!length) || (propLength < length)) {
         DIA_TR_ERR("--- DIA_E_INVALID_LENGTH ---");
         DIA_TR_ERR("--- IST: %zu - SOLL: %zu ---", propLength, length);
         return DIA_E_INVALID_LENGTH;
      }
      statusMask_known = TRUE;

   } else {
      tU16 statusMask = propData.mStatusMask;
      DIA_TR_INF("dia_PropertyBagRegistry::setProperty - statusMask, 0x%04x used", statusMask);
      DIA_TR_INF("dia_PropertyBagRegistry::setProperty - statusMask, propLength %zu, length %zu", propLength, length);

      // Handle different bit statusmasks
      //---------------------------------------------
      // ADD NEW STATUSMASKS WITH NEW IF-STATEMENTS
      //---------------------------------------------
      if (statusMask & SM_ZERO_PADDED) {
         // Check if payload==MAX, if not fill 0x00 until max payload
         DIA_TR_INF("dia_PropertyBagRegistry::setProperty - zero_padded: propLength %zu, length %zu", propLength, length);
         if (propLength != DIA_PROP_LENGTH_MAX_REG)
         {
            (void) ::memset(&propValueCopy[propLength], ((tU8) 0), (DIA_PROP_LENGTH_MAX - propLength));
            propLength = DIA_PROP_LENGTH_MAX_REG;
         }

         statusMask_known = TRUE;
         statusMask = tU16(statusMask - SM_ZERO_PADDED);
         DIA_TR_INF("dia_PropertyBagRegistry::setProperty - SM zero_padded: propLength %zu, length %zu", propLength, length);
      }

      if (statusMask & SM_ZERO_TERMINATED) {
         // set first value after the payload to zero
         if (propLength < REGISTRY_MAX_ENTRY_LENGTH)
         {
            propValueCopy[propLength] = 0x00;
            propLength++;
         }

         statusMask_known = TRUE;
         statusMask = tU16(statusMask - SM_ZERO_TERMINATED);
         DIA_TR_INF("dia_PropertyBagRegistry::setProperty - SM zero_terminated: propLength %zu, length %zu", propLength, length);
      }

      // NEW STATUS_MASKs ...

      if (statusMask != SM_NO_STATUS_MASK) {
         DIA_TR_ERR("dia_PropertyBagRegistry::setProperty - unknown statusMask-Bits - 0x%04x", statusMask);
      }
   }

   if (statusMask_known == FALSE)
   {
      DIA_TR_INF("dia_PropertyBagRegistry::setProperty unknown statusMask 0x%04x used", propData.mStatusMask);
      return DIA_E_INVALID_STATUS_MASK;
   }


   if (regKeyName && regPathName)
   {
#ifndef __DIA_UNIT_TESTING__
      reg_tclRegKey oReg;

      if (oReg.bOpen(regPathName)) {
         // Reading Data from Registry
         if (oReg.bSetString(regKeyName, (tChar*) propValueCopy, (tU32)length)) {
            retCode = DIA_SUCCESS;
         }
         oReg.vClose();
      }
#else
      DIA_TR_ERR("dia_PropertyBagRegistry::setProperty reg_tclRegKey NOT DEFINED FOR UT");
#endif
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::loadRegKeys ( const dia_RegKeyInfo regKeyData[], tU16 numOfKeys )
{
    dia_tclFnctTrace oTrace("dia_PropertyBagRegistry::loadRegKeys");

    tDiaResult retCode = DIA_FAILED;

    if ( regKeyData )
    {
        for ( tU16 i=0; i<numOfKeys; ++i )
        {
            mRegKeyRep[regKeyData[i].mRegKeyID] = regKeyData[i].mRegKeyValue;
        }
        retCode = DIA_SUCCESS;
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagRegistry::loadRegPaths ( const dia_RegPathInfo regPathData[], tU16 numOfPaths )
{
    dia_tclFnctTrace oTrace("dia_PropertyBagRegistry::loadRegPaths");

    tDiaResult retCode = DIA_FAILED;

    if ( regPathData )
    {
        for ( tU16 i=0; i<numOfPaths; ++i )
        {
            mRegPathRep[regPathData[i].mRegPathID] = regPathData[i].mRegPathValue;
        }
        retCode = DIA_SUCCESS;
    }

    return retCode;
}

//----------------------------------------------------------------------------------------

const tChar*
dia_PropertyBagRegistry::queryRegKey  ( tU32 propID )
{
   const tChar* keyName = NULL;

   std::map<tU32,const tChar*>::iterator iter = mRegKeyRep.find(propID);

   if ( iter != mRegKeyRep.end() )
   {
      keyName = mRegKeyRep[propID];
   }
   else
   {
      DIA_TR_ERR("--- QueryRegKey failed (key=0x%x) ---", propID );
   }

   return keyName;
}

//----------------------------------------------------------------------------------------

const tChar*
dia_PropertyBagRegistry::queryRegPath ( tU32 propID )
{
   const tChar* pathName = NULL;

   std::map<tU32,const tChar*>::iterator iter = mRegPathRep.find(propID);

   if ( iter != mRegPathRep.end() )
   {
      pathName = mRegPathRep[propID];
   }
   else
   {
      DIA_TR_ERR("--- queryRegPath failed (key=0x%x) ---", propID );
   }

   return pathName;
}

