/*
 * dia_PropertyBagKDSVarLen.cpp
 *
 *  Created on: 18.06.2016
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_EXTERN_OSAL_SYSTEM_PIF__
#include "common/framework/platform/osal/dia_system_pif.h"
#endif

#ifndef __INCLUDED_DIA_COMMON_CONFIG__
#include "common/framework/config/dia_common_config.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DRIVER__
#include "common/framework/platform/dia_IDriver.h"
#endif

#ifndef __INCLUDED_DIA_OSAL_DRIVER_KDS__
#include "common/framework/platform/osal/dia_OSALDriverKDS.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_KDS_VARLEN__
#include <common/framework/config/dia_PropertyBagKDSVarLen.h>
#endif

namespace dia {

//----------------------------------------------------------------------------------------

PropertyBagKDSVarLen::PropertyBagKDSVarLen ( dia_PropertyBagKDS& propBagKDS )
   : dia_PropertyBag(DIA_C_STR_PROPBAG_KDS_VARLEN),
     mpPropBagKDS(&propBagKDS)
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::PropertyBagKDSVarLen(dia_PropertyBagKDS&)");
}

//----------------------------------------------------------------------------------------

PropertyBagKDSVarLen::~PropertyBagKDSVarLen ( void )
{
   mpPropBagKDS = 0;
}

//----------------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::open ( void )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::open");
   return ( mpPropBagKDS ) ? mpPropBagKDS->open() : DIA_E_OPEN_FAILED_KDS;
}

//----------------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::close ( void )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::close");
   return ( mpPropBagKDS ) ? mpPropBagKDS->close() : DIA_E_DRIVER_CLOSE_FAILED;
}

//------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::getProperty ( tU32 propID, tU8 propValue[], size_t* maxLength )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::getProperty(tU32,tU8[],size_t*) (byte stream)");

   if ( !mpPropBagKDS ) return DIA_E_INVALID_POINTER;

   tDiaResult retCode = DIA_FAILED;

   dia_PropertyInfo propData;
   if (queryProperty(propID, propData) != DIA_SUCCESS)
   {
      DIA_TR_INF("dia::PropertyBagKDSVarLen::getProperty(tU32,tU8[],tU32*) ERROR: DIA_E_INVALID_KEY");
      return DIA_E_INVALID_KEY;
   }

   if ( (!maxLength) || (!(*maxLength)) )
   {
      DIA_TR_INF("dia::PropertyBagKDSVarLen::getProperty - DIA_E_INVALID_LENGTH at getProperty(tU32,tU8[],tU32*)");
      return DIA_E_INVALID_LENGTH;
   }

   // KDS key where the data is stored
   tU16 key = static_cast<tU16>(propData.mPropExtData[0]);
   dia_OSALDriverKDS::sDataKDS dataBuffer(key, propValue, static_cast<tU16>(*maxLength));

   dia_IDriver* pDriverKDS = mpPropBagKDS->getDriverKDS();
   if ( pDriverKDS )
   {
      pDriverKDS->setCtrlSettings(DIA_C_U32_CTRL_SETTINGS_VARLEN_ENABLE,DIA_BOOL_CTRL_SETTINGS_MODE_VOLATILE);
      DIA_TR_INF("Reading KDS: Key=0x%04x, maxlen=%d", dataBuffer.mKey, dataBuffer.mLen);
      DIA_TR_INF("Reading KDS: &dataBuffer = %p, sizeof(data) = %zu", &dataBuffer, sizeof(dia_OSALDriverKDS::sDataKDS));

      tS32 readResult = pDriverKDS->read((tU8*) &dataBuffer, sizeof(dia_OSALDriverKDS::sDataKDS));
      DIA_TR_INF("Reading KDS: result = %d", readResult);
      DIA_TR_INF("Reading KDS: returned size = %d", dataBuffer.mLen);

      if (  readResult >= DIA_ERR_S32_DRIVER_SUCCESS )
      {
         retCode = DIA_SUCCESS;
      }
      DIA_TR_INF("Reading KDS done ...");
   }

   //---------------------------------------------
   // ADD NEW STATUSMASKS WITH NEW IF-STATEMENTS
   //---------------------------------------------
   if (propData.mStatusMask == SM_NO_STATUS_MASK)
   {
      *maxLength = dataBuffer.mLen;
      DIA_TR_INF("Reading KDS: *maxLength = %zu", *maxLength);
   }
   else if (propData.mStatusMask != SM_NO_STATUS_MASK)
   {
      tU16 statusMask = propData.mStatusMask;
      mpPropBagKDS->handleStatMask4Read(propID, propValue, statusMask, *maxLength);

      DIA_TR_INF("dia::PropertyBagKDSVarLen::getProperty length of data byte stream  %zu", *maxLength);
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::getProperty ( tU32 propID, std::vector<tU8>& propValue )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::getProperty(tU32,std::vector<tU8>&)");

   propValue.clear();

   dia_PropertyInfo propData;
   if (queryProperty(propID, propData) != DIA_SUCCESS)
   {
      DIA_TR_INF("dia::PropertyBagKDSVarLen::getProperty - DIA_E_INVALID_KEY at getProperty(propID, propValue, propLength)");
      return DIA_E_INVALID_KEY;
   }

   size_t length = propData.mPropSize;

   propValue.reserve( length );
   propValue.resize( length );

   tDiaResult retCode = getProperty (  propID, &propValue[0], &length );

   if(length < propValue.size())
   {
      while(length != propValue.size())
      {
        propValue.pop_back();
      }
   }

   DIA_TR_INF("propValue size after resize propValue.size() %zu, length %zu", propValue.size(), length);

   return retCode;
}

//------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::setProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::setProperty(tU32, tU8[], size_t)");

   if ( !mpPropBagKDS ) return DIA_FAILED;
   size_t maxSize = dia_getPropertySize(propID);
   if (!maxSize) return DIA_E_INVALID_KEY;
   DIA_TR_INF("propLength = %zu, maxSize = %zu",propLength,maxSize);
   if ( (!propLength) || (propLength > maxSize) )
   {
      DIA_TR_INF("No maxSize available or propLength larger than maxSize");
      return DIA_FAILED;
   }
   mpPropBagKDS->configureLengthCheck(false);
   tDiaResult retCode = mpPropBagKDS->setProperty(propID,propValue,propLength);
   mpPropBagKDS->configureLengthCheck(true);
   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
PropertyBagKDSVarLen::flush ( void )
{
   dia::ScopeTrace trc("dia::PropertyBagKDSVarLen::flush()");

   return ( mpPropBagKDS ) ? mpPropBagKDS->flush() : DIA_FAILED;
}

}

