/*!
 * \file       dia_PropertyBagFile.cpp
 *
 * \brief      {enter brief description here}
 *
 * \details    {enter detailed description here}
 *
 * \component  {enter component name}
 *
 * \ingroup    {enter group name}
 *
 * \copyright  (c) 2015 Robert Bosch Car Multimedia GmbH
 *
 */

#ifndef __INCLUDED_DIA_PROPERTY_BAG_FILE__
#include <common/framework/config/dia_PropertyBagFile.h>
#endif

#ifndef __INCLUDED_DIA_FILE__
#include <common/framework/application/dia_File.h>
#endif

//----------------------------------------------------------------------------------------

dia_PropertyBagFile::dia_PropertyBagFile ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_FILE)
{
    dia_tclFnctTrace trc("dia_PropertyBagFile::dia_PropertyBagFile");
}

//----------------------------------------------------------------------------------------

dia_PropertyBagFile::~dia_PropertyBagFile ( void )
{}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagFile::getProperty ( tU32 propID, std::vector<tU8>& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagFile::getProperty()");

   // ensure that the vector only contains data we want to read
   propValue.clear();

   dia_PropertyInfo propData;
   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   tCString fileName = (tCString) propData.mPropExtData[0];
   tCString filePath = (tCString) propData.mPropExtData[1];

   std::string fileNameWithPath(std::string(filePath) + std::string("/") + std::string(fileName));
   dia_File file(fileNameWithPath);
   if ( !(file.doesExist()) )
   {
      return DIA_E_FILE_DOES_NOT_EXIST;
   }

   tDiaResult retCode = file.open("rb+");
   if ( retCode == DIA_SUCCESS )
   {
      size_t numOfBytes = propData.mPropSize;
      propValue.reserve(numOfBytes);
      propValue.resize(numOfBytes);
      retCode = file.rawRead(&propValue[0],&numOfBytes);
      if ( (retCode != DIA_SUCCESS) || (numOfBytes == 0) )
      {
         retCode = DIA_E_FILE_READ_FAILED;
      }
      else
      {
         propValue.resize(numOfBytes);
      }

      DIA_TR_INF("%zu bytes read from file", propValue.size());
      (void) file.close();
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagFile::setProperty ( tU32 propID, const std::vector<tU8>& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagFile::setProperty(tU32, std::vector<tU8>&))");

   dia_PropertyInfo propData;
   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   tCString fileName = (tCString) propData.mPropExtData[0];
   tCString filePath = (tCString) propData.mPropExtData[1];

   std::string fileNameWithPath(std::string(filePath) + std::string("/") + std::string(fileName));
   dia_File file(fileNameWithPath);
   tDiaResult retCode = file.open("wb+");
   if ( retCode == DIA_SUCCESS )
   {
      size_t numOfBytes = propValue.size();
      retCode = file.rawWrite(const_cast<tU8*>(&propValue[0]),&numOfBytes);
      if ( (retCode != DIA_SUCCESS) || (numOfBytes != propValue.size()) )
      {
         retCode = DIA_E_FILE_WRITE_FAILED;
      }

      (void) file.close();
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagFile::setProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
   dia_tclFnctTrace trc("dia_PropertyBagFile::setProperty(tU32, tU8 propValue[], size_t propLength))");

   dia_PropertyInfo propData;
   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   tCString fileName = (tCString) propData.mPropExtData[0];
   tCString filePath = (tCString) propData.mPropExtData[1];

   std::string fileNameWithPath(std::string(filePath) + std::string("/") + std::string(fileName));
   dia_File file(fileNameWithPath);
   tDiaResult retCode = file.open("wb+");
   if ( retCode == DIA_SUCCESS )
   {
      DIA_TR_INF("##### dia_PropertyBagFile : propLength = %zu #####", propLength);
      size_t numOfBytes = propLength;
      DIA_TR_INF("##### dia_PropertyBagFile : numOfBytes = %zu #####", numOfBytes);
      retCode = file.rawWrite(propValue,&numOfBytes);
      if ( (retCode != DIA_SUCCESS) || (numOfBytes != propLength) )
      {
         retCode = DIA_E_FILE_WRITE_FAILED;
      }

      (void) file.close();
   }

   return retCode;
}

//----------------------------------------------------------------------------------------

tDiaResult 
dia_PropertyBagFile::getProperty ( tU32 propID, tU8 propValue[], size_t* propLength )
{
   dia_tclFnctTrace trc("dia_PropertyBagFile::getProperty(tU32, tU8, size_t*)");

   dia_PropertyInfo propData;
   if ( queryProperty(propID,propData) != DIA_SUCCESS )
   {
      return DIA_E_INVALID_KEY;
   }

   tCString fileName = (tCString) propData.mPropExtData[0];
   tCString filePath = (tCString) propData.mPropExtData[1];

   std::string fileNameWithPath(std::string(filePath) + std::string("/") + std::string(fileName));

   dia_File file(fileNameWithPath);

   if ( !(file.doesExist()) )
   {
      return DIA_E_FILE_DOES_NOT_EXIST;
   }

   tDiaResult retCode = file.open("rb+");

   if ( retCode == DIA_SUCCESS )
   {

      size_t numOfBytes = file.getSize();

      retCode = file.rawRead(propValue, &numOfBytes);

      if ( (retCode != DIA_SUCCESS) || (numOfBytes == 0) )
      {
         retCode = DIA_E_FILE_READ_FAILED;
      }
      else
      {
         *propLength = numOfBytes;
      }

      DIA_TR_INF("%zu bytes read from file", numOfBytes);
      (void) file.close();
   }

   return retCode;
}

