/*
 * dia_PropertyBagDatapool.cpp
 *
 *  Created on: 14.01.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_PROPERTY_BAG_DATAPOOL__
#include "dia_PropertyBagDatapool.h"
#endif

#ifndef __INCLUDED_DIA_DATAPOOL__
#include "common/framework/platform/aid/dia_datapool.h"
#endif

//#ifdef __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__
#include <unistd.h> //lint !e451 !e537 repeatedly included header file without standard include guard
//#endif

//----------------------------------------------------------------------------------------

dia_PropertyBagDatapool::dia_PropertyBagDatapool ( void )
    : dia_PropertyBag(DIA_C_STR_PROPBAG_DATAPOOL)
{
    dia_tclFnctTrace trc("dia_PropertyBagDatapool::dia_PropertyBagDatapool");
    DP_vCreateDatapool();
}

//----------------------------------------------------------------------------------------

dia_PropertyBagDatapool::~dia_PropertyBagDatapool ( void )
{
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::getProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::getProperty(tU32, tU8[], size_t)");

   dia_PropertyInfo propData;
   if ( queryProperty(propID, propData) != DIA_SUCCESS )
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],tU32) ERROR: DIA_E_INVALID_KEY");
      return DIA_E_INVALID_KEY;
   }

// tCString strDpName     = (tCString) propData.mPropExtData[0];
   tU16     dpID          =     (tU16) propData.mPropExtData[1];
   tU16     subID         =     (tU16) propData.mPropExtData[2];
   tCString strDpElemName = (tCString) propData.mPropExtData[3];

   tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

   if ( propData.mPropType == DIA_PROP_TYPE_STR )
   {
      dp_tclBaseElement dpElem(strDpElemName);
      tS32 status = DP_s32GetElement(dpPoolID, &dpElem, dpID);
      if ( status == 0 )
      {
         tU8* pDataBuffer = (tU8*) dpElem.pvGetData();
         size_t dataLength  = static_cast<size_t>(dpElem.u32GetDataLength());

         if ( propLength != dataLength )
         {
            DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t) ERROR: DIA_E_INVALID_LENGTH");
            return DIA_E_INVALID_LENGTH;
         }

         if( propData.mStatusMask & DIA_C_U16_PROP_SM_NO_DEFAULTS )
         {
            // if no default data is provided in element specification the datapool we return a byte buffer filled with zeros
            if ( dpElem.eGetElementState() == dp_tclBaseElement::eDpElemInit )
            {
               // here we know that we got a buffer filled with zeros, but we want to return a negative response in this case
               DIA_TR_INF("dia_PropertyBagDatapool::getProperty: No Default data available for property 0x%08x", propID);
               return DIA_E_NOT_AVAILABLE;
            }
         }

         ::memcpy(propValue,pDataBuffer,propLength);
      }
      else
      {
         DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t) ERROR: DIA_FAILED (DP_s32GetElement=%d)", status);
         return DIA_FAILED;
      }
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
      return DIA_E_NOT_SUPPORTED;
   }

   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::getProperty ( tU32 propID, tU8 propValue[], size_t* propLength )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::getProperty(tU32, tU8[], size_t*)");

   dia_PropertyInfo propData;
   if ( queryProperty(propID, propData) != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t*) ERROR: DIA_E_INVALID_KEY");
      return DIA_E_INVALID_KEY;
   }

   if ( (!propLength) || (!(*propLength)) || ((*propLength) < propData.mPropSize) )
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty - DIA_E_INVALID_LENGTH at getProperty(tU32,tU8[],size_t*)");
      return DIA_E_INVALID_LENGTH;
   }

// tCString strDpName     = (tCString) propData.mPropExtData[0];
   tU16     dpID          =     (tU16) propData.mPropExtData[1];
   tU16     subID         =     (tU16) propData.mPropExtData[2];
   tCString strDpElemName = (tCString) propData.mPropExtData[3];

   tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

   if ( propData.mPropType == DIA_PROP_TYPE_STR )
   {
      dp_tclBaseElement dpElem(strDpElemName);
      tS32 status = DP_s32GetElement(dpPoolID, &dpElem, dpID);
      if ( status == 0 )
      {
         tU8* pDataBuffer = (tU8*) dpElem.pvGetData();
         size_t dataLength  = static_cast<size_t>(dpElem.u32GetDataLength());

         if( propData.mStatusMask & DIA_C_U16_PROP_SM_NO_DEFAULTS )
         {
            // if no default data is provided in element specification the datapool we return a byte buffer filled with zeros
            if ( dpElem.eGetElementState() == dp_tclBaseElement::eDpElemInit )
            {
               // here we know that we got a buffer filled with zeros, but we want to return a negative response in this case
               DIA_TR_INF("dia_PropertyBagDatapool::getProperty: No Default data available for property 0x%08x", propID);
               *propLength = 0;
               return DIA_E_NOT_AVAILABLE;
            }
         }

         if( ((propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) == 0) && (dataLength != propData.mPropSize) )
         {
            // here we know that we got a buffer filled with zeros, but we want to return a negative response in this case
            DIA_TR_INF("dia_PropertyBagDatapool::getProperty: RECEIVED BYTE STREAM TOO SHORT (property = 0x%08x)", propID);
            *propLength = 0;
            return DIA_E_INVALID_LENGTH;
         }

//         if ( (*propLength) < dataLength )
//         {
//            DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],tU16) ERROR: DIA_E_INVALID_LENGTH (TOO SHORT)");
//            *propLength = 0;
//            return DIA_E_INVALID_LENGTH;
//         }

         *propLength = dataLength;
         ::memcpy(propValue,pDataBuffer,dataLength);
      }
      else
      {
         DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t*) ERROR: DIA_FAILED (DP_s32GetElement = %d)", status);
         return DIA_FAILED;
      }
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t*) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
      return DIA_E_NOT_SUPPORTED;
   }

   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::getProperty ( tU32 propID, std::vector<tU8>& propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::getProperty(tU32,std::vector<tU8>&)");

   dia_PropertyInfo propData;
   if ( queryProperty(propID, propData) != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_PropertyBagDatapool::getProperty(tU32,std::vector<tU8>&) ERROR: DIA_E_INVALID_KEY");
      return DIA_E_INVALID_KEY;
   }

// tCString strDpName     = (tCString) propData.mPropExtData[0];
   tU16     dpID          =     (tU16) propData.mPropExtData[1];
   tU16     subID         =     (tU16) propData.mPropExtData[2];
   tCString strDpElemName = (tCString) propData.mPropExtData[3];

   tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

   if ( propData.mPropType == DIA_PROP_TYPE_STR )
   {
      dp_tclBaseElement dpElem(strDpElemName);
      tS32 status = DP_s32GetElement(dpPoolID, &dpElem, dpID);
      if ( status == 0 )
      {
         tU8* pDataBuffer = (tU8*) dpElem.pvGetData();
         size_t dataLength  = static_cast<size_t>(dpElem.u32GetDataLength());

         DIA_TR_INF("dataLength = %zu", dataLength);

         if( propData.mStatusMask & DIA_C_U16_PROP_SM_NO_DEFAULTS )
         {
            // if no default data is provided in element specification the datapool we return a byte buffer filled with zeros
            if ( dpElem.eGetElementState() == dp_tclBaseElement::eDpElemInit )
            {
               // here we know that we got a buffer filled with zeros, but we want to return a negative response in this case
               DIA_TR_INF("dia_PropertyBagDatapool::getProperty: No Default data available for property 0x%08x", propID);
               return DIA_E_NOT_AVAILABLE;
            }
         }

         if ( dataLength > propData.mPropSize)
         {
            DIA_TR_INF("dia_PropertyBagDatapool::getProperty: TOO MANY BYTES RECEIVED: property 0x%08x", propID);
            return DIA_E_INVALID_LENGTH;
         }
         else if ( (dataLength < propData.mPropSize) && ((propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) == 0) )
         {
            DIA_TR_INF("dia_PropertyBagDatapool::getProperty: TOO SHORT (FIXED SIZE EXPECTED): property 0x%08x", propID);
            return DIA_E_INVALID_LENGTH;
         }

         propValue.clear();
         propValue.insert(propValue.end(), &pDataBuffer[0], &pDataBuffer[dataLength]);
      }
      else
      {
         DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,std::vector<tU8>&) ERROR: DIA_FAILED (DP_s32GetElement = %d)", status);
         return DIA_FAILED;
      }
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagDatapool::getProperty(tU32,std::vector<tU8>&) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
      return DIA_E_NOT_SUPPORTED;
   }

   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::setProperty ( tU32 propID, const std::vector<tU8>& propValue )
{
    dia_tclFnctTrace trc("dia_PropertyBagDatapool::setProperty(tU32, std::vector<tU8>&)");

    dia_PropertyInfo propData;
    if ( queryProperty(propID, propData) != DIA_SUCCESS )
    {
       DIA_TR_ERR("dia_PropertyBagDatapool::getProperty(tU32,std::vector<tU8>&) ERROR: DIA_E_INVALID_KEY");
       return DIA_E_INVALID_KEY;
    }

//  tCString strDpName     = (tCString) propData.mPropExtData[0];
    tU16     dpID          =     (tU16) propData.mPropExtData[1];
    tU16     subID         =     (tU16) propData.mPropExtData[2];
    tCString strDpElemName = (tCString) propData.mPropExtData[3];

    tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

    if( ((propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) == 0) && (propValue.size() != propData.mPropSize) )
    {
       // we know that we got a buffer filled with zeros, but we want to return a negative response in this case
       DIA_TR_INF("dia_PropertyBagDatapool::setProperty: RECEIVED BYTE STREAM TOO SHORT (property = 0x%08x)", propID);
       return DIA_E_INVALID_LENGTH;
    }

    if( (propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) && (propValue.size() > propData.mPropSize) )
    {
       // we know that we got a buffer filled with zeros, but we want to return a negative response in this case
       DIA_TR_INF("dia_PropertyBagDatapool::setProperty: TOO MANY BYTES RECEIVED FOR STORING (property = 0x%08x)", propID);
       return DIA_E_INVALID_LENGTH;
    }

    if ( propData.mPropType == DIA_PROP_TYPE_STR )
    {
       dp_tclBaseElement dpElem(strDpElemName);
       (void) dpElem.bFillData((void*) (&(const_cast<std::vector<tU8>&>(propValue))[0]), (tU16)propValue.size());
       tS32 status = DP_s32SetElement(dpPoolID, &dpElem, dpID);
       if ( status != 0 )
       {
          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,std::vector<tU8>&) ERROR: DIA_FAILED (DP_s32SetElement; %d)", status);
          return DIA_FAILED;
       }

       tDiaResult retCode = flushProperty(propData);
       if ( retCode != DIA_SUCCESS )
       {
          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,std::vector<tU8>&) ERROR: FLUSHING FAILED (retcode = 0x%08x)", retCode);
          return retCode;
       }
//
//       if ( (propData.mStatusMask & DIA_C_U16_PROP_SM_FLUSH_DISABLED) == 0 )
//       {
//          // synchronize to persistent memory
//          status = DP_s32StorePoolNow(dpPoolID,dpID);
//          if ( status != 0 )
//          {
//             DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,std::vector<tU8>&) ERROR: DIA_FAILED (DP_s32StorePoolNow; %d)", status);
//             return DIA_FAILED;
//          }
//       }
//       else
//       {
//          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,std::vector<tU8>&): FLUSHING DISABLED VIA STATUS MASK (propID = 0x%08x)", propID);
//       }
    }
    else
    {
       DIA_TR_INF("dia_PropertyBagDatapool::DP_s32SetElement(tU32,std::vector<tU8>&) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
       return DIA_E_NOT_SUPPORTED;
    }

    return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::setProperty ( tU32 propID, tU8 propValue[], size_t propLength )
{
    dia_tclFnctTrace trc("dia_PropertyBagDatapool::setProperty(tU32, tU8[], size_t)");

    dia_PropertyInfo propData;
    if ( queryProperty(propID, propData) != DIA_SUCCESS )
    {
       DIA_TR_ERR("dia_PropertyBagDatapool::getProperty(tU32,tU8[],size_t) ERROR: DIA_E_INVALID_KEY");
       return DIA_E_INVALID_KEY;
    }

//  tCString strDpName     = (tCString) propData.mPropExtData[0];
    tU16     dpID          =     (tU16) propData.mPropExtData[1];
    tU16     subID         =     (tU16) propData.mPropExtData[2];
    tCString strDpElemName = (tCString) propData.mPropExtData[3];

    tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

    if( ((propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) == 0) && (propLength != propData.mPropSize) )
    {
       // we know that we got a buffer filled with zeros, but we want to return a negative response in this case
       DIA_TR_ERR("dia_PropertyBagDatapool::setProperty: RECEIVED BYTE STREAM TOO SHORT (prop = 0x%08x)", propID);
       DIA_TR_ERR("dia_PropertyBagDatapool::setProperty: currLen=%zu maxLen=%zu", propLength, propData.mPropSize);
       return DIA_E_INVALID_LENGTH;
    }

    if( (propData.mStatusMask & DIA_C_U16_PROP_SM_VARIABLE_LENGTH) && (propLength > propData.mPropSize) )
    {
       // we know that we got a buffer filled with zeros, but we want to return a negative response in this case
       DIA_TR_ERR("dia_PropertyBagDatapool::setProperty: TOO MANY BYTES RECEIVED FOR STORING (prop = 0x%08x)", propID);
       DIA_TR_ERR("dia_PropertyBagDatapool::setProperty: currLen=%zu maxLen=%zu", propLength, propData.mPropSize);
       return DIA_E_INVALID_LENGTH;
    }

    if ( propData.mPropType == DIA_PROP_TYPE_STR )
    {
       dp_tclBaseElement dpElem(strDpElemName);
       (void) dpElem.bFillData((void*) propValue, (tU16)propLength);

       DIA_TR_INF("DP_s32SetElement called with params: dpPoolID=0x%08X, dpID=0x%04X, strDpElemName=%s", dpPoolID, dpID, (NULL!=strDpElemName)? strDpElemName : "(!NULL!)" );

       tS32 status = DP_s32SetElement(dpPoolID, &dpElem, dpID);
       if ( status != 0 )
       {
          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,tU8[],size_t) ERROR: DIA_FAILED (DP_s32SetElement; %d)", status);
          return DIA_FAILED;
       }

       tDiaResult retCode = flushProperty(propData);
       if ( retCode != DIA_SUCCESS )
       {
          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,tU8[],size_t) ERROR: FLUSHING FAILED (retcode = 0x%08x)", retCode);
          return retCode;
       }
//       if ( (propData.mStatusMask & DIA_C_U16_PROP_SM_FLUSH_DISABLED) == 0 )
//       {
//          // synchronize to persistent memory
//          status = DP_s32StorePoolNow(dpPoolID,dpID);
//          if ( status != 0 )
//          {
//             DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,tU8[],tU16) ERROR: DIA_FAILED (DP_s32StorePoolNow; %d)", status);
//             return DIA_FAILED;
//          }
//       }
//       else
//       {
//          DIA_TR_INF("dia_PropertyBagDatapool::setProperty(tU32,tU8[],tU16): FLUSHING DISABLED VIA STATUS MASK (propID = 0x%08x)", propID);
//          markDirty(propID);
//       }
    }
    else
    {
       DIA_TR_INF("dia_PropertyBagDatapool::DP_s32SetElement(tU32,tU8[],size_t) ERROR: UNSUPPORTED TYPE (%d)",propData.mPropType);
       return DIA_E_NOT_SUPPORTED;
    }

    return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::flushProperty ( dia_PropertyInfo& propInfo )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::flushProperty()");

   tU16     dpID =   (tU16) propInfo.mPropExtData[1];
   tU16    subID =   (tU16) propInfo.mPropExtData[2];
   tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

   if ( (propInfo.mStatusMask & DIA_C_U16_PROP_SM_FLUSH_DISABLED) == 0 )
   {
      // synchronize to persistent memory
      tS32 status = DP_s32StorePoolNow(dpPoolID,dpID);
      if ( status != 0 )
      {
         DIA_TR_ERR("dia_PropertyBagDatapool::flushProperty() ERROR: DIA_FAILED (DP_s32StorePoolNow; %d)", status);
         return DIA_FAILED;
      }
      else
      {
         DIA_TR_INF("dia_PropertyBagDatapool::flushProperty() DP_s32StorePoolNow OK PropKey=0x%08X.", propInfo.mPropKey);
      }

//#ifdef __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# CALLING UNIX::SYNC                          #");
      DIA_TR_INF("###############################################");
#ifndef __DIA_UNIT_TESTING__
      sync();
      OSAL_s32ThreadWait(100);
      sync();
      OSAL_s32ThreadWait(100);
#endif
//#endif
   }
   else
   {
      DIA_TR_INF("dia_PropertyBagDatapool::flushProperty(tU32,tU8[],tU16) INFO: FLUSHING DISABLED VIA STATUS MASK (propID = 0x%p)", propInfo.mPropExtData);
      markDirty(propInfo.mPropKey);
   }

   return DIA_SUCCESS;
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::flush ( void )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::flush()");

   std::list<tU32> alreadyFlushedDatapoolIDs;

   std::list<dia_PROPID>::iterator iter = mDirtyList.begin();
   for ( ; iter != mDirtyList.end(); iter++ )
   {
      dia_PropertyInfo propData;
      if ( queryProperty(*iter, propData) != DIA_SUCCESS )
      {
         DIA_TR_ERR("dia_PropertyBagDatapool::flush() INFO: IGNORED INVALID ENTRY IN DIRTY LIST (PROPD_ID = 0x%08x)",*iter);
         continue;
      }

//    tCString strDpName     = (tCString) propData.mPropExtData[0];
      tU16     dpID          =     (tU16) propData.mPropExtData[1];
      tU16     subID         =     (tU16) propData.mPropExtData[2];
//    tCString strDpElemName = (tCString) propData.mPropExtData[3];

      tU32 dpPoolID = (((tU32) dpID) << 16) + (((tU32) subID) & 0x0000FFFF);

      DIA_TR_INF("dia_PropertyBagDatapool::flush() PropKey=0x%08X dpPoolID=0x%08X", propData.mPropKey, dpPoolID);

      std::list<tU32>::const_iterator flushedIter = std::find(alreadyFlushedDatapoolIDs.begin(), alreadyFlushedDatapoolIDs.end(), dpPoolID); //lint !e864: Expression involving variable possibly depends on order of evaluation
      if ( flushedIter == alreadyFlushedDatapoolIDs.end() )
      {
         // synchronize to persistent memory
         tS32 status = DP_s32StorePoolNow(dpPoolID,dpID);
         if ( status != 0 )
         {
            DIA_TR_ERR("dia_PropertyBagDatapool::flush() ERROR: DIA_FAILED (DP_s32StorePoolNow; dpid = 0x%04x, subid = 0x%04x, status = %d)", dpID, subID, status);
            return DIA_FAILED;
         }
         else
         {
            DIA_TR_INF("dia_PropertyBagDatapool::flush() DP_s32StorePoolNow OK. PropKey=0x%08X.", propData.mPropKey);
         }
         alreadyFlushedDatapoolIDs.push_back(dpPoolID);
      }
      else
      {
         DIA_TR_WRN("dia_PropertyBagDatapool::flush() dpPoolID=0x%08X already on the list.", dpPoolID);
      }
   }

   if (mDirtyList.size()!=0)
   {
//#ifdef __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__
      DIA_TR_INF("###############################################");
      DIA_TR_INF("# CALLING UNIX::SYNC                          #");
      DIA_TR_INF("###############################################");
#ifndef __DIA_UNIT_TESTING__
      sync();
      OSAL_s32ThreadWait(100);
      sync();
      OSAL_s32ThreadWait(100);
#endif
//#endif
   }

   alreadyFlushedDatapoolIDs.clear();

   return dia_PropertyBag::flush();
}

//----------------------------------------------------------------------------------------

tDiaResult
dia_PropertyBagDatapool::setPropertyU8 ( tU32 propID, tU8 propValue )
{
   dia_tclFnctTrace trc("dia_PropertyBagDatapool::setPropertyU8(tU32, tU8)");

   tU8 byteArray[1];
   byteArray[0] = propValue;

   DIA_TR_INF("Write one byte to DP: propID=0x%08X, value=0x%02X", propID, propValue);

   return setProperty( propID, byteArray, (tU16)(sizeof(byteArray)/sizeof(byteArray[0])) );
}
