#ifndef __INCLUDED_DIA_PROPERTY_BAG_ADC__
#define __INCLUDED_DIA_PROPERTY_BAG_ADC__

#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#include "common/framework/config/dia_PropertyBag.h"
#endif

class dia_PropertyBagADC
   : public dia_PropertyBag

{
public:
   //! this is the only class constructor subclasses can use
   dia_PropertyBagADC ( void );
   //! class destructor
   virtual ~dia_PropertyBagADC ( void );

   //
   // overloaded methods from dia_PropertyBag base class
   //

   //! open the property bag
   virtual tDiaResult open ( void ) override;
   //! open the property bag
   virtual tDiaResult close ( void ) override;
   //! open the property bag
   virtual bool bIsOpen ( void ) override;

   //! return the size of the given property
   virtual size_t getSize ( tU32 propID ) override;

   //! retrieve a 2 byte property
   virtual tDiaResult getPropertyU16 ( tU32 /*propID*/, tU16& /*propValue*/ ) override;
   //! retrieve a 4 byte property stored in ADC
   virtual tDiaResult getPropertyU32 ( tU32 /*propID*/, tU32& /*propValue*/ ) override;

protected:
   //! native read method
   virtual tDiaResult readADCValue ( tU32& ADCValue, tU32 resolution = 0 );

private:
   //! device descriptor of the KDS driver
   OSAL_tIODescriptor mDrvHandle;
   //! flag to indicate whether the driver was opened or not
   bool mIsOpenADC;
   //! ADC identifier
   dia_enPropADCDevice mADCID;
   //! ADC resolution
   tU32 mADCRes;
   //! ADC mask
   tU32 mADCMask;
};

#endif
