#ifndef __INCLUDED_DIA_PROPERTY_BAG__
#define __INCLUDED_DIA_PROPERTY_BAG__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include <common/framework/config/dia_defsConfig.h>
#endif

#ifndef __INCLUDED_DIA_ENGINE_CLIENT_INTERFACE__
#include "common/framework/config/dia_IEngineClient.h"
#endif

//----------------------------------------------------------------------------------------

class dia_PropertyBag
   : public dia_ObjectWithUID
{
public:
   //! class destructor
   virtual ~dia_PropertyBag ( void );

   //! open the property bag. must be provided by specific subclasses
   virtual tDiaResult open ( void ) = 0;
   //! open the property bag. must be provided by specific subclasses
   virtual tDiaResult close ( void ) = 0;
   //! open the property bag
   virtual bool bIsOpen ( void );

//    //! return the type of the property bag that provides the information were the properties are getting stored
//    dia_UID getType ( void ) const;

    //! return the size of the given property
    virtual size_t getSize ( tU32 propID );

    //! retrieve a byte stream property of <propLength> size in bytes. stream is returned as array. length must match exactly
    virtual tDiaResult getProperty ( tU32 propID, tU8 []/*propValue[]*/, size_t /*propLength*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(dia_PROPID,tU8[],tU16)"); }
    //! retrieve a byte stream property of up to <maxLength> size in bytes. stream is returned as array. actual size of returned stream will be assigned to parameter <maxLength>
    virtual tDiaResult getProperty ( tU32 propID, tU8 []/*propValue[]*/, size_t* /*maxLength*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(dia_PROPID,tU8[],*tU16)"); }
    //! retrieve a a byte stream property. stream is returned as vector container. size of stream can be retrieved from vector
    virtual tDiaResult getProperty ( tU32 propID, std::vector<tU8>& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(std::vector<tU8>&)"); }
    //! retrieve a 1 byte property
    virtual tDiaResult getPropertyU8 ( tU32 propID, tU8&  /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,tU8&)"); }
    //! retrieve a 2 byte property
    virtual tDiaResult getPropertyU16 ( tU32 propID, tU16& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,tU16&)"); }
    //! retrieve a 4 byte property
    virtual tDiaResult getPropertyU32 ( tU32 propID, tU32& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,tU32&)"); }
    //! retrieve a boolean property of type tBool (not recommended for future use)
    virtual tDiaResult getPropertyBool ( tU32 propID, tBool& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,tBool&)"); }
    //! retrieve a boolean property of type bool
    virtual tDiaResult getPropertyBoolean ( tU32 propID, bool& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,bool&)"); }
    //! retrieve a 1 byte property asynchronously (thread unsafe)
    virtual tDiaResult getProperty ( tU32 propID, dia_IEngineClient* /*callback*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::getProperty(tU32,dia_IEngineClient*)"); }

    //! set property (assign an byte stream of <propLength> size in bytes)
    virtual tDiaResult setProperty ( tU32 propID, tU8 [] /*propValue[]*/, size_t /*propLength*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,tU8[],tU32)"); }
    //! set property (assign an byte stream using a vector container)
    virtual tDiaResult setProperty ( tU32 propID, const std::vector<tU8>& /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,const std::vector<tU8>&)"); }
    //! set property (assign 1 byte value)
    virtual tDiaResult setPropertyU8 ( tU32 propID, tU8 /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,tU8)"); }
    //! set property (assign 2 byte value)
    virtual tDiaResult setPropertyU16 ( tU32 propID, tU16 /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,tU16)"); }
    //! set property (assign 4 byte value)
    virtual tDiaResult setPropertyU32 ( tU32 propID, tU32 /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,tU32)"); }
    //! set property (assgn bool value)
    virtual tDiaResult setPropertyBoolean ( tU32 propID, bool /*propValue*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setProperty(tU32,bool)"); }
    //! set property (assign 1 byte value) asynchronously (thread unsafe)
    virtual tDiaResult setPropertyU8 ( tU32 propID, tU8 /*propValue*/, dia_IEngineClient* /*callback*/ ) { DIA_RETURN_PROPERTY_BASED_METHOD_NOT_IMPLEMENTED(propID,"dia_PropertyBag::setPropertyU8(tU32,tU8,dia_IEngineClient*)"); }

    //! update internal lookup tables
    virtual tDiaResult update ( void ) { return DIA_SUCCESS; }
    //! get number of properties controlled by this property bag
    virtual tU16 getCardinality ( void ) const { return 0; }
    //! flush properties to persistent memory if required
    virtual tDiaResult flush ( void );
    //! check if unsaved (volatile) properties exist
    virtual bool isDirty ( void ) const { return mDirtyList.size() ? true : false; }
    //! mark the given property as dirty (volatile) by adding it to the dirty list
    virtual bool isDirty ( dia_PROPID propID ) const;

protected:
    //! this is the only class constructor subclasses can use
    dia_PropertyBag ( tCString name);
    // we prevent everyone to use the default constructor
    dia_PropertyBag ( void );

    //! this method is used to query for a property in the config managers repository
    tDiaResult queryProperty ( tU32 propID, dia_PropertyInfo& propData ) const;
    //! this method is used to query for a property in the config managers repository
    tDiaResult queryProperties ( dia_UID location, std::list<dia_PropertyInfo*>& props ) const;
    //! this method is used to update the data for a property in the config managers repository
    tDiaResult updateProperty ( /*tU32 propID,*/ const dia_PropertyInfo& propData ) const;

    //! mark the given property as dirty (volatile) by adding it to the dirty list
    virtual void markDirty ( dia_PROPID propID );

protected:
    //! flag to indicate if the property bag is opened or closed
    bool mIsOpen;
    //! dirty list
    std::list<dia_PROPID> mDirtyList;
};

#endif
