/*!
 * \file       dia_IKDS.h
 *
 * \brief      Interface for external access to the native KDS driver
 *
 * \details    Interface for external access to the native KDS driver
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreConfig
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_NATIVE_KDS_INTERFACE__
#define __INCLUDED_DIA_NATIVE_KDS_INTERFACE__

#ifndef __INCLUDED_DIA_DEFS_CONFIG__
#include "dia_defsConfig.h"
#endif

class dia_IKDSListener;

class dia_IKDS
{
   DIA_DECL_CONFIGMANAGER_IID(DIA_C_IID_CONFMGR_KDS)

public:
   enum enFlushMode { DIA_EN_KDS_FLUSH_ENABLE=0, DIA_EN_KDS_FLUSH_DISABLE };

   //! direct read access to KDS
   virtual tDiaResult readKDS  ( tU16 kdsKey, tU8 kdsData[], tU16 length ) = 0;
   //! direct write access to KDS
   virtual tDiaResult writeKDS ( tU16 kdsKey, tU8 kdsData[], tU16 length ) = 0;
   //! native flushing of KDS
   virtual tDiaResult flushKDS ( void ) = 0;
   //! enable/disable flushing of the KDS device
   virtual tDiaResult setFlushMode ( enFlushMode mode ) = 0;

   //! register a listener for the given KDS key
   virtual tDiaResult addKDSListener ( tU16 /*kdsKey*/, dia_IKDSListener* /*pListener*/ ) { return DIA_E_NOT_SUPPORTED; }
   //! unregister a listener for the given KDS key
   virtual tDiaResult removeKDSListener ( tU16 /*kdsKey*/, dia_IKDSListener* /*pListener*/ ) { return DIA_E_NOT_SUPPORTED; }

protected:
    //! virtual class destructor
    virtual ~dia_IKDS ( void ) {}
};

#endif
