/**
 * \file      dia_ConfigNotifier.cpp
 *
 * \brief     {insert brief description here}
 *
 * \details   {insert file description here}
 *
 * \author    gib2hi
 * \date      31.01.2013
 *
 * \copyright Robert Bosch Car Multimedia 2013
 */

#ifndef __INCLUDED_DIA_CONFIG_NOTIFIER__
#include "dia_ConfigNotifier.h"
#endif

//-----------------------------------------------------------------------------

dia_ConfigNotifier::dia_ConfigNotifier ( tCString name, tU32 propID )
   : mConfigNotifierName(name)
{
   DIA_TR_INF("dia_ConfigNotifier::dia_ConfigNotifier propID=0x%08X name=%s", propID, name);
   if ( propID != DIA_PROP_INVALID_IDENTIFIER ) addProperty(propID);
}

//-----------------------------------------------------------------------------

dia_ConfigNotifier::~dia_ConfigNotifier ( void )
{
   mConfigNotifierName = 0;
}

//-----------------------------------------------------------------------------

bool
dia_ConfigNotifier::queryProperty ( tU32 propID ) const
{
   std::map<tU32,dia_Property>::const_iterator iter = mPropRep.find(propID);
   return ( iter != mPropRep.end() ) ? true : false;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ConfigNotifier::getProperties ( std::vector<tU32>& results ) const
{
   results.clear();
   std::map<tU32,dia_Property>::const_iterator iter = mPropRep.begin();
   for ( ; iter != mPropRep.end(); iter++ ) {
      results.push_back(iter->first);
   }
   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ConfigNotifier::addProperty ( tU32 propID )
{
   dia_tclFnctTrace oTrace("dia_ConfigNotifier::addProperty()");

   std::map<tU32,dia_Property>::iterator iter = mPropRep.find(propID);

   // check if the property does not already exist in the repository
   if ( iter != mPropRep.end() )
   {
      DIA_TR_ERR("dia_ConfigNotifier::addProperty DIA_E_KEY_ALREADY_EXISTS propID=0x%08X", propID);
      return DIA_E_KEY_ALREADY_EXISTS;
   }

   // property does not exist, so we create a new entry in the repository
   dia_Property prop(propID);
   if ( prop.load() != DIA_SUCCESS )
   {
      DIA_TR_ERR("dia_ConfigNotifier::addProperty DIA_E_KEY_NOT_AVAILABLE propID=0x%08X", propID);
      return DIA_E_KEY_NOT_AVAILABLE;
   }
   mPropRep[propID] = prop;

   return DIA_SUCCESS;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_ConfigNotifier::removeProperty ( tU32 propID )
{
   dia_tclFnctTrace oTrace("dia_ConfigNotifier::removeProperty()");

   std::map<tU32,dia_Property>::iterator iter = mPropRep.find(propID);

   // check if the property really exists in the repository
   if ( iter == mPropRep.end() ) return DIA_E_KEY_NOT_FOUND;

   mPropRep.erase(propID);

   return DIA_SUCCESS;
}

