/*!
 * \file       dia_defsPlatform.h
 *
 * \brief      Platform specific defines
 *
 * \details    Platform specific defines
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2012-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_DEFS_PLATFORM__
#define __INCLUDED_DIA_DEFS_PLATFORM__

//
// Default thread configuration
//

#define DIA_C_U32_PLATFORM_DEFAULT_THREAD_PRIORITY                   ((tU32)  0x5f) //(OSAL_C_U32_THREAD_PRIORITY_NORMAL-1)
#define DIA_C_U32_PLATFORM_DEFAULT_THREAD_STACK_SIZE                 ((tU32) 50000)

//
// application state
//

namespace dia {
typedef tU32 ApplicationStateID;
}

#define DIA_C_U32_APP_STATE_INVALID                                   ((dia::ApplicationStateID) 0x00000000) // AMT_C_U32_STATE_INVALID
#define DIA_C_U32_APP_STATE_UNKNOWN                                   ((dia::ApplicationStateID) 0x00000000) // AMT_C_U32_STATE_INVALID
#define DIA_C_U32_APP_STATE_UNINITALIZED                              ((dia::ApplicationStateID) 0x00000001) // AMT_C_U32_STATE_UNINITALIZED
#define DIA_C_U32_APP_STATE_INITIALIZED                               ((dia::ApplicationStateID) 0x00000002) // AMT_C_U32_STATE_INITIALIZED
#define DIA_C_U32_APP_STATE_NORMAL                                    ((dia::ApplicationStateID) 0x00000003) // AMT_C_U32_STATE_NORMAL
#define DIA_C_U32_APP_STATE_DIAGNOSIS                                 ((dia::ApplicationStateID) 0x00000004) // AMT_C_U32_STATE_DIAGNOSIS
#define DIA_C_U32_APP_STATE_PAUSE                                     ((dia::ApplicationStateID) 0x00000005) // AMT_C_U32_STATE_PAUSE
#define DIA_C_U32_APP_STATE_PREPARE_DOWNLOAD                          ((dia::ApplicationStateID) 0x00000006) // AMT_C_U32_STATE_PREPARE_DOWNLOAD
#define DIA_C_U32_APP_STATE_RECEIVE_READY                             ((dia::ApplicationStateID) 0x00000007) // AMT_C_U32_STATE_RECEIVE_READY
#define DIA_C_U32_APP_STATE_OFF                                       ((dia::ApplicationStateID) 0x00000008) // AMT_C_U32_STATE_OFF
#define DIA_C_U32_APP_STATE_COUNT                                     ((dia::ApplicationStateID) 0x00000009)

#define DIA_C_U16_DIAGNOSTICS_APP_ID                                  ((tU16) 0x0114) // CCA_C_U16_APP_DIAGDEBUG
#define DIA_C_U16_DIAGNOSTICS_SRV_ID                                  ((tU16) 0x0117) // CCA_C_U16_SRV_DIAGDEBUG

//
// Default run level defines
//

#define DIA_C_U8_RUNLEVEL_1                                          ((tU8) 0x01) // app has passed bOnInit()
#define DIA_C_U8_RUNLEVEL_2                                          ((tU8) 0x02) // app has reached NORMAL
#define DIA_C_U8_RUNLEVEL_3                                          ((tU8) 0x02) // app has reached NORMAL

enum dia_enRunlevel
{
    DIA_EN_RUNLEVEL_UNDEFINED = 0,
    DIA_EN_RUNLEVEL_1,
    DIA_EN_RUNLEVEL_2,
    DIA_EN_RUNLEVEL_3,
    DIA_EN_RUNLEVEL_COUNT
};

#define DIA_C_U8_UDS_SERVICE_SUPPORTED                               ((tU8) 0x00)
#define DIA_C_U8_UDS_SERVICE_PARTLY_SUPPORTED                        ((tU8) 0x01)
#define DIA_C_U8_UDS_SERVICE_NOT_SUPPORTED                           ((tU8) 0x02)
#define DIA_C_U8_UDS_SERVICE_SUPPORTED_SELECTIVELY                   ((tU8) 0x03)

// voltage levels
#define DIA_C_U8_POWER_LOW_CRITICAL                                  ((tU8) 0x01)
#define DIA_C_U8_POWER_LOW                                           ((tU8) 0x02)
#define DIA_C_U8_POWER_NORMAL                                        ((tU8) 0x03)
#define DIA_C_U8_POWER_HIGH                                          ((tU8) 0x04)
#define DIA_C_U8_POWER_HIGH_CRITICAL                                 ((tU8) 0x05)

enum dia_enPowerLevel
{
    ePowerUndefined = 0,
    ePowerLowCritical,
    ePowerLow,
    ePowerNormal,
    ePowerHigh,
    ePowerHighCritical,
    ePowerCount
};

enum dia_enOEMType
{
   eOEM_VW = 0,
   eOEM_SEAT,
   eOEM_SKODA,
   eOEM_AUDI,
   eOEM_BMW,
   eOEM_TATA,
   eOEM_NISSAN,
   eOEM_TOYOTA,
   eOEM_RENAULT,
   eOEM_FIAT,
   eOEM_GM,
   eOEM_OPEL,
   eOEM_SUZUKI,
   eOEM_MAZDA,
   eOEM_PEUGEOT,
   eOEM_SCANIA,
   eOEM_DAIMLER,
   eOEM_PROTON,
   eOEM_HYUNDAI,
   eOEM_COUNT
};

#define DIA_C_U8_MAX_SESSIONS                                        ((tU8)     10)
#define DIA_C_U8_MAX_ARGS                                            ((tU8)      5)

#define DIA_C_U32_MAX_STATE_CHANGE_DELAY                             ((tU32) 25000)

//#define __ENABLE_FEATURE_SYNC_ON_KDS_FILESYSTEM_FLUSH__

#define __ENABLE_FEATURE_SYNC_ON_ECU_RESET__

#endif
