/*
 * dia_VideoSourceControlPluginRVC.cpp
 *
 *  Created on: 02.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include "common/framework/sysadapters/dia_SystemAdapterFacade.h"
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__
#include "common/framework/application/dia_VideoSourceControl.h"
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN_RVC__
#include "common/framework/application/dia_VideoSourceControlPluginRVC.h"
#endif

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginRVC::dia_VideoSourceControlPluginRVC ( void )
   : dia_VideoSourceControlPlugin ( "dia_VideoSourceControlPluginRVC", DIA_EN_VIDEO_SOURCE_ID_RVC )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginRVC::dia_VideoSourceControlPluginRVC()");
}

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginRVC::~dia_VideoSourceControlPluginRVC ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IRVCameraListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_VideoSourceControlPluginRVC::~dia_VideoSourceControlPluginRVC !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginRVC::startVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginRVC::startVideoStreaming()");

   tDiaResult retCode = DIA_FAILED;

   dia_IRVCamera* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IRVCamera>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_IRVCameraListener>(this);

      if ( pInterface->startVideoStreamingRVC() == DIA_SUCCESS )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_VideoSourceControlPluginRVC::startVideoStreaming => Error: FAILED TO SEND STREAMING START REQUEST !");
      }
   }
   else
   {
      DIA_TR_ERR("dia_VideoSourceControlPluginRVC::startVideoStreaming => Error: FAILED TO GET POINTER TO INTERFACE (dia_IRVCameraListener) !");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginRVC::stopVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginRVC::stopVideoStreaming()");

   tDiaResult retCode = DIA_FAILED;

   dia_IRVCamera* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IRVCamera>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_IRVCameraListener>(this);

      if ( pInterface->stopVideoStreamingRVC() == DIA_SUCCESS )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_VideoSourceControlPluginRVC::stopVideoStreamingRVC => Error: FAILED TO SEND STREAMING STOP REQUEST !");
      }
   }
   else
   {
      DIA_TR_ERR("dia_VideoSourceControlPluginRVC::stopVideoStreamingRVC => Error: FAILED TO GET POINTER TO INTERFACE (dia_IRVCameraListener) !");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_VideoSourceControlPluginRVC::vOnStartVideoStreamingRVC ( tDiaResult resultCode )
{
   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStarted(this,resultCode);
   }
}

//-----------------------------------------------------------------------------

void
dia_VideoSourceControlPluginRVC::vOnStopVideoStreamingRVC ( tDiaResult resultCode )
{
   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStopped(this,resultCode);
   }
}
