/*
 * dia_VideoSourceControlPluginDVD.cpp
 *
 *  Created on: 02.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_SYSTEM_ADAPTER_FACADE__
#include <common/framework/sysadapters/dia_SystemAdapterFacade.h>
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL__
#include <common/framework/application/dia_VideoSourceControl.h>
#endif

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN_DVD__
#include <common/framework/application/dia_VideoSourceControlPluginDVD.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_DVDPLAYER__
#include <common/interfaces/dia_IDVDPlayer.h>
#endif

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginDVD::dia_VideoSourceControlPluginDVD ( void )
   : dia_VideoSourceControlPlugin ( "dia_VideoSourceControlPluginDVD", DIA_EN_VIDEO_SOURCE_ID_DVD )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginDVD::dia_VideoSourceControlPluginDVD()");
}

//-----------------------------------------------------------------------------

dia_VideoSourceControlPluginDVD::~dia_VideoSourceControlPluginDVD ( void )
{
   _BP_TRY_BEGIN
   {
      (void) unsetSysAdapterListener<dia_IDVDPlayerListener>(this);
   }
   _BP_CATCH_ALL
   {
      DIA_TR_ERR("EXCEPTION CAUGHT: dia_VideoSourceControlPluginDVD::~dia_VideoSourceControlPluginDVD !!!");
      DIA_ASSERT_ALWAYS();
   }
   _BP_CATCH_END
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginDVD::startVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginDVD::startVideoStreaming()");

   tDiaResult retCode = DIA_FAILED;

   dia_IDVDPlayer* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IDVDPlayer>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_IDVDPlayerListener>(this);

      if ( pInterface->startVideoStreamingDVD() == DIA_SUCCESS )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_VideoSourceControlPluginDVD::startVideoStreaming => Error: FAILED TO SEND STREAMING START REQUEST !");
      }
   }
   else
   {
      DIA_TR_ERR("dia_VideoSourceControlPluginDVD::startVideoStreaming => Error: FAILED TO GET POINTER TO INTERFACE (dia_IDVDPlayerListener) !");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

tDiaResult
dia_VideoSourceControlPluginDVD::stopVideoStreaming ( void )
{
   dia_tclFnctTrace oTrace("dia_VideoSourceControlPluginDVD::stopVideoStreaming()");

   tDiaResult retCode = DIA_FAILED;

   dia_IDVDPlayer* pInterface = 0;
   if ( (querySysAdapterInterface<dia_IDVDPlayer>(&pInterface) == DIA_SUCCESS) && pInterface )
   {
      (void) setSysAdapterListener<dia_IDVDPlayerListener>(this);

      if ( pInterface->stopVideoStreamingDVD() == DIA_SUCCESS )
      {
         retCode = DIA_SUCCESS;
      }
      else
      {
         DIA_TR_ERR("dia_VideoSourceControlPluginDVD::stopVideoStreamingDVD => Error: FAILED TO SEND STREAMING STOP REQUEST !");
      }
   }
   else
   {
      DIA_TR_ERR("dia_VideoSourceControlPluginDVD::stopVideoStreamingDVD => Error: FAILED TO GET POINTER TO INTERFACE (dia_IDVDPlayerListener) !");
   }

   return retCode;
}

//-----------------------------------------------------------------------------

void
dia_VideoSourceControlPluginDVD::vOnStartVideoStreamingDVD ( tDiaResult resultCode )
{
   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStarted(this,resultCode);
   }
}

//-----------------------------------------------------------------------------

void
dia_VideoSourceControlPluginDVD::vOnStopVideoStreamingDVD ( tDiaResult resultCode )
{
   dia_VideoSourceControl* pVideoSrvControl = getInstanceOfVideoSourceControl();
   if ( pVideoSrvControl )
   {
      pVideoSrvControl->vOnVideoStreamingStopped(this,resultCode);
   }
}
