/*
 * dia_VideoSourceControlPlugin.h
 *
 *  Created on: 01.07.2014
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN__
#define __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_VIDEOSOURCECONTROL__
#include "common/interfaces/dia_IVideoSourceControl.h"
#endif

#define DIA_PLUGIN_NAME_BUFF_LEN (40)

class dia_VideoSourceControlPlugin
{
   friend class dia_VideoSourceControl;

public:
   //! class constructor
   dia_VideoSourceControlPlugin ( tCString name, dia_eVideoSourceID id );
   //! class destructor
   virtual ~dia_VideoSourceControlPlugin ( void );

   //! retrieve the levels name
   virtual const tS8* getName ( void ) const;

   //! return the remote control type of the plugin
   dia_eVideoSourceID eGetType ( void ) const;

   virtual tDiaResult startVideoStreaming ( void );
   virtual tDiaResult stopVideoStreaming ( void );

protected:
   //! class constructor
   dia_VideoSourceControlPlugin ( void );

protected:
   //! name of the service handler
   tS8 mPluginName[DIA_PLUGIN_NAME_BUFF_LEN];

   //! id of the currently activated security level
   dia_eVideoSourceID mPluginID;
};

#endif /* __INCLUDED_DIA_VIDEO_SOURCE_CONTROL_PLUGIN__ */
