/*!
 * \file       dia_Socket.h
 *
 * \brief      Socket class
 *
 * \details    Socket class used to create a socket for INC communication with SCC.
 *
 * \component  Diagnosis
 *
 * \ingroup    diaCoreAppFrw
 *
 * \copyright  (c) 2015-2016 Robert Bosch GmbH
 *
 * The reproduction, distribution and utilization of this file as
 * well as the communication of its contents to others without express
 * authorization is prohibited. Offenders will be held liable for the
 * payment of damages. All rights reserved in the event of the grant
 * of a patent, utility model or design.
 */

#ifndef __INCLUDED_DIA_SOCKET__
#define __INCLUDED_DIA_SOCKET__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifdef USE_DGRAM_SERVICE
#include "dgram_service.h"
#endif

namespace dia
{

class SocketConfiguration;

class INCSocket
{

public:
   INCSocket( SocketConfiguration& config );
   virtual ~INCSocket( void );

   virtual tDiaResult create ( void );
   virtual tDiaResult close ( void );
   virtual tDiaResult connect ( void );
   virtual tDiaResult disconnect ( void );

   virtual tDiaResult readData ( tU8 data[], tU16& length );
   virtual tDiaResult readData ( std::vector<tU8>& data );
   virtual tDiaResult writeData ( const tU8 data[], tU16 length );
   virtual tDiaResult writeData ( const std::vector<tU8>& data );

   bool isCreated(void) const { return ((mSocketHandle <= 0) ? false:true); }
   bool isConnected ( void ) const { return mIsConnected; }
   bool isBound ( void ) const { return mIsBound; }
   virtual bool isReady ( void ) const;

   const SocketConfiguration* getConfiguration ( void ) const { return mpConfig; }

protected:
   INCSocket( void );

protected:
   int mSocketHandle;
#ifdef USE_DGRAM_SERVICE
   sk_dgram* mDgram;
#endif

   SocketConfiguration* mpConfig;
   //bool mIsCreated;
   bool mIsConnected;
   bool mIsBound;
};

// factotry object
INCSocket* createObjectINCSocket ( SocketConfiguration& config );

}

#endif /* __INCLUDED_DIA_SOCKET__ */
