/*
 * dia_SessionController.h
 *
 *  Created on: 04.05.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_SESSION_CONTROLLER__
#define __INCLUDED_DIA_SESSION_CONTROLLER__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_DEFINES_UDS__
#include <common/framework/protocols/uds/dia_defsUds.h>
#endif

#include <common/framework/fsm/generated/dia_SessionControlFSM.h>

class dia_EngineServer;
class dia_Session;
class dia_ISessionListener;
class dia_ServiceHandler;

class dia_SessionController
   : protected dia_SessionControlFSM::FsmBehaviour
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SessionController);

public:
   //! class constructor
   dia_SessionController ( dia_EngineServer& engine );
   //! class dectructor
   virtual ~dia_SessionController ( void );

   //! we use a two level construction and destruction process
   virtual tDiaResult setup ( void );
   //! we use a two level construction and destruction process
   virtual tDiaResult shutdown ( void );

   //! enable/disable suppress positive response bit
   virtual void vSuppressPositiveResponseMode ( tBool mode ) { mSuppressPositiveResponseMode = mode; }

   //! request fallback to default session (asynchronous)
   virtual tDiaResult setSessionDefault ( void ) const;
   //! set the specified session as new active session
   virtual tDiaResult setSession ( tU8 newSession );
   //! timeout during setSession
   virtual void onSetSessionTimeout ( void );
   //! return the active session
   virtual tU8 getSessionID ( void ) const;
   //! query for a pointer to the specified session. If no pointer is specified the default session will be returned
   virtual tDiaResult querySession ( dia_Session** pSession, tU8 sessionID=DIA_C_U8_UDS_SESSION_INVALID );
   //! check if the given session is supported by the diagnosis component
   virtual tBool isSessionSupported ( tU8 newSession ) const;
   //! check if the given session is supported by the diagnosis component
   virtual tBool isDefaultSession ( void ) const;
   //! check if the given session is supported by the diagnosis component
   virtual tBool isDefaultSession ( const dia_Session* pSession ) const;

   //! return the event status mask of the active session
   virtual tDiaResult getSessionEventStatus( OSAL_tEventMask* pMask ) const;
   //! set an event for the active session
   virtual tDiaResult setSessionEvent( OSAL_tEventMask mask, OSAL_tenEventMaskFlag enFlags );

   //! return the identifier of the currently activated session
   virtual dia_Session* getActiveSession ( void ) { return mActiveSession; }

   //! register a session listener
   virtual tBool addListener ( dia_ISessionListener* pListener );
   //! unregister a session listener
   virtual tBool removeListener ( dia_ISessionListener* pListener );


   //! load supported sessions
   virtual tDiaResult loadSessions ( const std::vector<tU8>& supportedSessions );

   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler );
   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<tArgsType>& vecArgs );
   //! method used to populate the engine with service handlers
   virtual tDiaResult bAddServiceHandler ( dia_ServiceHandler* pHandler, const std::vector<tU8>& vecSessions, const std::vector<tArgsType>& vecArgs );
   //! notification about an update on the given session object
   virtual void vOnSessionUpdate ( dia_Session& session );

protected:
    //! class constructor
    dia_SessionController ( void );

    virtual void vInitialize ( void );

    // FSM actions
    virtual void vFsmReset ( void* pArg );
    virtual void vFsmEnterSession ( void* pArg );
    virtual void vFsmSetActiveSession ( void* pArg );
    virtual void vFsmNotifySessionChange ( void* pArg );
    virtual void vFsmSetLastSession ( void* pArg );
    virtual void vFsmLeaveSession ( void* pArg );

    // FSM guards
    virtual bool bIsSessionChangeRequired ( void* pArg );

protected:
    //! reference to the associated engine
    dia_EngineServer& mEngine; //lint !e1725 Info: class member is a reference, but usage of default copy constructor and assignment operator is prevented

    //! pointer to the FSM object
    dia_SessionControlFSM::Fsm* mpFSM;

    //! suppress positive response mode
    tBool mSuppressPositiveResponseMode;

    //! ID of the default session
    tU8 mDefaultSessionID;
    //! active session
    dia_Session* mActiveSession;
    //! previous session used notify listeners about the old and the new session
    dia_Session* mPreviousSession;
    //! session to enter
    dia_Session* mSessionToEnter;
    //! map of supported sessions
    std::map<tU8,dia_Session*> mSessionRep;
    //! repository of session listeners
    std::list<dia_ISessionListener*> mListenerRep;
};


#endif /* __INCLUDED_DIA_SESSION_CONTROLLER__ */
