/*
 * \file        dia_SelftestController.h
 *
 * \brief       This code controls selftest procedure for all external components
 *
 * \details     {insert file description here}
 *
 * \author      kaa1hi
 * \date        Nov 27, 2014
 *
 * \copyright   Robert Bosch Car Multimedia 2014
 */

#ifndef DIA_SELFTESTCONTROLLER_H_
#define DIA_SELFTESTCONTROLLER_H_

#ifndef __INCLUDED_DIA_COMMON__
#include "common/depricated/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_SELFTESTCONTROLLERFSM__
#include "common/framework/fsm/generated/dia_SelftestControllerFSM.h"
#endif

#ifndef DIA_SELFTESTCONTROLLERPLUGIN_H_
#include "common/framework/application/dia_SelftestControllerPlugin.h"
#endif

#ifndef DIA_SAFEATURESELFTESTCONTROLLERENUM_H_
#include "project/framework/sysadapters/dia_SAFeatureSelftestControllerEnum.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_SELFTESTCONTROLLER__
#include "common/interfaces/dia_ISelftestController.h"
#endif


//-----------------------------------------------------------------------------

class dia_SelftestController
   : public dia_ISelftestController,
     protected dia_SelftestControllerFSM::FsmBehaviour
{
   DECL_DEPRECATED_COPYCONSTRUCTOR_AND_ASSIGNMENTOPERATOR(dia_SelftestController);
public:
   //! singleton constructor
   static dia_SelftestController* getInstance ( tVoid );
   //! singleton constructor
   static tVoid deleteInstance ( tVoid );

   //
   // its own methods
   //

   //! retrieve the current remote control state
   virtual tVoid vOnSelftestControllerPluginUpdate ( dia_SelftestControllerPlugin& plugin );
   //! return information that all expected responses have been received
   virtual bool bAllResponsesReceived(void) const;

   //! install a selftest handler
   virtual tDiaResult addSelftestControllerPlugin ( dia_SelftestControllerPlugin* pPlugin );
   //! remove a selftest handler
   virtual tDiaResult removeSelfTestControllerPlugin ( dia_eSelftestControllerPluginType uniqueSelfTestId );

   //
   // overloaded methods from dia_ISelftestController
   //

   //! start selftest for the system
   virtual tDiaResult startSelfTests ( void  );

   //! Send status request to all components that were in IN_PROGRESS state last time
   //!
   //! @return DIA_SUCCESS on success, otherwise DIA_FAILED.
   virtual tDiaResult requestSelfTestStatusIfInProgress ( void );

protected:
   //! constructor
   dia_SelftestController ( tVoid );
   //! destructor
   virtual ~dia_SelftestController ( tVoid );

   //! setup (create objects,...)
   tDiaResult setup ( tVoid );
   //! tear down (destroy objects,...)
   tDiaResult tearDown ( tVoid );

   //! get result of selftest (collect responses from plugins)
   //!
   //! @return DIA_SUCCESS on success, otherwise DIA_FAILED.
   //! @param[out] DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_IN_PROGRESS if one of plugins is in IN_PROGRESS state.
   //! @param[out] DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_COMPLETED_NOK if none of plugins is in IN_PROGRESS state and
   //!         one of plugins is in COMPLETED_NOK state.
   //! @param[out] DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_ABORTED if one of plugins is in ABORTED state.
   //! @param[out] DIA_EN_SELFTESTCONTROLLER_RESULT_TYPE_COMPLETED_OK if all plugins are in COMPLETED_OK state.
   virtual tDiaResult getSelfTestResult ( dia_eSelftestControllerResultType* result );

   //
   // overloaded methods from dia_SelftestControllerFSM::FsmBehaviour
   //
   virtual void vFsmHandleError ( void* pArg );
   virtual void vFsmRequestResultFailed ( void* pArg );
   virtual void vFsmStopFailed ( void* pArg );
   virtual void vFsmRequestSelftest ( void* pArg );
   virtual void vFsmSelftestInProgress ( void* pArg );
   virtual void vFsmRequestSuccess ( void* );
   virtual void vFsmRequestFailure ( void* );
   virtual void vFsmStartFailed ( void* pArg );
   virtual void vFsmRequestResultInProgress ( void* pArg );
   virtual void vFsmStopSelftest ( void* pArg );
   virtual void vFsmStopDone ( void* pArg );
   virtual void vFsmSelftestFailed ( void* pArg );
   virtual void vFsmSelftestDone ( void* pArg );
   virtual void vFsmRequestResult ( void* pArg );

protected:
   //! pointer to the singleton object
   static dia_SelftestController* mpInstance;

   //! collective result of selftest for all plugins
   dia_eSelftestControllerResultType mSelftestResult;

   //! pointer to the FSM object
   dia_SelftestControllerFSM::Fsm* mpFSM;  //lint -sem( dia_SelftestController::tearDown, cleanup )

   //! repository of selftest controller plugins as pairs (unique 32bit ID of plugin, pointer to plugin)
   std::map<dia_eSelftestControllerPluginType,dia_SelftestControllerPlugin*> mPluginRep;
};

#endif /* DIA_SELFTESTCONTROLLER_H_ */
