/*
 * dia_RemoteControlPlugin.h
 *
 *  Created on: 18.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#define __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__

#ifndef __INCLUDED_DIA_COMMON__
#include "common/framework/application/dia_common.h"
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REMOTECONTROL__
#include "common/interfaces/dia_IRemoteControl.h"
#endif

// DO NOT EDIT. THIS ENUMERATION IS ONLY RETAINED FOR BACKWARD COMPATIBILITY REASONS
enum dia_eRemoteControlPluginType
{
   DIA_EN_REMOTE_PLUGIN_UNKNOWN = 0,
   DIA_EN_REMOTE_PLUGIN_HMI,
   DIA_EN_REMOTE_PLUGIN_AUDIO,
   DIA_EN_REMOTE_PLUGIN_TUNER_AMFM,
   DIA_EN_REMOTE_PLUGIN_TUNER_DAB,
   DIA_EN_REMOTE_PLUGIN_AUDIO_MANAGER,
   DIA_EN_REMOTE_PLUGIN_TUNER_MASTER,
   DIA_EN_REMOTE_PLUGIN_AUDIO_COMPRESSED,
   DIA_EN_REMOTE_PLUGIN_UT,
   DIA_EN_REMOTE_PLUGIN_COUNT
};

/**
 * \class   dia_RemoteControlPlugin
 *
 * \brief
 *
 * \ingroup diaCoreRemoteControl
 */

class dia_RemoteControlPlugin
{
   friend class dia_RemoteControl;

public:
   //! class constructor
   dia_RemoteControlPlugin ( tCString name, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT );
   //! class destructor
   virtual ~dia_RemoteControlPlugin ( void );

   //! retrieve the levels name
   virtual tCString getName ( void ) const;
   //! return the unique identifier of the signal
   virtual dia_UID getUID ( void ) const;
   //! return the remote control mode of the plugin
   virtual dia_eRemoteCtrlMode eGetMode ( void ) const;
   //! return the remote control mode of the plugin
   virtual dia_eRemoteCtrlMode eGetPreviousMode ( void ) const;

   //! activate remote control
   virtual tDiaResult requestRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT ) = 0;

protected:
   //##########################################################################
   //#
   //# DEPRECATED METHODS (DO NOT USE !!)
   //#
   //##########################################################################

   //! deprecated class constructor as type dia_eRemoteControlPluginType is obsolete
   dia_RemoteControlPlugin ( tCString name, dia_eRemoteControlPluginType id );

protected:
   //! class constructor
   dia_RemoteControlPlugin ( void );

   //! update the remote control mode of this plugin
   virtual void vOnRemoteControlUpdate ( dia_eRemoteCtrlMode activeMode );

protected:
   //! name of the service handler
   tCString mRemoteCtrlPluginName;
   //! unique ioctrl identifier
   dia_UID mUID;
//   //! id of the currently activated security level
//   dia_eRemoteControlPluginType mRemoteCtrlPluginID;
   //! current remote control mode of the plugin
   dia_eRemoteCtrlMode mActiveMode;
   //! last remote control mode of the plugin
   dia_eRemoteCtrlMode mPreviousMode;
   //! plugin settings
   dia_RemoteControlSettings mSettings;
};

#endif /* __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__ */
