/*
 * dia_RemoteControlPlugin.cpp
 *
 *  Created on: 18.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_REMOTECONTROL__
#include "common/framework/application/dia_RemoteControl.h"
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include "common/framework/application/dia_RemoteControlPlugin.h"
#endif

#ifndef __INCLUDED_DIA_HASH_CALCULATOR__
#include <common/framework/utils/dia_HashCalculator.h>
#endif

//-----------------------------------------------------------------------------

dia_RemoteControlPlugin::dia_RemoteControlPlugin (
      tCString name,
      dia_eRemoteControlPluginType
   )
   : mRemoteCtrlPluginName(name),
     mActiveMode(DIA_EN_REMOTE_CONTROL_MODE_UNKNOWN),
     mPreviousMode(DIA_EN_REMOTE_CONTROL_MODE_UNKNOWN),
     mSettings(DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT)
{
   DIA_TR_ERR("##### dia_RemoteControlPlugin::dia_RemoteControlPlugin ( tCString name, dia_eRemoteControlPluginType ) IS OBSOLETE !! #####");
   DIA_TR_ERR("##### PLEASE USE dia_RemoteControlPlugin::dia_RemoteControlPlugin ( tCString name ) INSTEAD. UNIQUE ID WILL BE GENERATED FROM OBJECT NAME !! #####");
   mUID = dia_getHashCodeFromString(mRemoteCtrlPluginName);
}

//-----------------------------------------------------------------------------

dia_RemoteControlPlugin::dia_RemoteControlPlugin (
      tCString name,
      dia_RemoteControlSettings settings
   )
   : mRemoteCtrlPluginName(name),
     mActiveMode(DIA_EN_REMOTE_CONTROL_MODE_UNKNOWN),
     mPreviousMode(DIA_EN_REMOTE_CONTROL_MODE_UNKNOWN),
     mSettings(settings)
{
   mUID = dia_getHashCodeFromString(mRemoteCtrlPluginName);
}

//-----------------------------------------------------------------------------

dia_RemoteControlPlugin::~dia_RemoteControlPlugin ( void )
{
   mRemoteCtrlPluginName = 0;
}

//-----------------------------------------------------------------------------

tCString
dia_RemoteControlPlugin::getName ( void ) const
{
   return mRemoteCtrlPluginName;
}

//------------------------------------------------------------------------------

dia_UID
dia_RemoteControlPlugin::getUID ( void ) const
{
   return mUID;
}

//-----------------------------------------------------------------------------

dia_eRemoteCtrlMode
dia_RemoteControlPlugin::eGetMode ( void ) const
{
   dia_tclFnctTrace oTrace("dia_RemoteControlPlugin::eGetMode()");
   return mActiveMode;
}

//-----------------------------------------------------------------------------

dia_eRemoteCtrlMode
dia_RemoteControlPlugin::eGetPreviousMode ( void ) const
{
   return mPreviousMode;
}

//-----------------------------------------------------------------------------

void
dia_RemoteControlPlugin::vOnRemoteControlUpdate ( dia_eRemoteCtrlMode activeMode )
{
   dia_tclFnctTrace oTrace("dia_RemoteControlPlugin::vOnRemoteControlUpdate()");
   mPreviousMode = mActiveMode;
   mActiveMode   = activeMode;
   getInstanceOfRemoteControl()->vOnRemoteControlPluginUpdate(*this);
}

