/*
 * dia_RemoteControl.h
 *
 * \defgroup diaCoreRemoteControl   Remote Control
 * \ingroup  diaCore
 *
 *  Created on: 18.07.2012
 *      Author: gib2hi
 */

#ifndef __INCLUDED_DIA_REMOTECONTROL__
#define __INCLUDED_DIA_REMOTECONTROL__

#ifndef __INCLUDED_DIA_COMMON__
#include <common/framework/application/dia_common.h>
#endif

#ifndef __INCLUDED_DIA_REMOTECONTROLFSM__
#include <common/framework/fsm/generated/dia_RemoteControlFSM.h>
#endif

#ifndef __INCLUDED_DIA_REMOTE_CONTROL_PLUGIN__
#include <common/framework/application/dia_RemoteControlPlugin.h>
#endif

#ifndef __INCLUDED_DIA_INTERFACE_REMOTECONTROL__
#include <common/interfaces/dia_IRemoteControl.h>
#endif

//-----------------------------------------------------------------------------

class dia_RemoteControl
   : public dia_IRemoteControl,
     protected dia_RemoteControlFSM::FsmBehaviour
{
   DECL_SINGLETON_CONSTRUCTOR_AND_DESTRUCTOR(dia_RemoteControl);

public:
   //! install a signal handler
   tDiaResult addRemoteControlPlugin ( dia_RemoteControlPlugin* pPlugin );
   //! install a signal handler
   tDiaResult removeRemoteControlPlugin ( dia_UID uid );
   //! return number of registered plugins
   virtual tU16 numberOfRemoteControlPlugins ( void ) const;

   //--------------------------------------------------------------------------
   // Methods inherited from dia_IRemoteControl
   //--------------------------------------------------------------------------

   //! activate the remote control of the ECU
   virtual tDiaResult setRemoteControlMode ( dia_eRemoteCtrlMode mode, dia_RemoteControlSettings settings = DIA_C_U32_REMOTE_CTRL_SETTINGS_DEFAULT);
   //! retrieve the current remote control state
   virtual dia_eRemoteCtrlMode getRemoteControlMode ( void );
   //! retrieve the current remote control state
   virtual dia_RemoteControlSettings getRemoteControlSettings ( void ) { return  mRemoteControlSettings; }


   //! update from plugin
   virtual void vOnRemoteControlPluginUpdate ( dia_RemoteControlPlugin& plugin );
   //! Handles the timeout
   virtual void handleTimeout(void);

protected:
   //! constructor
   dia_RemoteControl ( void );
   //! destructor
   virtual ~dia_RemoteControl ( void );

   //! setup (create objects,...)
   tDiaResult setup ( void );
   //! tear down (destroy objects,...)
   tDiaResult tearDown ( void );

   // FSM actions
   virtual void vFsmSetErrCode_Timeout ( void* pArg );
   virtual void vFsmReset ( void* pArg );
   virtual void vFsmSetErrCode_OK ( void* pArg );
   virtual void vFsmResultReady ( void* pArg );
   virtual void vFsmPrepare ( void* pArg );
   virtual void vFsmSetModeON ( void* pArg );
   virtual void vFsmEvaluateResponse ( void* pArg );
   virtual void vFsmSetModeOFF ( void* pArg );
   virtual void vFsmActivatePlugin ( void* pArg );
   virtual void vFsmDeactivatePlugin ( void* pArg );
   virtual void vFsmSetNextPlugin ( void* pArg );
   virtual void vFsmSetNextDeactivationPlugin ( void* /*pArg*/ );
   virtual void vFsmSetActivatedPlugin ( void* pArg );
   virtual void vFsmPrepareDeactivation ( void* pArg );
   virtual void vFsmNotify ( void* /* pArg */ );

   // FSM guards
   virtual bool bIsActivationComplete ( void* pArg );
   virtual bool bIsActivationFailed ( void* pArg );
   virtual bool bIsDeactivationComplete ( void* pArg );

protected:
   //! current state of remote control
   dia_eRemoteCtrlMode mRemoteControlMode;
   //! previous state of remote control
   dia_eRemoteCtrlMode mPrevRemoteControlMode;
   //! error code information
   tDiaResult mErrorCode;
   //! flag to indicate if activation/deactivation is complete
   tBool mIsResultReady;

   //! pointer to the FSM object
   dia_RemoteControlFSM::Fsm* mpFSM; //lint -sem( dia_RemoteControl::tearDown, cleanup )

   //! repository of remote plugins
   std::map<dia_UID,dia_RemoteControlPlugin*> mPluginRep;
   //! repository of Activated remote plugins
   std::map<dia_UID,dia_RemoteControlPlugin*> mPluginActivatedRep;
   //! current plugin to be activated
   std::map<dia_UID,dia_RemoteControlPlugin*>::iterator mPluginIter;
   //! current plugin to be deactivated
   std::map<dia_UID,dia_RemoteControlPlugin*>::iterator mPluginIterActive;
   //! settings of remote control
   dia_RemoteControlSettings mRemoteControlSettings;
};

dia_RemoteControl* getInstanceOfRemoteControl ( void );
void releaseInstanceOfRemoteControl ( void );

#endif /* __INCLUDED_DIA_REMOTECONTROL__ */
